#include "jdp_extended.h"
#include "test_config.h"
#include "linflex_common.h"

int8_t LINFLEX_1_WakeupReceived=0;
int8_t LINFLEX_1_HeaderReceived=0;
int8_t LINFLEX_1_DataReceived=0;
int8_t LINFLEX_1_DataTransmitted=0;
int16_t LINFLEX_1_ErrorReceived[2];
int16_t LINFLEX_1_LINStatus=0;

int16_t LINFLEX_1_Nb_of_ReceivedWakeup=0;
int16_t LINFLEX_1_Nb_of_ReceivedHeader=0;
int16_t LINFLEX_1_Nb_of_ReceivedResponse=0;

int16_t LINFLEX_1_Nb_of_TransmittedResponse=0;

//extern int32_t TxResponseL;
//extern int32_t TxResponseM;

vint8_t ReceivedIdentifier;

uint8_t ResponseToBeSent[8];
uint8_t ReceivedResponse2[160];
uint8_t *ReceivedResponse2_ptr = ReceivedResponse2;
uint8_t ReceivedResponse3[16];
uint8_t index;

vint8_t slave_TestDLC=1;
vint8_t slave_TestID=7;

static uint8_t incr=0;

int8_t ErrorFlag_slave_TestID=0;
int8_t ErrorFlag_slave_TestDLC=0;
int8_t ErrorFlag_slave_Response=0;

void LINFLEX_LIN_Slave_Init(vuint8_t LINFlex_Index, vuint16_t Baudrate)
{
	LINFlex_ConfigurePads(LINFlex_Index);

	LINFLEX(LINFlex_Index).LINCR1.B.SLEEP = 0; /* exit sleep mode */
	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 1;  /* enter initialization mode */

	LINFLEX(LINFlex_Index).LINCR1.B.MME = 0;   /* Select Slave mode */
	LINFLEX(LINFlex_Index).LINCR1.B.MBL = 3;   /* Deepak - 13-bit break */
	LINFLEX(LINFlex_Index).LINCR1.B.LASE = 0;
	LINFLEX(LINFlex_Index).LINCR2.B.IOBE = 0;  /* Deepak */

	LINFLEX(LINFlex_Index).LINIER.B.HRIE = 1;  /* Header received interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DTIE = 1;  /* Data transmission interrupt enable */
 	LINFLEX(LINFlex_Index).LINIER.B.DRIE = 1;  /* Data reception complete interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.WUIE = 1;  /* Wake up interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.FEIE = 1;  /* Framing error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.HEIE = 1;  /* Header interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.CEIE = 1;  /* Checksum error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.BEIE = 1;  /* Bit error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.OCIE = 1;  /* Output compare interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DBFIE = 1;  /* Data Buffer Full interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DBEIE = 1;  /* Data Buffer Empty interrupt enable */

	LINFLEX(LINFlex_Index).LINTCSR.B.MODE = 0; /* Select LIN timeout mode for 8-bit counter */
	LINFLEX(LINFlex_Index).LINTCSR.B.IOT = 0;  /* LIN state machine will ignore timeouts */

	LINFlex_ChangeBaudrate(LINFlex_Index, FREQ, Baudrate);

	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 0;  /* enter normal mode */

	LINFLEX(LINFlex_Index).LINSR.R = 0xF23F;   /* Clear all flags */
}

int8_t LINFLEX_LIN_Slave_Receive_Header (vuint8_t LINFlex_Index)
{
	if (LINFLEX(LINFlex_Index).LINSR.B.HRF==1)
	{
		LINFLEX(LINFlex_Index).LINSR.B.HRF=0;
		return 1;
	}
	else
	{
		return 0;
	}
}

int8_t LINFLEX_LIN_Slave_Get_Identifier (vuint8_t LINFlex_Index)
{
	return (LINFLEX(LINFlex_Index).BIDR.B.ID); /* Return Protected Identifier */
}

void LINFLEX_LIN_Slave_Refill_Buffer (vuint8_t LINFlex_Index, int8_t DataFieldLength, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index;

	for (index=0;index<DataFieldLength;index++)
	{
		if (index<4) ResponseL += ( (int32_t) (*(Response+index)) ) << (8*index);
		else ResponseM += ( (int32_t) (*(Response+index)) ) << (8*(index-4));
	}

	/* Fill Buffer */
	LINFLEX(LINFlex_Index).BDRL.R = ResponseL;
	LINFLEX(LINFlex_Index).BDRM.R = ResponseM;
}


void LINFLEX_LIN_Slave_Send_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, int8_t ChecksumType, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index, BufferLength;

	BufferLength = DataFieldLength;
	if (BufferLength>8) BufferLength=8;

	for (index=0;index<BufferLength;index++)
	{
		if (index<4) ResponseL += ( (int32_t) (*(Response+index)) ) << (8*index);
		else ResponseM += ( (int32_t) (*(Response+index)) ) << (8*(index-4));
	}

	/* Fill Buffer */
	LINFLEX(LINFlex_Index).BDRL.R = ResponseL;
	LINFLEX(LINFlex_Index).BDRM.R = ResponseM;

	LINFLEX(LINFlex_Index).BIDR.B.DFL = DataFieldLength-1; /* Configure DFL in BIDR */

	LINFLEX(LINFlex_Index).BIDR.B.CCS = ChecksumType; /* Configure checksum type in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 1; /* Set direction bit in BIDR */

	LINFLEX(LINFlex_Index).LINCR2.B.DTRQ = 1; /* Trigger Response (data) transmission */
}

void LINFLEX_LIN_Slave_Receive_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, int8_t ChecksumType)
{
	LINFLEX(LINFlex_Index).BIDR.B.DFL = DataFieldLength-1; /* Configure DFL in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.CCS = ChecksumType; /* Configure checksum type in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 0; /* Reset direction bit in BIDR */
}

void LINFLEX_LIN_Slave_Get_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index;

	ResponseL = LINFLEX(LINFlex_Index).BDRL.R;
	ResponseM = LINFLEX(LINFlex_Index).BDRM.R;

	for (index=0;index<DataFieldLength;index++)
	{
		if (index<4) *(Response+index) = (int8_t) ( ResponseL  >> (8*index) );
		else *(Response+index) = (int8_t) ( ResponseM >> (8*(index-4)) );
	}
}

void LINFLEX_LIN_Slave_Discard_Response(vuint8_t LINFlex_Index)
{
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 0; /* Reset direction bit in BIDR */
	LINFLEX(LINFlex_Index).LINCR2.B.DDRQ = 1; /* Discard Response (data)*/
}

void LIN_Slave_AbortFrame(vuint8_t LINFlex_Index)
{
	LINFLEX(LINFlex_Index).LINCR2.B.ABRQ = 1; /* Abort Frame */
}


/* LINFLEX_1 RX interrupt service routine*/
void LINFLEX_LIN_Slave_RX_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[6].R = 1;

	LINFLEX_1_LINStatus = LINFLEX(LINFlex_Index).LINSR.R;

	/* wake-up flag */
	if (LINFLEX(LINFlex_Index).LINSR.B.WUF)
	{
		LINFLEX_1_WakeupReceived = 1;
		LINFLEX_1_Nb_of_ReceivedWakeup++;
		LINFLEX(LINFlex_Index).LINSR.R |= 0x20;
	}

	ReceivedIdentifier = LINFLEX_LIN_Slave_Get_Identifier(LINFlex_Index);

	/* Header received */
	if (LINFLEX(LINFlex_Index).LINSR.B.HRF)
	{
		LINFLEX_1_HeaderReceived = 1;
		LINFLEX_1_Nb_of_ReceivedHeader++;

		switch (ReceivedIdentifier)
		{
			case 0x01:
				/* Receive Response */
				LINFLEX_LIN_Slave_Receive_Response(LINFlex_Index,8,0);
				break;

			case 0x02:
				/* Send Response */
				ResponseToBeSent[0]='A';
				ResponseToBeSent[1]='B';
				ResponseToBeSent[2]='C';
				ResponseToBeSent[3]='D';
				ResponseToBeSent[4]='E';
				ResponseToBeSent[5]='F';
				ResponseToBeSent[6]='G';
				ResponseToBeSent[7]='H';
				LINFLEX_LIN_Slave_Send_Response(LINFlex_Index, 2, 0, ResponseToBeSent);
				break;

			case 0x03:
				/* Send Response */
				ResponseToBeSent[0]='A';
				ResponseToBeSent[1]='B';
				ResponseToBeSent[2]='C';
				ResponseToBeSent[3]='D';
				ResponseToBeSent[4]='E';
				ResponseToBeSent[5]='F';
				ResponseToBeSent[6]='G';
				ResponseToBeSent[7]='H';
				LINFLEX_LIN_Slave_Send_Response(LINFlex_Index, 8, 0, ResponseToBeSent);
				break;

			case 0x04:
				/* Receive Response */
				LINFLEX_LIN_Slave_Receive_Response(LINFlex_Index,8,0);
				break;

			case 0x05:
				/* Send Response */
				ResponseToBeSent[0]='p';
				ResponseToBeSent[1]='q';
				ResponseToBeSent[2]='r';
				ResponseToBeSent[3]='s';
				ResponseToBeSent[4]='t';
				ResponseToBeSent[5]='u';
				ResponseToBeSent[6]='v';
				ResponseToBeSent[7]='w';

				LINFLEX_LIN_Slave_Send_Response(LINFlex_Index, 64, 0, ResponseToBeSent);
				break;

			case 0x06:
				/* Receive longer than transmitted response */
				LINFLEX_LIN_Slave_Receive_Response(LINFlex_Index,8,0);
				break;

			case 0x10:
				/* Receive Response */
				LINFLEX_LIN_Slave_Receive_Response(LINFlex_Index,64,0);
				break;

			default:
				/* Receive Response */
				LINFLEX_LIN_Slave_Receive_Response(LINFlex_Index,slave_TestDLC,0);
				break;
		}
	}

	/* Data */
	if (LINFLEX(LINFlex_Index).LINSR.B.DRF)
	{
		LINFLEX_1_Nb_of_ReceivedResponse++;

		switch (ReceivedIdentifier)
		{
			case 0x01:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2);
				break;

			case 0x04:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2_ptr);
				LINFLEX_1_DataReceived = 1;
				ReceivedResponse2_ptr = ReceivedResponse2_ptr + 8;
				break;

			case 0x06:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2_ptr);
				LINFLEX_1_DataReceived = 1;
				ReceivedResponse2_ptr = ReceivedResponse2_ptr + 8;
				break;

			case 0x7:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2_ptr);
				break;

			case 0x8:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2);
				break;

			case 0x10:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2_ptr);
				break;

			default:
				LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, slave_TestDLC, ReceivedResponse2);
				if (slave_TestID != (uint8_t)ReceivedIdentifier)
				{
					ErrorFlag_slave_TestID=1;
				}
				for (index=0;index<slave_TestDLC;index++)
				{
					if (ReceivedResponse2[index] != (uint8_t)(index+incr))
					{
						ErrorFlag_slave_Response=1;
					}
				}
				incr++;
				break;
		}
	}

	/* Extended Frame Data Received */
	if (LINFLEX(LINFlex_Index).LINSR.B.DBFF)
	{
		LINFLEX_LIN_Slave_Get_Response (LINFlex_Index, 8, ReceivedResponse2_ptr);
		ReceivedResponse2_ptr = ReceivedResponse2_ptr + 8;
	}

	/* Clear all flags */
	LINFLEX(LINFlex_Index).LINSR.R = 0xF23F;

	SIU.GPDO[6].R = 0;
}


/* LINFLEX_1 ERR interrupt service routine*/
void LINFLEX_LIN_Slave_ERR_ISR(vuint8_t LINFlex_Index)
{
	static uint8_t index = 0;
	SIU.GPDO[7].R = 1;

	/* LIN error*/
	if (LINFLEX(LINFlex_Index).LINESR.R)
	{
		LINFLEX_1_ErrorReceived[index] |= LINFLEX(LINFlex_Index).LINESR.R;
		index++;

		ReceivedIdentifier = LINFLEX_LIN_Slave_Get_Identifier(LINFlex_Index);

		if (ReceivedIdentifier == 0x06)
		{
			LINFLEX_1_DataReceived = 1;
		}
	}

	/* Clear all flags */
	LINFLEX(LINFlex_Index).LINESR.R = 0xFF81;

	SIU.GPDO[7].R = 0;
}


/* LINFLEX_1 TX interrupt service routine*/
void LINFLEX_LIN_Slave_TX_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[8].R = 1;

	if (LINFLEX(LINFlex_Index).LINSR.B.HRF)
	{
		/* Send Response */
		ResponseToBeSent[0]='A';
		ResponseToBeSent[1]='B';
		ResponseToBeSent[2]='C';
		ResponseToBeSent[3]='D';
		ResponseToBeSent[4]='E';
		ResponseToBeSent[5]='F';
		ResponseToBeSent[6]='G';
		ResponseToBeSent[7]='H';
		LINFLEX_LIN_Slave_Refill_Buffer (LINFlex_Index, 8, ResponseToBeSent);
		LINFLEX(LINFlex_Index).LINCR2.B.DTRQ = 1; /* Trigger Response (data) transmission */
	}

	if (LINFLEX(LINFlex_Index).LINSR.B.DTF)
	{
		LINFLEX_1_DataTransmitted = 1;
		LINFLEX_1_Nb_of_TransmittedResponse++;
	}

	if (LINFLEX(LINFlex_Index).LINSR.B.DBEF)
	{
		uint8_t SlaveResponseToBeSent[8];
		static uint8_t i = 1;

		SlaveResponseToBeSent[0] = 'p' + i;
		SlaveResponseToBeSent[1] = 'q' + i;
		SlaveResponseToBeSent[2] = 'r' + i;
		SlaveResponseToBeSent[3] = 's' + i;
		SlaveResponseToBeSent[4] = 't' + i;
		SlaveResponseToBeSent[5] = 'u' + i;
		SlaveResponseToBeSent[6] = 'v' + i;
		SlaveResponseToBeSent[7] = 'w' + i;

		i++;

		LINFLEX_LIN_Slave_Refill_Buffer (LINFlex_Index, 8, SlaveResponseToBeSent);
	}

	/* Clear all flags */
	LINFLEX(LINFlex_Index).LINSR.R = 0xF23F;

	SIU.GPDO[8].R = 0;
}
