#include "jdp_extended.h"
#include "test_config.h"

int8_t LINFLEX_UART_DataTransmitted=1;
vuint8_t LINFLEX_UART_DataReceived=0;
int8_t LINFLEX_UART_ErrorReceived=0;

uint8_t  Response_UART[1024];
uint8_t* Response_UART_ptr = Response_UART;

void LINFLEX_UART_Init(vuint8_t LINFlex_Index, vuint16_t Baudrate)
{

	LINFlex_ConfigurePads(LINFlex_Index);

	LINFLEX(LINFlex_Index).LINCR1.B.SLEEP = 0; /* exit sleep mode */
	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 1; /* enter initialization mode */

	LINFLEX(LINFlex_Index).LINIER.B.DTIE = 1; /* enable data transmission interrupt */
	LINFLEX(LINFlex_Index).LINIER.B.DRIE = 1; /* enable data reception interrupt */

	LINFLEX(LINFlex_Index).LINIER.B.SZIE = 1;
	LINFLEX(LINFlex_Index).LINIER.B.OCIE = 1;
	LINFLEX(LINFlex_Index).LINIER.B.FEIE = 1;
	LINFLEX(LINFlex_Index).LINIER.B.BOIE = 1;

	LINFLEX(LINFlex_Index).UARTCR.B.UART = 1; // UART Mode enable
	LINFLEX(LINFlex_Index).UARTCR.B.DTU  = 1;
	LINFLEX(LINFlex_Index).UARTCR.B.SBUR = 0; // 1 Stop Bit
	LINFLEX(LINFlex_Index).UARTCR.B.WLS  = 0;
	LINFLEX(LINFlex_Index).UARTCR.B.RFBM = 0; // 0 - Receive Buffer mode
	LINFLEX(LINFlex_Index).UARTCR.B.TFBM = 0; // 0 - Transmit Buffer mode
	LINFLEX(LINFlex_Index).UARTCR.B.PC1  = 0; // Even Parity
	LINFLEX(LINFlex_Index).UARTCR.B.PC0  = 0; // Even Parity
	LINFLEX(LINFlex_Index).UARTCR.B.PCE  = 1; // Parity transmit/check enable
	LINFLEX(LINFlex_Index).UARTCR.B.WL1  = 0; // 8 bit data + parity
	LINFLEX(LINFlex_Index).UARTCR.B.WL0  = 1; // 8 bit data + parity

	LINFlex_ChangeBaudrate(LINFlex_Index, FREQ, Baudrate);

	LINFLEX(LINFlex_Index).UARTSR.B.DRF = 1; /* clear DRF flag */

	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 0; /* enter normal mode */
}

void LINFLEX_UART_FIFO_Init(vuint8_t LINFlex_Index, vuint16_t Baudrate)
{

	LINFlex_ConfigurePads(LINFlex_Index);

	LINFLEX(LINFlex_Index).LINCR1.B.SLEEP = 0; /* exit sleep mode */
	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 1; /* enter initialization mode */

	LINFLEX(LINFlex_Index).LINIER.B.DTIE = 1; /* enable data transmission interrupt */
	LINFLEX(LINFlex_Index).LINIER.B.DRIE = 1; /* enable data reception interrupt */
	LINFLEX(LINFlex_Index).LINIER.B.SZIE = 1;
	LINFLEX(LINFlex_Index).LINIER.B.OCIE = 1;
	LINFLEX(LINFlex_Index).LINIER.B.FEIE = 1;
	LINFLEX(LINFlex_Index).LINIER.B.BOIE = 1;

	LINFLEX(LINFlex_Index).UARTCR.B.UART = 1; // UART Mode enable
	LINFLEX(LINFlex_Index).UARTCR.B.DTU  = 1;
	LINFLEX(LINFlex_Index).UARTCR.B.SBUR = 0; // 1 Stop Bit
	LINFLEX(LINFlex_Index).UARTCR.B.WLS  = 0;
	LINFLEX(LINFlex_Index).UARTCR.B.RFBM = 1; // Receive FIFO mode
	LINFLEX(LINFlex_Index).UARTCR.B.TFBM = 1; // Transmit FIFO mode
	LINFLEX(LINFlex_Index).UARTCR.B.PC1  = 0; // Even Parity
	LINFLEX(LINFlex_Index).UARTCR.B.PC0  = 0; // Even Parity
	LINFLEX(LINFlex_Index).UARTCR.B.PCE  = 1; // Parity transmit/check enable
	LINFLEX(LINFlex_Index).UARTCR.B.WL1  = 0; // 8 bit data + parity
	LINFLEX(LINFlex_Index).UARTCR.B.WL0  = 1; // 8 bit data + parity

	LINFlex_ChangeBaudrate(LINFlex_Index, FREQ, Baudrate);

//	LINFLEX(LINFlex_Index).UARTSR.B.DRF = 1; /* clear DRF flag */

	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 0; /* enter normal mode */
}

void LINFLEX_TxUART (vuint8_t LINFlex_Index, uint8_t* p_tx, uint8_t n_words)
{
	uint32_t ResponseL=0;

	LINFLEX(LINFlex_Index).UARTCR.B.TDFL = n_words-1;

	if (n_words == 1)
	{
		ResponseL = p_tx[0];
	}
	else if (n_words == 2)
	{
		ResponseL = p_tx[0] | (p_tx[1] << 8);
	}

	else if (n_words == 3)
	{
		ResponseL = (uint32_t) p_tx[0] + ( ((uint32_t)p_tx[1]) * 256) + ( ((uint32_t)p_tx[2]) * 65536);
	}

	else if (n_words == 4)
	{
		ResponseL = p_tx[0] | (p_tx[1] << 8) | (p_tx[2] << 16) | (p_tx[3] << 24);
	}

	LINFLEX(LINFlex_Index).BDRL.R = ResponseL;
}

void LINFLEX_TxUART_FIFO (vuint8_t LINFlex_Index, uint8_t* p_tx)
{
	uint8_t ResponseL=0;

	ResponseL = *p_tx;

	LINFLEX(LINFlex_Index).BDRL.B.DATA0 = ResponseL;
}

void LINFLEX_Init_Receive_Buffer (vuint8_t LINFlex_Index, int8_t n_words)
{
	LINFLEX(LINFlex_Index).UARTCR.B.RDFL = n_words-1; /* can be programmed only once UART bit is set */
}

void LINFLEX_UART_Get_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, uint8_t* Response)
{
	uint32_t ResponseM = 0;
	int8_t index;

	ResponseM = LINFLEX(LINFlex_Index).BDRM.R;

	for (index=0;index<DataFieldLength;index++)
	{
		*(Response+index) = (int8_t) ( ResponseM >> (8*(index)) );
	}
}


void LINFLEX_UART_Release_Buffer (vuint8_t LINFlex_Index)
{
	LINFLEX(LINFlex_Index).UARTSR.B.RMB=1;
}


/* RX interrupt service routine*/
void LINFLEX_UART_RX_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[9].R = 1;

	if (LINFLEX(LINFlex_Index).UARTSR.B.DRF)
	{
		LINFLEX_UART_Get_Response (LINFlex_Index, 4, Response_UART_ptr);
		Response_UART_ptr = Response_UART_ptr + 4;

		LINFLEX_UART_DataReceived = 1;
	}

	/* Clear flags */
	LINFLEX(LINFlex_Index).UARTSR.B.DRF = 1;

	SIU.GPDO[9].R = 0;
}

/* ERR interrupt service routine*/
void LINFLEX_UART_ERR_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[10].R = 1;

	/* error*/
	LINFLEX_UART_ErrorReceived |= LINFLEX(LINFlex_Index).UARTSR.R;

	/* Clear all flags */
	LINFLEX(LINFlex_Index).UARTSR.R = 0xFFE7;

	SIU.GPDO[10].R = 0;
}

/* TX interrupt service routine*/
void LINFLEX_UART_TX_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[11].R = 1;

	if (LINFLEX(LINFlex_Index).UARTSR.B.DTF)
	{
	}

	/* Clear flags */
	LINFLEX(LINFlex_Index).UARTSR.B.DTF=1;

	SIU.GPDO[11].R = 0;
}
