/*******************************************************************************
*
* File Name: appconfig.h
*
* Description: file for static configuration of the application
*              (initial values, interrupt vectors)
*
*****************************************************************************/

#ifndef __APPCONFIG_H
#define __APPCONFIG_H

/*.*************************************************************************
*
*  File generated by Graphical Configuration Tool Thu, 15/Aug/2013, 10:11:45
*
****************************************************************************.*/

#define MC56F82748
#define EXTCLK 8000000L
#define APPCFG_DFLTS_OMITTED 1
#define APPCFG_GCT_VERSION 0x02060b00L

/*.
    OCCS Configuration
--------------------------------------------
    Use Factory Trim Value: Yes
    Enable internal 32 kHz oscillator: No 
    Power Down crystal oscillator: Yes
    Core frequency: 50 MHz 
    VCO frequency: 200 MHz 
    Loss of lock interrupt 0: Disable 
    Loss of lock interrupt 1: Disable 
    Loss of reference clock Interrupt: Disable
.*/
#define OCCS_CTRL_INIT                    0x0081U
#define OCCS_DIVBY_INIT                   0x2018U
#define OCCS_USE_FACTORY_TRIM             1
#define OCCS_USE_FACTORY_TRIM_TEMP        1

/*.
    COP Configuration
--------------------------------------------
    COP clock source: Relaxation oscilator 
    COP operation: Disable
    COP timeout: 8.38848 sec 
    COP Runs in Stop Mode: No 
    COP Runs in Wait Mode: No 
    COP Write Protect: No 
    Enable Loss of Clock COP: No 
    Enable COP Warning Interrupt: No 
    COP Warning Interrupt Timeout: 32.64 ms 
    COP Window Timeout: 8.38848 sec
.*/
#define COP_COPCTL_INIT                   0x0300U

/*.
    SYS Configuration
--------------------------------------------
    SIM: Power Saving Modes: Stop enabled 
    Wait enabled 
         OnCE clock to processor core: Enabled when core TAP enabled 
    DMA Enable in RUN and WAIT modes: DMA enabled in all power modes 
    Enable Ext.Reset Input Filter: No , SIM - Clock on GPIO: Enable CLKO_0: No 
    SIM - Clock on GPIO: Enable CLKO_1: No 
    SIM - HS_PERF Peripheral Clk: PWM
    SIM - Peripheral Clock Enable: GPIO F: Yes, GPIO E: Yes, GPIO D: No , GPIO C: Yes, GPIO B: No , GPIO A: No , TMR A0: No 
                                   TMR A1: No , TMR A2: No , TMR A3: No , SCI0: No , SCI1: No , QSPI0: No , QSPI1: No , IIC: No , MSCAN: No 
                                   CMP A: Yes, CMP B: No , CMP C: No , CMP D: No , CYC ADC: No , CRC: No , QDC: No , PIT0: No , PIT1: No , DACA: Yes, DACB: No 
                                   PWMCH0: Yes, PWMCH1: Yes, PWMCH2: No , PWMCH3: No , SIM - Modules Enabled in Stop: GPIO F: No , SIM - Modules Enabled in Stop: GPIO E: No , SIM - Modules Enabled in Stop: GPIO D: No , SIM - Modules Enabled in Stop: GPIO C: No , SIM - Modules Enabled in Stop: GPIO B: No , SIM - Modules Enabled in Stop: GPIO A: No 
    SIM - Modules Enabled in Stop: TMR A0: No , TMR A1: No , TMR A2: No , TMR A3: No , 
                                   SCI0: No , SCI1: No , QSPI0: No , QSPI1: No , IIC: No , MSCAN: No 
                                   CMP A: No , CMP B: No , CMP C: No , CMP D: No , CYC ADC: No , CRC: No , QDC: No , PIT0: No , PIT1: No , DACA: No , DACB: No 
                                   PWMCH0: No , PWMCH1: No , PWMCH2: No , PWMCH3: No 
    Protection of IPS and GPSxx  : Registers not protected 
    Protection of PCE, SD and PCR: Registers not protected 
    Protection of GPIO Port D: Registers not protected 
    Protection of PWRMODE: Registers not protected 
    GPIO Peripheral select registers (GPSn): ANA0/CMPA3 
                                             ANB1/CMPB_IN0 
                                             EXTAL 
                                             XB_IN2 
                                             TA0 
                                             TA1 
                                             DACA 
                                             TA2 
                                             SS0_B 
                                             MOSI0 
                                             SCLK0 
                                             MOSI0 
                                             Reserved 
                                             Reserved 
                                             TA3 
                                             XB_OUT4 
                                             SCL0 
                                             PWMA_2B 
                                             PWMA_2A 
                                             PWMA_3B 
                                             PWMA_3A 
                                             XB_IN6 
                                             CLKOUT1 
                                             SCL0 
                                             XB_OUT7 
                                             XB_OUT8 
                                             RXD1 
                                             XB_IN2 
                                             XB_IN3 
                                             RXD0 
    Internal Peripheral Select Register 0 (IPS0): GPIOC3 
                                                  GPIOC4 
                                                  GPIOC6 
                                                  GPIOC13 
                                                  GPIOC3/GPIOC8/GPIOF8 
                                                  GPIOC12/GPIOF5 
    Miscellaneous Register 0 (SIM_MISC0): Disable
                                          Disable
                                          CLKIN0 (GPIOC0 alt1) 
                                          PIT0 master, PIT1 slave 
    SIM - Interrupts: Low voltage 2.2V: Disable
                      Low voltage 2.7V: Disable
                      High voltage 2.2V: Disable
                      High voltage 2.7V: Disable
    Enable Voltage Reference Buffer: No 
    Bandgap trim: 7, Use Factory Trim Value: No 
    Power Control: Large Regulator Standby mode: Normal 
                   Small Regulator 2.7 V Supply Standby mode: Normal 
                   Small Regulator 2.7 V Supply Powerdown mode: Normal 
                   Small Regulator 1.2 V Supply Standby mode: Normal
.*/
#define SIM_CLKOSR_INIT                   0x1020U
#define SIM_GPSCL_INIT                    0x0020U
#define SIM_GPSCH_INIT                    0x1000U
#define SIM_GPSFL_INIT                    0xB140U
#define SIM_PCE0_INIT                     0x0016U
#define SIM_PCE1_INIT                     0x2002U
#define SIM_PCE2_INIT                     0x1000U
#define SIM_PCE3_INIT                     0x00C0U

/*.
    INTC Configuration
--------------------------------------------
.*/
#define INTC_ICTL_INIT                    0x0000U
#define INT_VECTOR_ADDR_77                Extern_Fault_ISR
#define INT_PRIORITY_LEVEL_77             INTC_LEVEL1

/*.
    GPIO_C Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: XB_IN2 , PullUp: Disable , 
    Pin  3: Function: TA0 , PullUp: Disable , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  8: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  9: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 10: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 11: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 12: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 13: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 14: Function: XB_OUT4 , PullUp: Disable , 
    Pin 15: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_C_PER_INIT                   0x400CU

/*.
    GPIO_E Configuration
--------------------------------------------
    Pin  0: Function: PWM0B , PullUp: Disable , 
    Pin  1: Function: PWM0A , PullUp: Disable , 
    Pin  2: Function: PWM1B , PullUp: Disable , 
    Pin  3: Function: PWM1A , PullUp: Disable , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: PWM3A , PullUp: Disable ,
.*/
#define GPIO_E_PER_INIT                   0x008FU

/*.
    GPIO_F Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  3: Function: XB_OUT7 , PullUp: Disable , 
    Pin  4: Function: XB_OUT8 , PullUp: Disable , 
    Pin  5: Function: RXD1 , PullUp: Disable , 
    Pin  6: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  8: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_F_DDR_INIT                   0x0040U
#define GPIO_F_PER_INIT                   0x0038U
#define GPIO_F_DRIVE_INIT                 0x0018U

/*.
    XBAR_A Configuration
--------------------------------------------
    0. DMARequest0.: Logic0 
    1. DMARequest1.: Logic0 
    2. DMARequest2.: Logic0 
    3. DMARequest3.: Logic0 
    4. PackagePinGPIO_C14.: Logic0 
    5. PackagePinGPIO_C15.: Logic0 
    6. PackagePinGPIO_C8/GPIO_F2.: Logic0 
    7. PackagePinGPIO_F3.: GPIO_C2/GPIO_E4/GPIO_F6 
    8. PackagePinGPIO_C9/GPIO_F4.: CMPA_OUT 
    9. PackagePinGPIO_C10/GPIO_F5.: Logic0 
    10. PackagePinGPIO_F8.: Logic0 
    11. PackagePinGPIO_C2.: Logic0 
    12. ADCA(CyclicADC)Trigger.: Logic0 
    13. ADCB(CyclicADC)Trigger.: Logic0 
    14. 12-bitDACBSYNC_IN.: Logic0 
    15. 12-bitDACASYNC_IN.: PWMA0_TRIG0 
    16. ComparatorAWindow/Sample.: Logic0 
    17. ComparatorBWindow/Sample.: Logic0 
    18. ComparatorCWindow/Sample.: Logic0 
    19. ComparatorDWindow/Sample.: Logic0 
    20. PWM0externalinput.: Logic0 
    21. PWM1externalinput.: Logic0 
    22. PWM2externalinput.: Logic0 
    23. PWM3externalinput.: Logic0 
    24. PWM0ExternalSynchronizationsignal.: Logic0 
    25. PWM1ExternalSynchronizationsignal.: Logic0 
    26. PWM2ExternalSynchronizationsignal.: Logic0 
    27. PWM3ExternalSynchronizationsignal.: Logic0 
    28. PWMExternalClocksignal.: Logic0 
    29. PWMmoduleFAULT0.: GPIO_C2/GPIO_E4/GPIO_F6 
    30. PWMmoduleFAULT1.: CMPA_OUT 
    31. PWMmoduleFAULT2.: Logic0 
    32. PWMmoduleFAULT3.: Logic0 
    33. PWMExternalOutputForcesignal.: Logic0 
    34. QuadTimerA0Input.: Logic0 
    35. QuadTimerA1Input.: Logic0 
    36. QuadTimerA2Input.: Logic0 
    37. QuadTimerA3Input.: Logic0 
    38. SCI0RXD.: Logic0 
    39. SCI1RXD.: Logic0 
    40. ExternalWatchdogMonitor.: Logic0 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out0: No 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out1: No 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out2: No 
    Edge Detection: Never 
    Enable DMA: No 
    Enable Interrupt Out3: No
.*/
#define XBAR_A_SEL3_INIT                  0x0200U
#define XBAR_A_SEL4_INIT                  0x000AU
#define XBAR_A_SEL7_INIT                  0x1200U
#define XBAR_A_SEL14_INIT                 0x0200U
#define XBAR_A_SEL15_INIT                 0x000AU

/*.
    PWM_A_Common Configuration
--------------------------------------------
    Monitor PLL State: Not locked. No PLL check 
    Fault0 Level: Low 
    Fault1 Level: High 
    Fault2 Level: Low 
    Fault3 Level: Low 
    Fault0 Clearing: Manual 
    Fault1 Clearing: Automatic 
    Fault2 Clearing: Manual 
    Fault3 Clearing: Manual 
    Fault0 Safety Mode: Safe 
    Fault1 Safety Mode: Normal 
    Fault2 Safety Mode: Normal 
    Fault3 Safety Mode: Normal 
    Fault Enable Mode: Full & Half 
    Full & Half: Half only 
    Half only: None 
    None: None 
    Fault Glitch Stretching: Disabled 
    Fault Filter Period: 14
    Fault Filter Count: 7 
    Fault 0 Pin: Enable 
    Fault 1 Pin: Disable
    Fault 2 Pin: Disable
    Fault 3 Pin: Disable
    Submodule 0: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: No 
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: No 
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: No 
                 Disable Pins PWMX by Fault: Fault 1: No 
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 1: Disable Pins PWMA by Fault: Fault 0: No 
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: No 
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: No 
                 Disable Pins PWMX by Fault: Fault 1: No 
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 2: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: Yes
                 Disable Pins PWMA by Fault: Fault 3: Yes
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: Yes
                 Disable Pins PWMB by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: Yes
                 Disable Pins PWMX by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 3: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: Yes
                 Disable Pins PWMA by Fault: Fault 3: Yes
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: Yes
                 Disable Pins PWMB by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: Yes
                 Disable Pins PWMX by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0
.*/
#define PWM_A_MCTRL_INIT                  0x0F03U
#define PWM_A_MCTRL2_INIT                 0x0000U
#define PWM_A_OUTEN_INIT                  0x0FF0U
#define PWM_A_FCTRL0_INIT                 0x2211U
#define PWM_A_FSTS_INIT                   0x3010U
#define PWM_A_FFILT_INIT                  0x040EU

/*.
    PWM_A_0 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: IPBus Clock 
    Prescaler: fclk/8 
    INIT register: -30000
    VAL1 register: 29999
    Fraction (FRACVAL1): 0
    Sync. source: Local sync (PWMX) 
    Reload source: This module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active Low 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Enabled 
    PWMB Output enable: Enabled 
    PWMX Output enable: Disabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: -10000
    PWM Value 3: 19999
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Value X: 0
    Value 0: Enable 
    Value1: Enable 
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 0
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: No 
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Capture A Input select: Raw PWMA input 
    Capture B Input select: Raw PWMA input 
    Capture X Input select: Raw PWMA input 
    One Shot mode enable: Disable
                          Disable
                          Disable
    Edge Counter Enable: Disable
                         Disable
                         Disable
    Edge Compare A Value: 0
    Edge Compare B Value: 0
    Edge Compare X Value: 0
    Capture A0 Edge Select: Disabled 
    Capture A1 Edge Select: Disabled 
    Capture B0 Edge Select: Disabled 
    Capture B1 Edge Select: Disabled 
    Capture X0 Edge Select: Disabled 
    Capture X1 Edge Select: Disabled 
    PWMX Double Switching: Disable
    Split DBLPWM signal to PWMA and PWMB: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Source of capture DMA: DMA disabled 
    Enable DMA Write Requests For alue Registers: No 
    Output Trigger 0 Source: PWM_OUT_TRIG0 
    Output Trigger 1 Source: PWM_OUT_TRIG1
.*/
#define PWM_A_0_CTRL_INIT                 0x0430U
#define PWM_A_0_CTRL2_INIT                0x0000U
#define PWM_A_0_USE_PWMVAL                1
#define PWM_A_0_INIT_INIT                 0x8AD0U
#define PWM_A_0_VAL1_INIT                 0x752FU
#define PWM_A_0_VAL0_INIT                 0x0000U
#define PWM_A_0_VAL2_INIT                 0xD8F0U
#define PWM_A_0_VAL3_INIT                 0x4E1FU
#define PWM_A_0_VAL4_INIT                 0x0000U
#define PWM_A_0_VAL5_INIT                 0x0000U
#define PWM_A_0_FRACVAL2_INIT             0x0000U
#define PWM_A_0_FRACVAL3_INIT             0x0000U
#define PWM_A_0_FRACVAL4_INIT             0x0000U
#define PWM_A_0_FRACVAL5_INIT             0x0000U
#define PWM_A_0_OCTRL_INIT                0x0400U
#define PWM_A_0_TCTRL_INIT                0x0003U
#define PWM_A_0_DTCNT0_INIT               0x0000U
#define PWM_A_0_DTCNT1_INIT               0x0000U
#define PWM_A_0_DISMAP0_INIT              0xF011U

/*.
    PWM_A_1 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: IPBus Clock 
    Prescaler: fclk/8 
    INIT register: -30000
    VAL1 register: 29999
    Fraction (FRACVAL1): 0
    Sync. source: Local sync (PWMX) 
    Reload source: This module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active High 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Enabled 
    PWMB Output enable: Enabled 
    PWMX Output enable: Disabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: -19000
    PWM Value 3: 19000
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Value X: 0
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 0
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: No 
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Capture A Input select: Raw PWMA input 
    Capture B Input select: Raw PWMA input 
    Capture X Input select: Raw PWMA input 
    One Shot mode enable: Disable
                          Disable
                          Disable
    Edge Counter Enable: Disable
                         Disable
                         Disable
    Edge Compare A Value: 0
    Edge Compare B Value: 0
    Edge Compare X Value: 0
    Capture A0 Edge Select: Disabled 
    Capture A1 Edge Select: Disabled 
    Capture B0 Edge Select: Disabled 
    Capture B1 Edge Select: Disabled 
    Capture X0 Edge Select: Disabled 
    Capture X1 Edge Select: Disabled 
    PWMX Double Switching: Disable
    Split DBLPWM signal to PWMA and PWMB: Disable
    Capture A0: Disable
    Capture A1: Disable
    Capture B0: Disable
    Capture B1: Disable
    Capture X0: Disable
    Capture X1: Disable
    Source of capture DMA: DMA disabled 
    Enable DMA Write Requests For alue Registers: No 
    Output Trigger 0 Source: PWM_OUT_TRIG0 
    Output Trigger 1 Source: PWM_OUT_TRIG1
.*/
#define PWM_A_1_CTRL_INIT                 0x0430U
#define PWM_A_1_CTRL2_INIT                0x0000U
#define PWM_A_1_USE_PWMVAL                1
#define PWM_A_1_INIT_INIT                 0x8AD0U
#define PWM_A_1_VAL1_INIT                 0x752FU
#define PWM_A_1_VAL0_INIT                 0x0000U
#define PWM_A_1_VAL2_INIT                 0xB5C8U
#define PWM_A_1_VAL3_INIT                 0x4A38U
#define PWM_A_1_VAL4_INIT                 0x0000U
#define PWM_A_1_VAL5_INIT                 0x0000U
#define PWM_A_1_FRACVAL2_INIT             0x0000U
#define PWM_A_1_FRACVAL3_INIT             0x0000U
#define PWM_A_1_FRACVAL4_INIT             0x0000U
#define PWM_A_1_FRACVAL5_INIT             0x0000U
#define PWM_A_1_DTCNT0_INIT               0x0000U
#define PWM_A_1_DTCNT1_INIT               0x0000U
#define PWM_A_1_DISMAP0_INIT              0xF022U

/*.
    DAC_A Configuration
--------------------------------------------
    Keep DAC Powered Down: No 
    Data Registers Format: Right justified (bits 11:0)
    SYNC_IN Input: Enabled. SYNC_IN Rising Edge Triggers DAC
    Initial DATA Register Value (0..4095): 0
    Glitch Filter: Enable 
    GPIO WARNING MESSAGE HERE: 29 clocks 
    Enable Automatic Mode: Enable 
    Generated Waveform: Triangle Wavefrom /\/\/\/\ 
    Minimum Value: 0
    Maximum Value: 4095
    Stepping Value: 100
    High Speed Enable: Disable
    DMA Enable: Disable
    Watermark level: 2 (default)
.*/
#define DAC_A_CTRL_INIT                   0x113CU
#define DAC_A_STEP_INIT                   0x0064U
#define DAC_A_MAXVAL_INIT                 0x0FFFU
#define DAC_A_CTRL1_INIT                  0x001DU

/*.
    HSCMP_A Configuration
--------------------------------------------
    Enable Analog Comparator: Yes
    Output Polarity: Normal. Output High when Positive Input higher than Negative Input
    Positive Comparator Input Source: IN7 (6-bit DAC) 
    Negative Comparator Input Source: IN4 (12-bit DAC) 
    Falling Edge Interrupt: Disable
    Rising Edge Interrupt: Disable
    Enable Pass Trough Mode: Disable
    Select hysteresis Level: 1 
    Input Filter: Input Signal Sampling [timer clocks] : 0
                  Consecutive Samples Required to Agree: Disabled 
                  Input Signal Latency: ??? 
    Enable VREF_DAC: Enable 
    DAC Control: V1in 
    Output Level: 10
.*/
#define HSCMP_A_CR1_INIT                  0x0001U
#define HSCMP_A_DACCR_INIT                0x008AU
#define HSCMP_A_MUXCR_INIT                0x003CU


/*.         End of autogenerated code
********************************************************************** ..*/

#endif
