#include "dram2.def";

*********************************************************************************
*                                               Copyright (c) Freescale 2013    *
* File Name: MC33816_ch2.dfi                                                    *
* Current Revision: 2.0                                                         *
* Purpose: MC33816 example - DC-DC converter and Full Pump Drive                *
* Description:  MC33816 Channel 2 main function provide DC-DC converter         *
*               management on Uc0Ch2 and Fuel pump current profile on Uc1Ch2    *
* File created by:  Freescale Analog, Tempe                                     * 
*                   Freescale Analog, Toulouse                                  *                                        
*                                                                               *
* UPDATE HISTORY                                                                *
* REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                              *
* ---  ------    --------    ---------------------                              *
* 1.0  tboi01    2014/01/10    initial coding                                   *
* 2.0  b16868    2015/11/03    updates with new IDE featuresDRAM, entry point   *
*                                                                               *
*********************************************************************************

*********************************************************************************
* Freescale reserves  the right to make  changes without  further notice to any *
* product herein to improve  reliability, function,  or design.  Freescale does *
* not  assume  any  liability  arising  out of  the application  or use  of any *
* product, circuit,  or software described herein;  neither does  it convey any *
* license under its patent rights nor the rights of others.  Freescale products *
* are not designed, intended,  or authorized for use as  components  in systems *
* intended for  surgical implant into the body,  or other applications intended *
* to support life,  or for any other  application  in which the failure  of the *
* Freescale product could create a situation where  personal injury or death may*
* occur.  Should Buyer purchase or use Freescale products for any such intended *
* or unauthorized  application,  Buyer shall indemnify and  hold  Freescale and *
* its officers, employees, subsidiaries, affiliates,  and distributors harmless *
* against all claims costs, damages, and expenses, and reasonable attorney  fees*
* arising  out of,  directly or indirectly,  any claim  of personal  injury  or *
* death  associated  with  such unintended  or unauthorized use,  even if  such *
* claim  alleges  that  Freescale   was  negligent   regarding   the  design  or*
* manufacture  of the part.  Freescale and the  Freescale logo  are registered  *
* trademarks of Freescale Ltd.                                                  *
*********************************************************************************

* ### Channel 2 - uCore0 controls dc-dc ###


* ### Initialization phase ###
init0:      stgn gain5.8 ossc;
            load Iboost_L dac_ossc _ofs; *load DAC 4 L with low Vboost current
            load Iboost_H dac4h4n _ofs;  *load DAC 4H with high Vbost current
            stdm null; *Set DAC access mode to Vboost
            cwer idle0 _f0 row1;  *if flag 0 is low turn Off the boost
            cwer dcdcon _vb row2;   *if vboost lower than vboost low then turn on boost
            cwer dcdcoff vb row3;   *if vboost higher than vboost high then turn off boost
           
            
dcdcon:     load Vboost_H dac4h4n _ofs;  *set Vboost high
            stdcctl async; *set dcdc to async
            wait row13;
            
dcdcoff:    load Vboost_L dac4h4n _ofs;  *set Vboost low
            stdcctl sync; *set dcdc to sync
            wait row12;
            
idle0:      stdcctl sync;
            jocr idle0 _f0;
            jmpr dcdcoff;
            

* ### End of Channel 2 - uCore0 code ###

*********************************************************************************

* ### Channel 2 - uCore1 drives fuel pump ###


* ### Initialization phase ###
init1:      stgn gain19.4 ossc;                     * Set the gain of the opamp of the current measure block 1 
            ldjr1 eoact1;                           * Load the eoinj line label Code RAM address into the register jr1 
            ldjr2 idle1;                            * Load the idle line label Code RAM address into the register jr2
            cwef jr1 _start row1;                   * If the start signal goes low, go to eoinj phase           

* ### Idle phase- the uPC loops here until start signal is present ###              
idle1:      joslr act5_start start5;                * Perform an actuation on act5 if start 5 (only) is active
             joslr act6_start start6;                * Perform an actuation on act5 if start 5 (only) is active
            jmpf jr1;                              * If more than 1 start active at the same time(or none), no actuation

* ### Shortcuts definition per the injector to be actuated ###
act5_start: dfsct hs5 ls5 undef;                    * Set the 2 shortcuts: VBAT, LS
            jmpr peak1;
            
act6_start: dfsct hs5 ls6 undef;                    * Set the 2 shortcuts: VBAT, LS


* ### Launch peak phase on bat ###
peak1:      load Ipeak dac_ossc _ofs;               * Load the boost phase current threshold in the current DAC
            cwer hold1 cur3 row2;                   * Jump to peak phase when current is over threshold
            stos on on keep;                        * Turn VBAT off, BOOST on, LS on
            wait row12;                             * Wait for one of the previously defined conditions
            
* ### Hold phase on Vbat ###    
hold1:      ldcd rst _ofs keep keep Thold_tot c1;   * Load the length of the total hold phase in counter 2 
            load Ihold dac_ossc _ofs;               * Load the hold current threshold in the DAC
            cwer eoact1 tc1 row2;                   * Jump to eoinj phase when tc1 reaches end of count
            cwer hold_on1 tc2 row3;                 * Jump to hold_on when tc2 reaches end of count
            cwer hold_off1 cur3 row4;               * Jump to hold_off when current is over threshold

hold_on1:   stos on on keep;                        * Turn VBAT on, LS on
            wait row124;                            * Wait for one of the previously defined conditions

hold_off1:  ldcd rst _ofs off on Thold_off c2;      * Load the length of the hold_off phase in counter 1 and turn VBAT off, LS on
            wait row123;                            * Wait for one of the previously defined conditions

* ### End of injection phase ###
eoact1:     stos off off keep;                      * Turn VBAT off, LS off
            jmpf jr2;                               * Jump back to idle phase

* ### End of Channel 2 - uCore1 code ###
