/*******************************************************************************
* Example Code
*
* Copyright(C) 2019 NXP Semiconductors
* NXP Semiconductors Confidential and Proprietary
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* NXP products.  This software is supplied "AS IS" without any warranties
* of any kind, and NXP Semiconductors and its licensor disclaim any and
* all warranties, express or implied, including all implied warranties of
* merchantability, fitness for a particular purpose and non-infringement of
* intellectual property rights.  NXP Semiconductors assumes no responsibility
* or liability for the use of the software, conveys no license or rights
* under any patent, copyright, mask work right, or any other intellectual
* property rights in or to any products. NXP Semiconductors reserves the
* right to make changes in the software without notification. NXP
* Semiconductors also makes no representation or warranty that such
* application will be suitable for the specified use without further testing
* or modification.
*
* IN NO EVENT WILL NXP SEMICONDUCTORS BE LIABLE, WHETHER IN CONTRACT, 
* TORT, OR OTHERWISE, FOR ANY INCIDENTAL, SPECIAL, INDIRECT, CONSEQUENTIAL 
* OR PUNITIVE DAMAGES, INCLUDING, BUT NOT LIMITED TO, DAMAGES FOR ANY 
* LOSS OF USE, LOSS OF TIME, INCONVENIENCE, COMMERCIAL LOSS, OR LOST 
* PROFITS, SAVINGS, OR REVENUES, TO THE FULL EXTENT SUCH MAY BE DISCLAIMED  
* BY LAW. NXP SEMICONDUCTOR’S TOTAL LIABILITY FOR ALL COSTS, DAMAGES, 
* CLAIMS, OR LOSSES WHATSOEVER ARISING OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE IS LIMITED TO THE AGGREGATE AMOUNT PAID BY YOU TO NXP SEMICONDUCTORS
* IN CONNECTION WITH THE SOFTWARE TO WHICH LOSSES OR DAMAGES ARE CLAIMED.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided
* that it is used in conjunction with NXP Semiconductors devices.  This
* copyright, permission, and disclaimer notice must appear in all copies
* of this code.
*******************************************************************************/

//==============================================================================
// This file contains data arrays that are used to load the code RAM, data RAM
// and registers on the PT2001.
//==============================================================================

// ECU: FRDMPKPT2001EVM
// Project: Basic

// Data to be loaded into the Code RAM 1 memory space
const unsigned short PT2001_code_RAM1[102] =
{
    0x761E, 0x6C4F, 0x917F, 0xA514, 0x4397, 0xFF99, 0x709F, 0x2F4F, 0xD41E, 0xF985, 
    0x4125, 0x2EEE, 0x978C, 0x3534, 0x2628, 0x0999, 0xFCE1, 0x4E44, 0x1CED, 0x48F3, 
    0x25F6, 0xBE0F, 0x9A90, 0x3947, 0xFB2D, 0x7575, 0xB503, 0x73EE, 0xAE5F, 0x9783, 
    0xDA88, 0x3D2D, 0xD681, 0x4772, 0x0057, 0x0100, 0x9C45, 0xE622, 0x8D4E, 0xE952, 
    0xD8C5, 0xB696, 0xFCFC, 0x6E6D, 0xEF9E, 0x4807, 0x05A2, 0x9E76, 0xEA3E, 0x803D, 
    0x4335, 0x84A8, 0xE465, 0xD503, 0xD62F, 0x82B4, 0x2E89, 0xF772, 0xD8FA, 0x3D01, 
    0x0DA5, 0xDA87, 0xFE4A, 0x74B1, 0x789D, 0x9E06, 0x62B1, 0x1268, 0xEB91, 0x31B3, 
    0x5A47, 0x0F2C, 0xFD4D, 0xF67B, 0xB59A, 0x6011, 0x14E2, 0xDEDC, 0xC7E3, 0xD342, 
    0x24CE, 0x808E, 0x63C8, 0xDF83, 0xE8DF, 0x3811, 0xE79D, 0xE646, 0x9F10, 0x1C8A, 
    0xA8DE, 0xFAD1, 0x95F7, 0xD70D, 0xF303, 0xF16D, 0xABE6, 0xB72C, 0x41D2, 0x016A, 
    0xB5CA, 0xD661
};

// Data to be loaded into the Code RAM 2 memory space
const unsigned short PT2001_code_RAM2[41] =
{
    0x761B, 0x6E45, 0x828D, 0x80B4, 0x57F2, 0x0EBC, 0x8D2D, 0xA68E, 0xE919, 0xE39D, 
    0x4190, 0x34AF, 0x22D4, 0x2F77, 0x1367, 0xA640, 0x01A2, 0xFA38, 0xB8E7, 0x6DD4, 
    0x7FF1, 0x865D, 0x22F7, 0x7D54, 0x1E8E, 0x2B38, 0x0439, 0x7CA5, 0xAF24, 0x96E6, 
    0xBF8B, 0xCBA4, 0x2CB7, 0xB6D4, 0xB626, 0x013D, 0x6DAC, 0x856C, 0xE84E, 0x5FC4, 
    0x3108
};

// Data to be loaded into the Data RAM memory space
const unsigned short PT2001_data_RAM[128] =
{
    0x00BA, 0x0070, 0x0040, 0x003C, 0x0BB8, 0x00F0, 0x0078, 0xEA60, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x00CD, 0x00D2, 0x0023, 0x0042, 0x0000, 0x0078, 
    0x005A, 0x003C, 0xEA60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

// Data to be loaded into the Main register memory space
const unsigned short PT2001_main_config[29] =
{
    0x0003, 0x1FC0, 0x0000, 0x0000, 0x007F, 0x26C1, 0x0001, 0x0004, 0x001F, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x9C00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

// Data to be loaded into the CH1 register memory space
const unsigned short PT2001_ch1_config[19] =
{
    0x0008, 0x0000, 0x0000, 0x0000, 0x0303, 0x0000, 0x0000, 0x0066, 0xBC7D, 0x8453, 
    0x0000, 0x0033, 0x0000, 0x0000, 0x0000, 0x03FF, 0x03FF, 0x0000, 0x0000
};

// Data to be loaded into the CH2 register memory space
const unsigned short PT2001_ch2_config[19] =
{
    0x0018, 0x0000, 0x0000, 0x0000, 0x0C00, 0x0000, 0x0000, 0x0029, 0x1438, 0x53AB, 
    0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x03FF, 0x03FF, 0x0000, 0x0000
};

// Data to be loaded into the IO register memory space
const unsigned short PT2001_io_config[53] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0063, 0x018C, 0x0800, 0x0610, 0x0041, 0x0098, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00D2, 0x0004, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0000, 0x8080, 0x8080, 
    0x0080, 0x0003, 0x001D, 0x0023, 0x0028, 0x017B, 0x0012, 0x0002, 0x0002, 0x0000, 
    0x0015, 0x0005, 0x0000
};

// Data to be loaded into the Diag register memory space
const unsigned short PT2001_diag_config[44] =
{
    0x1DDA, 0x0009, 0x001E, 0x1DDA, 0x0009, 0x001E, 0x028E, 0x0009, 0x001E, 0x028E, 
    0x0009, 0x001E, 0x028E, 0x0009, 0x001E, 0x028E, 0x0009, 0x001E, 0x001E, 0x1DDA, 
    0x0069, 0x001E, 0x1DDA, 0x0069, 0x001E, 0x028E, 0x0069, 0x001E, 0x028E, 0x0069, 
    0x001E, 0x0000, 0x0000, 0x001E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0001
};

