/******************************************************************************								
*    LAB4 -Keyboard Interrupt (KBI) Module                                    *								
*                                                                             *								
*       This lab demonstrates how to use the KBI module to read button        *								
*    presses without polling. It uses interrupts to detect button presses on  *								
*    SW2 and SW3. Each button toggles an LED when pressed.                    *								
*       Press buttons SW2 or SW3 to toggle its corresponding LED              *								
******************************************************************************/								


/**********************************************************************************************
* External objects
**********************************************************************************************/
#include <hidef.h> 
#include "derivative.h"

#include "main.h"
#include "COP.h"
#include "CLK.h"
#include "KBI.h"


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/	
	void KBI_Interrupt(UINT8 ch);	

/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

	
/***********************************************************************************************
*
* @brief    GPIO_Init - Initialize the LEDs as outputs
* @param    none
* @return   none
*
************************************************************************************************/
void GPIO_Init()
{
  PORT_PTGOE_PTGOE0 = 1;		/* Init LEDs as outputs */
  PORT_PTGOE_PTGOE1 = 1;
  PORT_PTGOE_PTGOE2 = 1;
  PORT_PTGOE_PTGOE3 = 1;	
  
  PORT_PTDIE_PTDIE4 = 1;		/* Button pins as inputs */
  PORT_PTDIE_PTDIE5 = 1;
  
  PORT_PTGD = 0xFF;				/* LEDs OFF */		
}	
	
	
	
/***********************************************************************************************
*
* @brief    main() - Program entry function
* @param    none
* @return   none
*
************************************************************************************************/  
void main(void) {
  
  COP_Disable();			/* Disable Watchdog */
  CLK_Init();				/* Configure clocks to run at 16Mhz */
  GPIO_Init();				/* Configure button pins as inputs and LED pins as outputs */
  
  EnableInterrupts;
  
  KBI_SetCallback(KBI_Interrupt);		/* Set the KBI callback function to be called on each button press */
  KBI_Init();							/* Initialize KBI module */
  

  for(;;) 
  {	  
	  
  }
  
}



/***********************************************************************************************
*
* @brief    KBI_Interrupt(UINT8 ch). Callback function called by the KBI module on each interrupt
* @param    KBI channel
* @return   none
*
************************************************************************************************/  
void KBI_Interrupt(UINT8 ch)
{
		 if(ch == 2){ LED1_TOGGLE; }
	else if(ch == 3){ LED2_TOGGLE; }
}	


