
/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file EEPROM_Emulation_demo.c
*
* @author Freescale
*
* @version 0.0.1
*
* @date Oct. 15, 2013
*
* @brief providing framework of demo cases for MCU. 
*
*******************************************************************************/

#include "common.h"
#include "ics.h"
#include "rtc.h"
#include "uart.h"
#include "sim.h"
#include "sysinit.h"
#include "ee_emulation.h"
/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/
uint32_t u32EE_CurrentAddress;
/******************************************************************************
* Local functions
******************************************************************************/
int main (void);
void RTC_Task(void);
/******************************************************************************
* Global functions
******************************************************************************/
int main (void)
{
    uint32_t i;
    uint32_t uiCount = 0;
    EE_ItemInfoType sEE_ItemInfo;

    /* Perform processor initialization */
    sysinit();
    printf("\nRunning the KE06 EEPROM_Emulation_demo project.\n");
    LED0_Init();        //red led
    LED1_Init();        //green led
    LED2_Init();        //blue led
    
    LED0_Off();
    LED1_Off();
    LED2_Off();

    EE_Init(&u32EE_CurrentAddress,BUS_CLK_HZ);
    
    /* echo chars received from terminal */
	while(1)
	{
        EE_Read(&sEE_ItemInfo,u32EE_CurrentAddress);
        if(sEE_ItemInfo.u8Flag == EE_ITEM_INFO_VALID)
        {
            printf("current counter is %d\n",uiCount);
            printf("current information flag is 0x%x\n",sEE_ItemInfo.u8Flag);
            for(i=0;i<15;i++)
            {
                printf("%d,",sEE_ItemInfo.u8InfoBuff[i]);
            }
            printf("\r\n");
        }
        else
        {
            printf("current item is invalid!\n");
        }
        
        printf("write a char to start updated a new item to EE!\n");
        
        UART_GetChar(TERM_PORT);
        uiCount++;
        for(i=0;i<15;i++)
	    {
			sEE_ItemInfo.u8InfoBuff[i] = uiCount;
	    }
	    if(EE_Write(&sEE_ItemInfo,&u32EE_CurrentAddress))
        {
            
        }
        else
        {
            printf("Item information updated fail!\n");
        }
        printf("current address is 0x%x\n",u32EE_CurrentAddress);	
	} 
}

/*****************************************************************************//*!
*
* @brief callback routine of RTC driver which does what you want to do at 
*        every RTC period.
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void RTC_Task(void)
{
    /* toggle LED1 */
    LED0_Toggle();
}
/********************************************************************/
