/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013-2014 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file rtc.h
*
* @author Freescale
*
* @version 0.0.1
*
* @date Apr 19, 2013
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a drive to simulate EEPROM with flash
******************************************************************************/

#ifndef EE_EMULATION_H_
#define EE_EMULATION_H_

/******************************************************************************
* Includes
******************************************************************************/

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros
******************************************************************************/
#define EE_START_ADDRESS		0xC000
#define FLASH_PAGE_SIZE			512
#define EE_PAGE_NUMBER          2
#define EE_END_ADDRESS			EE_START_ADDRESS + FLASH_PAGE_SIZE*EE_PAGE_NUMBER-1

#define EE_ITEM_INFO_NULL           0xFF
#define EE_ITEM_INFO_PROCESSING     0xe7
#define EE_ITEM_INFO_VALID          0xa5
#define EE_ITEM_INFO_INVALID        0x00 
        
#define EE_ERROR_SUCCESS                0x00
#define EE_ERROR_PROGRAM_FAIL           0x01
#define EE_ERROR_ERASE_FAIL             0x02
#define EE_ERROR_CONTENT_INVALID        0x04

/* here please ensure lenth divide 4 equal to 0, so that flash operation allign with 4 bytes */
#define EE_ITEM_INFO_LENGTH				16
#if ((EE_ITEM_INFO_LENGTH%4) != 0 )
	#error "please ensure EE information length is allign with 4 bytes"
#endif


/******************************************************************************
* Types
******************************************************************************/

typedef struct
{
    uint8_t u8Flag;
	uint8_t u8InfoBuff[EE_ITEM_INFO_LENGTH - 1];
}EE_ItemInfoType,*EE_ItemInfoPtr;

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/
uint8_t EE_Init( uint32_t *pCurrentAddress,uint32_t u32BusClock );
uint8_t EE_Write(EE_ItemInfoPtr pWrItemInfo,uint32_t *p32CurrentAddress);
uint8_t EE_Read(EE_ItemInfoPtr pRdItemInfo,uint32_t u32CurrentAddress);
uint8_t EE_SearchIndex(uint32_t *pCurrentAddress);

#endif

