#*******************************************************************************
#
#  FREESCALE SEMICONDUCTOR INC. 2014
#  ALL RIGHTS RESERVED
#  COPYRIGHT (c)
#
#*******************************************************************************
#
#  FILE NAME:  constants.tcl
#
#*******************************************************************************

#*******************************************************************************
# Constants 
#*******************************************************************************
#set ::TCR1_FREQ_HZ                                                      100e6
set ::TCR1_FREQ_HZ                                                       10e6
set ::TEETH_TILL_GAP                                                       35
set ::TEETH_IN_GAP                                                          1
set ::TEETH_PER_CYCLE                                                      72
set ::TCR2_TICKS_PER_TOOTH                                                100
set ::TCR2_TICKS_PER_CYCLE [expr $::TEETH_PER_CYCLE * $::TCR2_TICKS_PER_TOOTH]

#*******************************************************************************
# Conversion Functions 
#*******************************************************************************
proc msec2tcr1 { val } {
  return [expr round($::TCR1_FREQ_HZ * $val / 1e3) ]
}

proc usec2tcr1 { val } {
  return [expr round($::TCR1_FREQ_HZ * $val / 1e6) ]
}

proc nsec2tcr1 { val } {
  return [expr round($::TCR1_FREQ_HZ * $val / 1e9) ]
}

proc deg2tcr2 { val } {
  return [expr round($val * $::TCR2_TICKS_PER_CYCLE / 720) ]
}

proc ufract24 { val } {
  return [expr round($val * 0xFFFFFF) ]
}

proc rpm2tp { val } {
  return [expr round($::TCR1_FREQ_HZ / $val * 60 / ($::TEETH_PER_CYCLE/2) ) ]
}

proc tp2rpm { val } {
  return [expr round($::TCR1_FREQ_HZ / $val * 60 / ($::TEETH_PER_CYCLE/2) ) ]
}
