#*******************************************************************************
#
#  FREESCALE SEMICONDUCTOR INC. 2014
#  ALL RIGHTS RESERVED
#  COPYRIGHT (c)
#
#*******************************************************************************
#
#  FILE NAME:  inj_init.tcl
#
#*******************************************************************************

#*******************************************************************************
# Helper scripts 
#*******************************************************************************
etpusource trans.tcl
etpusource common.tcl

#*******************************************************************************
# Included scripts 
#*******************************************************************************
source [get_relative_loc]constants.tcl

#*******************************************************************************
# Functions 
#*******************************************************************************
proc inj_bank_init { INJ_BANK_CHAN } {
  #*****************************************************************************
  # Import automatically generated interface header file
  #*****************************************************************************
  include_generated_file "etpu_inj_auto.h"
  
  #*****************************************************************************
  # eTPU Channel INJ Configuration 
  #*****************************************************************************
  write_chan_base_addr       $INJ_BANK_CHAN 0 
  write_chan_func            $INJ_BANK_CHAN $::FS_ETPU_INJ_FUNCTION_NUMBER
  write_chan_entry_condition $INJ_BANK_CHAN $::FS_ETPU_INJ_TABLE_SELECT 
  write_chan_mode            $INJ_BANK_CHAN [expr $::FS_ETPU_INJ_FM0_ACTIVE_HIGH + $::FS_ETPU_INJ_FM1_CHANNEL_BANK]
  write_chan_hsrr            $INJ_BANK_CHAN $::FS_ETPU_INJ_HSR_INIT 
  write_chan_cpr             $INJ_BANK_CHAN 1
  
  puts "eTPU channel $INJ_BANK_CHAN initialized to run the INJ_BANK function."
}


proc inj_table_init { INJ_TAB_BASE_ADDR } {
  #*****************************************************************************
  # Import automatically generated interface header file
  #*****************************************************************************
  include_generated_file "etpu_inj_auto.h"
  
  #*****************************************************************************
  # INJ Injection Table Initialization
  #*****************************************************************************
  set P_INJECTION_1     [expr $INJ_TAB_BASE_ADDR + 0 * $::FS_ETPU_INJ_INJECTION_STRUCT_SIZE]
  set P_INJECTION_2     [expr $INJ_TAB_BASE_ADDR + 1 * $::FS_ETPU_INJ_INJECTION_STRUCT_SIZE]
  set P_INJECTION_3     [expr $INJ_TAB_BASE_ADDR + 2 * $::FS_ETPU_INJ_INJECTION_STRUCT_SIZE]

  set P_INJ1_PHASES [expr $P_INJECTION_3 + $::FS_ETPU_INJ_INJECTION_STRUCT_SIZE]
  set P_INJ2_PHASES [expr $P_INJ1_PHASES + 8 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_INJ3_PHASES [expr $P_INJ2_PHASES + 8 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]

  write_spram_8  [expr $P_INJECTION_1 + $::FS_ETPU_INJ_OFFSET_PHASE_COUNT]   7
  write_spram_24 [expr $P_INJECTION_1 + $::FS_ETPU_INJ_OFFSET_P_PHASE_FIRST] $P_INJ1_PHASES
  write_spram_24 [expr $P_INJECTION_1 + $::FS_ETPU_INJ_OFFSET_ANGLE_START]   [deg2tcr2 30]

  write_spram_8  [expr $P_INJECTION_2 + $::FS_ETPU_INJ_OFFSET_PHASE_COUNT]   7
  write_spram_24 [expr $P_INJECTION_2 + $::FS_ETPU_INJ_OFFSET_P_PHASE_FIRST] $P_INJ2_PHASES
  write_spram_24 [expr $P_INJECTION_2 + $::FS_ETPU_INJ_OFFSET_ANGLE_START]   [deg2tcr2 15]

  write_spram_8  [expr $P_INJECTION_3 + $::FS_ETPU_INJ_OFFSET_PHASE_COUNT]   5
  write_spram_24 [expr $P_INJECTION_3 + $::FS_ETPU_INJ_OFFSET_P_PHASE_FIRST] $P_INJ3_PHASES
  write_spram_24 [expr $P_INJECTION_3 + $::FS_ETPU_INJ_OFFSET_ANGLE_START]   [deg2tcr2 -5]

  set P_PHASE_0 [expr $P_INJ1_PHASES + 0 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_1 [expr $P_INJ1_PHASES + 1 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_2 [expr $P_INJ1_PHASES + 2 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_3 [expr $P_INJ1_PHASES + 3 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_4 [expr $P_INJ1_PHASES + 4 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_5 [expr $P_INJ1_PHASES + 5 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_6 [expr $P_INJ1_PHASES + 6 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  write_spram_8  [expr $P_PHASE_0 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x0
  write_spram_24 [expr $P_PHASE_0 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_1 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x3
  write_spram_24 [expr $P_PHASE_1 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 60]
  write_spram_8  [expr $P_PHASE_2 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x1
  write_spram_24 [expr $P_PHASE_2 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_3 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x5
  write_spram_24 [expr $P_PHASE_3 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 60]
  write_spram_8  [expr $P_PHASE_4 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x1
  write_spram_24 [expr $P_PHASE_4 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_5 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x5
  write_spram_24 [expr $P_PHASE_5 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 40]
  write_spram_8  [expr $P_PHASE_6 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x0
  write_spram_24 [expr $P_PHASE_6 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]

  set P_PHASE_0 [expr $P_INJ2_PHASES + 0 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_1 [expr $P_INJ2_PHASES + 1 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_2 [expr $P_INJ2_PHASES + 2 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_3 [expr $P_INJ2_PHASES + 3 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_4 [expr $P_INJ2_PHASES + 4 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_5 [expr $P_INJ2_PHASES + 5 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_6 [expr $P_INJ2_PHASES + 6 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  write_spram_8  [expr $P_PHASE_0 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x0
  write_spram_24 [expr $P_PHASE_0 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_1 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x3
  write_spram_24 [expr $P_PHASE_1 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 60]
  write_spram_8  [expr $P_PHASE_2 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x1
  write_spram_24 [expr $P_PHASE_2 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_3 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x5
  write_spram_24 [expr $P_PHASE_3 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 120]
  write_spram_8  [expr $P_PHASE_4 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x1
  write_spram_24 [expr $P_PHASE_4 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 40]
  write_spram_8  [expr $P_PHASE_5 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x5
  write_spram_24 [expr $P_PHASE_5 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 200]
  write_spram_8  [expr $P_PHASE_6 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x0
  write_spram_24 [expr $P_PHASE_6 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]

  set P_PHASE_0 [expr $P_INJ3_PHASES + 0 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_1 [expr $P_INJ3_PHASES + 1 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_2 [expr $P_INJ3_PHASES + 2 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_3 [expr $P_INJ3_PHASES + 3 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_4 [expr $P_INJ3_PHASES + 4 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_5 [expr $P_INJ3_PHASES + 5 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  set P_PHASE_6 [expr $P_INJ3_PHASES + 6 * $::FS_ETPU_INJ_PHASE_STRUCT_SIZE]
  write_spram_8  [expr $P_PHASE_0 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x0
  write_spram_24 [expr $P_PHASE_0 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_1 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x3
  write_spram_24 [expr $P_PHASE_1 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 60]
  write_spram_8  [expr $P_PHASE_2 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x1
  write_spram_24 [expr $P_PHASE_2 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
  write_spram_8  [expr $P_PHASE_3 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x5
  write_spram_24 [expr $P_PHASE_3 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 80]
  write_spram_8  [expr $P_PHASE_4 + $::FS_ETPU_INJ_OFFSET_DMAS_OUTPUTS]       0x0
  write_spram_24 [expr $P_PHASE_4 + $::FS_ETPU_INJ_OFFSET_DURATION]           [usec2tcr1 20]
}


proc inj_init { INJ_CHAN INJ_BASE_ADDR TDC_DEG INJ_TAB_BASE_ADDR INJ_BANK_CHANs } {
  #*****************************************************************************
  # Import automatically generated interface header file
  #*****************************************************************************
  include_generated_file "etpu_inj_auto.h"
  
  #*****************************************************************************
  # Definitions.
  #*****************************************************************************
  set SINGLE_INJ_BASE_ADDR [expr $INJ_BASE_ADDR + $::FS_ETPU_INJ_NUM_PARMS]
  
  #*****************************************************************************
  # eTPU Channel INJ Configuration 
  #*****************************************************************************
  write_chan_base_addr       $INJ_CHAN $INJ_BASE_ADDR 
  write_chan_func            $INJ_CHAN $::FS_ETPU_INJ_FUNCTION_NUMBER
  write_chan_entry_condition $INJ_CHAN $::FS_ETPU_INJ_TABLE_SELECT 
  write_chan_mode            $INJ_CHAN [expr $::FS_ETPU_INJ_FM0_ACTIVE_HIGH + $::FS_ETPU_INJ_FM1_CHANNEL_INJ]
  write_chan_hsrr            $INJ_CHAN $::FS_ETPU_INJ_HSR_INIT 
  write_chan_cpr             $INJ_CHAN 1
  
  #*****************************************************************************
  # eTPU Channel INJ Parameters Initialization
  #*****************************************************************************
  set bank_chans 0
  set bank_chans_mask 0
  foreach INJ_BANK_CHAN $INJ_BANK_CHANs {
    set bank_chans [expr [expr $bank_chans << 8] + $INJ_BANK_CHAN]
    set bank_chans_mask [expr $bank_chans_mask | [expr 1 << $INJ_BANK_CHAN]]
  }
  set bank_chans [format 0x%.8x $bank_chans]
  set bank_chans_mask [format 0x%.8x $bank_chans_mask]
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_BANK_CHANS          $bank_chans
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_P_INJECTION_FIRST   $INJ_TAB_BASE_ADDR
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_P_INJECTION         0
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_P_PHASE             0
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_ANGLE_IRQ           [deg2tcr2  60]
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_ANGLE_STOP          [deg2tcr2 -30]
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_TDC_ANGLE           [deg2tcr2 $TDC_DEG]
  write_chan_data24 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_TDC_ANGLE_ACTUAL    0
  write_chan_data8  $INJ_CHAN $::FS_ETPU_INJ_OFFSET_INJECTION_COUNT     3
  write_chan_data8  $INJ_CHAN $::FS_ETPU_INJ_OFFSET_INJECTION_COUNTER   0
  write_chan_data8  $INJ_CHAN $::FS_ETPU_INJ_OFFSET_PHASE_COUNTER       0
  write_chan_data8  $INJ_CHAN $::FS_ETPU_INJ_OFFSET_BANK_CHANS_COUNT    2
  write_chan_data8  $INJ_CHAN $::FS_ETPU_INJ_OFFSET_ERROR               0
  write_chan_data8  $INJ_CHAN $::FS_ETPU_INJ_OFFSET_INACTIVE_POLARITIES 0
  write_chan_data32 $INJ_CHAN $::FS_ETPU_INJ_OFFSET_BANK_CHANS_MASK     $bank_chans_mask
  
  puts "eTPU channel $INJ_CHAN initialized to run the INJ function."
}
