/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file pmc.h
 *
 * @author  
 *
 * @version 2.0
 *
 * @date Apr-19-2013
 *
 * @brief Power management routines
 *
 *****************************************************************************/

#ifndef __PMC_H__
#define __PMC_H__

/*****************************************************************************
* User definitions
*****************************************************************************/
#define PMC_MAX_VLPR_CORE_FREQ_KHZ      4000
#define PMC_MAX_VLPR_FLASH_FREQ_KHZ     1000

/*****************************************************************************
* Type definitions
*****************************************************************************/
typedef enum{
  PMC_OK,
  PMC_ERR
}PMC_ERROR_STATUS;

typedef enum{
  PMC_VLLS1 = 1,
  PMC_VLLS2 = 2,
  PMC_VLLS3 = 3
}PMC_VLLS_MODES;

/******************************************************************************
* Function prototypes
******************************************************************************/
void vfnEnterWait(void);
void vfnEnterStop(void);
unsigned char u8EnterVlpr(unsigned char u8LpwuiValue);
unsigned char u8EnterVlpw(unsigned char u8LpwuiValue);
unsigned char u8EnterVlps(unsigned char u8LpwuiValue);
unsigned char u8ExitVlpr(void);
unsigned char u8EnterLls(void);
unsigned char u8EnterVlls(unsigned char u8VllsMode);
void vfnSetLpwui(unsigned char u8Set);
void vfnJtagTdoPullUpEnable(void);
void vfnClockMonitor(unsigned char u8State);
void stop (void);
void wait (void);

/********************************************************************/
#endif /* __PMC_H__ */
