/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************//*!
*
* @file twrpi_slcd.h
*
* @author  
*
* @version 2.0
*
* @date Apr-24-2013
*
* @brief Driver for TWRPI-SLCD module on Kinetis devices
*
*****************************************************************************/

#ifndef _TWRPI_SLCD_H_
#define _TWRPI_SLCD_H_

/****************************************************************
 * Header files
 ***************************************************************/
#include "derivative.h"

/*****************************************************************************
* SLCD pin configurations
*****************************************************************************/

/* COM pins "backplane" (see TWRPI-SLCD datasheet) */
#define SLCD_COM1_PCR           PORTB_PCR2
#define SLCD_COM2_PCR           PORTC_PCR3
#define SLCD_COM3_PCR           PORTB_PCR8
#define SLCD_COM4_PCR           PORTD_PCR0

/* Frontplane pins */
#define SLCD_PIN5_PCR           PORTC_PCR4
#define SLCD_PIN6_PCR           PORTD_PCR1
#define SLCD_PIN7_PCR           PORTC_PCR6
#define SLCD_PIN8_PCR           PORTB_PCR16
#define SLCD_PIN9_PCR           PORTD_PCR3
#define SLCD_PIN10_PCR          PORTD_PCR2
#define SLCD_PIN11_PCR          PORTC_PCR5

/* LCD module pins assigned to each SLCD pin (i.e PTB2 is assigned to LCD_02 */
#define SLCD_LCDPIN_COM1        2
#define SLCD_LCDPIN_COM2        23
#define SLCD_LCDPIN_COM3        8
#define SLCD_LCDPIN_COM4        40
#define SLCD_LCDPIN_PIN5        24
#define SLCD_LCDPIN_PIN6        41
#define SLCD_LCDPIN_PIN7        26
#define SLCD_LCDPIN_PIN8        12
#define SLCD_LCDPIN_PIN9        43
#define SLCD_LCDPIN_PIN10       42
#define SLCD_LCDPIN_PIN11       25

/*****************************************************************************
*                            Auxiliary Macros
*
* How to use:
*
* 1.- Declare a new matrix to modify using slcd_matrix_t type
* example slcd_matrix_t myMatrix;
*
* 2.- Use the macros to set or clear segments on the LCD
* example CLEAR_MATRIX(myMatrix); <-- This clear the matrix
*         SET_FSL(myMatrix); <-- This sets the FSL logo on the matrix
*
* 3.- Turn on the selected segments on the LCD calling the function vfnSlcdRefresh(slcd_matrix_t Matrix)
* example: vfnSlcdRefresh(myMatrix); <-- This updates the TWRPI-SLCD with the selected segments
*                                   in the matrix, in this case it will turn on the FSL logo
*/

/* MACRO for clearing the Matrix */
#define	CLEAR_MATRIX(x)	x.bCom1 = 0;\
			x.bCom2	= 0;\
			x.bCom3 = 0;\
			x.bCom4 = 0

/* Macros for setting and clearing miscelaneous segments */
#define SET_FSL(x)		x.bCom4 |= 0x01
#define CLR_FSL(x)              x.bCom4 &= ~0x01
#define SET_NUM0(x)		x.bCom4 |= 0x10
#define CLR_NUM0(x)             x.bCom4 &= ~0x10
#define SET_DEGREES(x)		x.bCom1 |= 0x20
#define CLR_DEGREES(x)          x.bCom1 &= ~0x20
#define SET_PERCENT(x)		x.bCom2 |= 0x20
#define CLR_PERCENT(x)          x.bCom2 &= ~0x20
#define SET_COLON(x)		x.bCom4 |= 0x04
#define CLR_COLON(x)            x.bCom4 &= ~0x04
#define SET_AM(x)		x.bCom3 |= 0x20
#define CLR_AM(x)               x.bCom3 &= ~0x20
#define SET_PM(x)		x.bCom4 |= 0x20
#define CLR_PM(x)               x.bCom4 &= ~0x20

/* Macros for setting and clearing numeric segments */
#define SET_NUM1_A(x)           x.bCom1 |= 0x02
#define SET_NUM1_B(x)           x.bCom2 |= 0x02
#define SET_NUM1_C(x)           x.bCom3 |= 0x02
#define SET_NUM1_D(x)           x.bCom4 |= 0x02
#define SET_NUM1_E(x)           x.bCom3 |= 0x01
#define SET_NUM1_F(x)           x.bCom1 |= 0x01
#define SET_NUM1_G(x)           x.bCom2 |= 0x01
#define SET_NUM2_A(x)           x.bCom1 |= 0x08
#define SET_NUM2_B(x)           x.bCom2 |= 0x08
#define SET_NUM2_C(x)           x.bCom3 |= 0x08
#define SET_NUM2_D(x)           x.bCom4 |= 0x08
#define SET_NUM2_E(x)           x.bCom3 |= 0x04
#define SET_NUM2_F(x)           x.bCom1 |= 0x04
#define SET_NUM2_G(x)           x.bCom2 |= 0x04
#define SET_NUM3_A(x)           x.bCom1 |= 0x40
#define SET_NUM3_B(x)           x.bCom2 |= 0x40
#define SET_NUM3_C(x)           x.bCom3 |= 0x40
#define SET_NUM3_D(x)           x.bCom4 |= 0x40
#define SET_NUM3_E(x)           x.bCom3 |= 0x10
#define SET_NUM3_F(x)           x.bCom1 |= 0x10
#define SET_NUM3_G(x)           x.bCom2 |= 0x10
#define CLR_NUM1(x)             x.bCom1 &= ~0x03;\
                                x.bCom2 &= ~0x03;\
                                x.bCom3 &= ~0x03;\
                                x.bCom4 &= ~0x02
#define CLR_NUM2(x)             x.bCom1 &= ~0x0C;\
                                x.bCom2 &= ~0x0C;\
                                x.bCom3 &= ~0x0C;\
                                x.bCom4 &= ~0x08
#define CLR_NUM3(x)             x.bCom1 &= ~0x50;\
                                x.bCom2 &= ~0x50;\
                                x.bCom3 &= ~0x50;\
                                x.bCom4 &= ~0x40

/***************************************************************
 * 			  Data Types
 **************************************************************/

typedef struct{
	unsigned char	bCom1;
	unsigned char	bCom2;
	unsigned char	bCom3;
	unsigned char	bCom4;
}tSLCD;

typedef enum{
        SLCD_CLK_DEFAULT,
        SLCD_CLK_ALTERNATE
}SLCD_CLK_SOURCES;

/***************************************************************
 * 			  Functions
 **************************************************************/
void vfnSlcdInit(unsigned char u8ClkSource);
void vfnSlcdRefresh(tSLCD Matrix);
void vfnSlcdDeinit (void);
unsigned char u8SlcdSetNumericSeg(unsigned char u8Segment, unsigned char u8Number, tSLCD* inputMatrix);
unsigned char u8SlcdSetNumber(unsigned short u16Number, tSLCD* inputMatrix);
void vfnSlcdSetTextLp (tSLCD* matrix);
void vfnSlcdSetTextUsb (tSLCD* matrix);

                        
#endif /* K53_LCD_HANDLER_H_ */
