/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file lpb_ui.h
 *
 * @author  
 *
 * @version 1.0
 *
 * @date Jun-11-2012
 *
 * @brief Configurations for the low power board leds and push buttons
 *
 *****************************************************************************/
#ifndef _LPB_UI_H
#define _LPB_UI_H

#include "derivative.h"

/*****************************************************************************
 *                               Definitions
 *****************************************************************************/


/*****************************************************************************
 *                             LED1 Definitions 
 *****************************************************************************/

#define LED1_NUMBER_IN_PORT     7
#define LED1_PCR                PORTC_PCR7
#define LED1_DDR_REG            GPIOC_PDDR
#define LED1_SET_REG            GPIOC_PSOR
#define LED1_CLR_REG            GPIOC_PCOR
#define LED1_TGL_REG            GPIOC_PTOR 
#define LED1_SIM_REG            SIM_SCGC5_PORTC_MASK

#define LED1_INIT()        SIM_SCGC5 |= LED1_SIM_REG;\
                           LED1_PCR = PORT_PCR_MUX(1);\
                           LED1_DDR_REG |= (1<<LED1_NUMBER_IN_PORT);\
                           LED1_SET_REG |= (1<<LED1_NUMBER_IN_PORT)

#define LED1_ON()          LED1_CLR_REG |= (1<<LED1_NUMBER_IN_PORT) //LED sets with logical 0 on port
#define LED1_OFF()         LED1_SET_REG |= (1<<LED1_NUMBER_IN_PORT) //LED resets with logical 1 on port
#define LED1_TOGGLE()      LED1_TGL_REG |= (1<<LED1_NUMBER_IN_PORT) //LED toggles writing a logical 1 on TOR REG

/*****************************************************************************
 *                             LED2 Definitions 
 *****************************************************************************/

#define LED2_NUMBER_IN_PORT     8
#define LED2_PCR                PORTC_PCR8
#define LED2_DDR_REG            GPIOC_PDDR
#define LED2_SET_REG            GPIOC_PSOR
#define LED2_CLR_REG            GPIOC_PCOR
#define LED2_TGL_REG            GPIOC_PTOR 
#define LED2_SIM_REG            SIM_SCGC5_PORTC_MASK

#define LED2_INIT()        SIM_SCGC5 |= LED2_SIM_REG;\
                           LED2_PCR = PORT_PCR_MUX(1); \
                           LED2_DDR_REG |= (1<<LED2_NUMBER_IN_PORT);\
                           LED2_SET_REG |= (1<<LED2_NUMBER_IN_PORT)

#define LED2_ON()          LED2_CLR_REG |= (1<<LED2_NUMBER_IN_PORT) //LED sets with logical 0 on port
#define LED2_OFF()         LED2_SET_REG |= (1<<LED2_NUMBER_IN_PORT) //LED resets with logical 1 on port
#define LED2_TOGGLE()      LED2_TGL_REG |= (1<<LED2_NUMBER_IN_PORT) //LED toggles writing a logical 1 on TOR REG

/*****************************************************************************
 *                           Push Button 1 Definitions 
 *****************************************************************************/

#define PB1_NUMBER_IN_PORT     0
#define PB1_PCR                PORTC_PCR0
#define PB1_DDR_REG            GPIOC_PDDR
#define PB1_DIR_REG            GPIOC_PDIR
#define PB1_SIM_REG            SIM_SCGC5_PORTC_MASK

#define PB1_INIT()         SIM_SCGC5 |= PB1_SIM_REG;\
                           PB1_PCR = PORT_PCR_MUX(1) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;\
                           PB1_DDR_REG &= (~(1 << PB2_NUMBER_IN_PORT))

#define PB1_STATUS         (PB1_DIR_REG & (1<<PB1_NUMBER_IN_PORT))

/*****************************************************************************
 *                           Push Button 2 Definitions 
 *****************************************************************************/

#define PB2_NUMBER_IN_PORT     0
#define PB2_PCR                PORTC_PCR0
#define PB2_DDR_REG            GPIOC_PDDR
#define PB2_DIR_REG            GPIOC_PDIR
#define PB2_SIM_REG            SIM_SCGC5_PORTC_MASK

#define PB2_INIT()         SIM_SCGC5 |= PB2_SIM_REG;\
                           PB2_PCR =  PORT_PCR_MUX(1) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK ;\
                           PB2_DDR_REG &= (~(1 << PB2_NUMBER_IN_PORT))

#define PB2_STATUS         (PB2_DIR_REG & (1<<PB2_NUMBER_IN_PORT))

/*****************************************************************************/

#define INIT_ALL_LEDS()           LED1_INIT();\
                                  LED2_INIT()

#define INIT_ALL_PBS()            PB1_INIT();\
                                  PB2_INIT()

/*****************************************************************************
 *                             Medical Connector
 *****************************************************************************/

#define MEDCON_NUMBER_IN_PORT     14
#define MEDCON_PCR                PORTC_PCR14
#define MEDCON_DDR_REG            GPIOC_PDDR
#define MEDCON_SET_REG            GPIOC_PSOR
#define MEDCON_CLR_REG            GPIOC_PCOR
#define MEDCON_SIM_REG            SIM_SCGC5_PORTC_MASK

#define MEDCON_INIT()           SIM_SCGC5 |= MEDCON_SIM_REG;\
                                MEDCON_PCR |= PORT_PCR_MUX(1);\
                                MEDCON_CLR_REG |= (1<<MEDCON_NUMBER_IN_PORT);\
                                MEDCON_DDR_REG |= (1<<MEDCON_NUMBER_IN_PORT)
                                
#define MEDCON_PWRON()          MEDCON_CLR_REG |= (1<<MEDCON_NUMBER_IN_PORT)

#define MEDCON_PWROFF()         MEDCON_SET_REG |= (1<<MEDCON_NUMBER_IN_PORT)

#endif
/* End of file */
