/*
 * FTM.c
 *
 *  Created on: Apr 29, 2014
 *      Author: B36727
 */


#include "FTM.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/

/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/
#define OVF_COUNTS 50
UINT8 counts = OVF_COUNTS; //number of Timer Overflows before increasing the pulse-width


/**********************************************************************************************
* Local functions
**********************************************************************************************/
void FTM2_IRQHandler();

/**********************************************************************************************
* Global functions
**********************************************************************************************/
/***********************************************************************************************
*
* @brief    FTM_Init - Initialize the FTM counter with interrupt enable
* @param    none
* @return   none
*
************************************************************************************************/
void FTM_Init()
{

	
	SIM_SCGC |= SIM_SCGC_FTM2_MASK; /* Enable Clock for FTM2 */
	
	
	FTM2_SC |= FTM_SC_PS(2);	/* Select Preescaler in this case 4. 20 Mhz /4 =5 Mhz. */ 
	FTM2_SC |= FTM_SC_TOIE_MASK; /*FTM Interrupt Enable */				
	FTM2_MOD =5000;              /* PWM frequency is about 1 KHz (5Mhz/5000)*/
	
	/* Enable Channle 0*/	
	FTM2_C0SC |= FTM_CnSC_MSB_MASK;  /* Channel as Edge aligned PWM */
	FTM2_C0SC |= FTM_CnSC_ELSB_MASK; /* High-true pulses */
	
	/*Set the output pin*/
	SIM_PINSEL1_FTM2PS0(0x00);  /*Enable Channel 0 at PTC0*/ 
		
	/*Select interrupt frequency*/
	FTM2_C0V = FTM_CnV_VAL(2500) ; /*Channel 0 set to 50%*/	 
	//FTM2_SC |= FTM_SC_CLKS(1); /*FTM2 use system clock*/		
	 
}



/***********************************************************************************************
*
* @brief    FTM2_IRQHandler - Interrupt for FTM channels, clear flag, set new tiemout and execute callback 
* @param    none
* @return   none
*
************************************************************************************************/
void FTM2_IRQHandler()
{
	 //Clear interrupt flag
	  (void)FTM2_SC;
	  FTM2_SC ^= FTM_SC_TOF_MASK;  			/* Clear flag */
  counts--;
	  if (!counts)
	  {
		  if (rpm_target > read_rpm)
		  {
			  if (FTM2_C0V <= 4950)
			  FTM2_C0V += 10;     // increase the channel value
		  }
		  else if (rpm_target < read_rpm)
		  {
			  if (FTM2_C0V >= 50)
			  FTM2_C0V -= 10;     // decrease the channel value
		  }
		  counts = OVF_COUNTS;    
	  } 
}
