/*
 * PWT.c
 *
 *  Created on: Jul 14, 2014
 *      Author: B36727
 */


#include "PWT.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/
extern UINT32 read_rpm;
extern UINT32 rpm_target;
extern UINT8 ch;

/**********************************************************************************************
* Global variables
**********************************************************************************************/
UINT32 pwt_t;
/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/
void PWT_IRQHandler();

/**********************************************************************************************
* Global functions
**********************************************************************************************/
/***********************************************************************************************
*
* @brief    Enable_Interrupt(UINT8 vector_number). Enable interrupts from desired module.
* @param    Module interrupt number from the interrupts vector table
* @return   none
*
*
************************************************************************************************/
void PWT_Init()
{
	SIM_SCGC |= SIM_SCGC_PWT_MASK; /* Enable Clock for PWT module */
	/*Reset the module*/
	PWT_R1 = PWT_R1_PWTSR_MASK; /*Soft Reset */
	
	/*Set the input pin*/
	 /*PTD5 is by reset PWTIN0*/ 
	/* PWT clock set, PWTIN0 enable*/ 
	PWT_R1 |= PWT_R1_PRE(6);		/* Select Preescaler in this case 64. 20 Mhz /64 =312500 Hz.*/
	PWT_R1 |= PWT_R1_EDGE(3);    	/*falling edge and subsequent falling edges*/
	//PWT_R1 |= PWT_R1_POVIE_MASK;	/* PWT Counter Overflow Interrupt Enable*/
	PWT_R1 |= PWT_R1_PRDYIE_MASK;	/* PWT Pulse Width Data Ready Interrupt Enable*/
	PWT_R1 |= PWT_R1_PWTIE_MASK; 		/* PWT Module Interrupt Enable*/
	
	
}

/***********************************************************************************************
*
* @brief    PWT_IRQHandler - Interrupt for PWT, clear flag,  
* @param    none
* @return   none
*
************************************************************************************************/
void PWT_IRQHandler()
{
	 //Clear interrupt flag
	 pwt_t = (PWT_R2&0x0000FFFF); 
	 read_rpm =((312500*60)/pwt_t); // 60 is to convert to rpms
	 if (read_rpm > 10000)
	 {
			
			 GPIOA_PTOR |= (1 << 19);				/*toggle output ptc3 */
		 } 
	 (void)PWT_R1;
	
		 
	 PWT_R1 ^= PWT_R1_PWTRDY_MASK;		 /* Clear flag */
}
