/******************************************************************************								
*     - Pulse Width Timer (PWT) 				                            	*								
*                                                                             	*								
*       This lab demonstrates how to use the PWT module to control 			  	*								
*    a DC motor. It uses the FTM and the PWT								 	*
*    										                                  	*								
*       To use this demo you need to open a  serial terminal. The OpenSDA port  *
*       is used to communicate via UART2 to the KEA128 microcontroller.         *								
*                                                                             	*								
*       Open the Terminal Utility and set the baud rate to 9600, leave all    	*								
*    the other settings with the default values. Click the Open Port button   	*								
*    and the console should connect.                              *								
******************************************************************************/								



/**********************************************************************************************
* External objects
**********************************************************************************************/
#include "derivative.h" /* include peripheral declarations */
#include "UART.h"
#include "CLK.h"
#include "CsIO1.h"
/**********************************************************************************************
* Global variables
**********************************************************************************************/


UINT32 read_rpm = 0;
UINT32 rpm_target =0;
UINT8 ch = 0;


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/
UINT8 menu = 0;

/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/
void FTM_Interrupt(UINT8 ch);
void Enable_Interrupt(UINT8 vector_number);

/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/


/***********************************************************************************************
*
* @brief    main() - Program entry function
* @param    none
* @return   none
*
************************************************************************************************/  
int main(void)
{
	UINT32 counter = 0;
	
	 Clk_Init(); 						/* Configure clocks to run at 20 Mhz */
	 UART_Init();						/*Initialize Uart 2 at 9600 bauds */
	 put("\r***PWT demo code***\r\n");
	 put("Press one option (a,b,c)\r\n");
	 put("a)Motor at 3500 rpm\r\n");
	 put("b)Motor at 2500 rpm\r\n");
	 put("c)Motor at 1500 rpm\r\n");
	 FTM_Init();						/* Initialize the FTM module */
	 Enable_Interrupt(INT_FTM2);  	/* Enable FTM2 interrupt */
	 PWT_Init();
	 Enable_Interrupt(INT_PWT);  	/* Enable PWT interrupt */
	 
	 GPIOA_PDDR |= (1 <<19);  /* PTC 3 as output*/
	 GPIOA_PTOR |= (1 << 19);				/*toggle output ptc3 */
	 	 
	while(!menu) 
	{	
		ch = Uart_GetChar();
		switch (ch)
			{
				case ('a'):
					rpm_target = 3500;
					FTM2_SC |= FTM_SC_CLKS(1); /*FTM2 use system clock*/
				    PWT_R1 |= PWT_R1_PWTEN_MASK;    /* Enable PWT module*/
					menu = 1;
					break;
				
				case ('b'):
					rpm_target = 2500;
					FTM2_SC |= FTM_SC_CLKS(1); /*FTM2 use system clock*/
					PWT_R1 |= PWT_R1_PWTEN_MASK;    /* Enable PWT module*/
					menu = 1;
					break;
				
				case ('c'):
					rpm_target = 1500;
					FTM2_SC |= FTM_SC_CLKS(1); /*FTM2 use system clock*/
					PWT_R1 |= PWT_R1_PWTEN_MASK;    /* Enable PWT module*/
					menu = 1;
					break;
				default:
					put("Not valid Key\r\n");
					put("Press one option (a,b,c)\r\n");
					//break; 
			}
		}
	   	
	for (;;)
	{
	   	printf("\r Motor motor rpm set (%i), real rpm (%i)", rpm_target, read_rpm);
	   	some_delay(30000);
	}
	
	return 0;
}

/***********************************************************************************************
*
* @brief    Uart_Interrupt(UINT8 data). Serial reception callback. This function is called each time a character
* 				is received on the serial port.
* @param    data received from serial port
* @return   none
*
************************************************************************************************/  
void Uart_Interrupt (UINT8 data)
{
	 Uart_SendChar(data); /* Echos data that is received*/


}

/***********************************************************************************************
*
* @brief    Enable_Interrupt(UINT8 vector_number). Enable interrupts from desired module.
* @param    Module interrupt number from the interrupts vector table
* @return   none
*
************************************************************************************************/  
void Enable_Interrupt(UINT8 vector_number)
{
	
	vector_number= vector_number-16;

	
	/* Set the ICPR and ISER registers accordingly */
	NVIC_ICPR |= 1 << (vector_number%32);
	NVIC_ISER |= 1 << (vector_number%32);

}

/************************************************************************************************/  

/************************************************************************************************  
*
* @brief    A delay function
* @param    none
* @return   none
*
/************************************************************************************************/	
void some_delay(UINT32 t)
{ 
	while(t) t--;
}	
	
