/** ###################################################################
 **     Filename    : AOI_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the AOI module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void AOI_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file AOI_Init.c
 * @version 1.0
 * @brief This file implements the AOI module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE AOI_Init. */

#include "AOI_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void AOI_Init(void) {

  /* Register 'AOI_BFCRT010' initialization */
  #ifdef AOI_BFCRT010_VALUE
  AOI_BFCRT010 = AOI_BFCRT010_VALUE;
  #endif

  /* Register 'AOI_BFCRT230' initialization */
  #ifdef AOI_BFCRT230_VALUE
  AOI_BFCRT230 = AOI_BFCRT230_VALUE;
  #endif

  /* Register 'AOI_BFCRT011' initialization */
  #ifdef AOI_BFCRT011_VALUE
  AOI_BFCRT011 = AOI_BFCRT011_VALUE;
  #endif

  /* Register 'AOI_BFCRT231' initialization */
  #ifdef AOI_BFCRT231_VALUE
  AOI_BFCRT231 = AOI_BFCRT231_VALUE;
  #endif

  /* Register 'AOI_BFCRT012' initialization */
  #ifdef AOI_BFCRT012_VALUE
  AOI_BFCRT012 = AOI_BFCRT012_VALUE;
  #endif

  /* Register 'AOI_BFCRT232' initialization */
  #ifdef AOI_BFCRT232_VALUE
  AOI_BFCRT232 = AOI_BFCRT232_VALUE;
  #endif

  /* Register 'AOI_BFCRT013' initialization */
  #ifdef AOI_BFCRT013_VALUE
  AOI_BFCRT013 = AOI_BFCRT013_VALUE;
  #endif

  /* Register 'AOI_BFCRT233' initialization */
  #ifdef AOI_BFCRT233_VALUE
  AOI_BFCRT233 = AOI_BFCRT233_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END AOI_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
