/** ###################################################################
 **     Filename    : CMPB_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.7
 **     Abstract    :
 **          This file implements the CMPB module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void CMPB_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file CMPB_Init.c
 * @version 1.7
 * @brief This file implements the CMPB module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE CMPB_Init. */

#include "CMPB_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void CMPB_Init(void) {

  CMPB_CR1 = 0;

  CMPB_CR0 = 0;

  CMPB_MUXCR = 0;

  /* Register 'CMPB_FPR' initialization */
  #if CMPB_FPR_MASK
    #if CMPB_FPR_MASK == 0xFFFF
  CMPB_FPR = CMPB_FPR_VALUE;
    #elif CMPB_FPR_MASK == CMPB_FPR_VALUE
  CMPB_FPR |= CMPB_FPR_VALUE;
    #elif CMPB_FPR_VALUE == 0
  CMPB_FPR &= ~CMPB_FPR_MASK;
    #else
  CMPB_FPR = (CMPB_FPR & (~CMPB_FPR_MASK)) | CMPB_FPR_VALUE;
    #endif
  #elif defined(CMPB_FPR_VALUE)
  CMPB_FPR = CMPB_FPR_VALUE;
  #endif

  /* Register 'CMPB_CR1' initialization */
  #ifdef CMPB_CR1_VALUE_1
  CMPB_CR1 = CMPB_CR1_VALUE_1;
  #endif

  /* Register 'CMPB_SCR' initialization */
  #ifdef CMPB_SCR_VALUE
  CMPB_SCR = CMPB_SCR_VALUE;
  #endif

  /* Register 'CMPB_CR0' initialization */
  #ifdef CMPB_CR0_VALUE
  CMPB_CR0 = CMPB_CR0_VALUE;
  #endif

  /* Register 'CMPB_DACCR' initialization */
  #if CMPB_DACCR_MASK
    #if CMPB_DACCR_MASK == 0xFFFF
  CMPB_DACCR = CMPB_DACCR_VALUE;
    #elif CMPB_DACCR_MASK == CMPB_DACCR_VALUE
  CMPB_DACCR |= CMPB_DACCR_VALUE;
    #elif CMPB_DACCR_VALUE == 0
  CMPB_DACCR &= ~CMPB_DACCR_MASK;
    #else
  CMPB_DACCR = (CMPB_DACCR & (~CMPB_DACCR_MASK)) | CMPB_DACCR_VALUE;
    #endif
  #elif defined(CMPB_DACCR_VALUE)
  CMPB_DACCR = CMPB_DACCR_VALUE;
  #endif

  /* Register 'CMPB_MUXCR' initialization */
  #ifdef CMPB_MUXCR_VALUE
  CMPB_MUXCR = CMPB_MUXCR_VALUE;
  #endif

  /* Register 'CMPB_CR1' initialization */
  #if CMPB_CR1_MASK_2
    #if CMPB_CR1_MASK_2 == 0xFFFF
  CMPB_CR1 = CMPB_CR1_VALUE_2;
    #elif CMPB_CR1_MASK_2 == CMPB_CR1_VALUE_2
  CMPB_CR1 |= CMPB_CR1_VALUE_2;
    #elif CMPB_CR1_VALUE_2 == 0
  CMPB_CR1 &= ~CMPB_CR1_MASK_2;
    #else
  CMPB_CR1 = (CMPB_CR1 & (~CMPB_CR1_MASK_2)) | CMPB_CR1_VALUE_2;
    #endif
  #elif defined(CMPB_CR1_VALUE_2)
  CMPB_CR1 = CMPB_CR1_VALUE_2;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END CMPB_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
