/** ###################################################################
 **     Filename    : CMPC_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.7
 **     Abstract    :
 **          This file implements the CMPC module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void CMPC_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file CMPC_Init.c
 * @version 1.7
 * @brief This file implements the CMPC module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE CMPC_Init. */

#include "CMPC_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void CMPC_Init(void) {

  CMPC_CR1 = 0;

  CMPC_CR0 = 0;

  CMPC_MUXCR = 0;

  /* Register 'CMPC_FPR' initialization */
  #if CMPC_FPR_MASK
    #if CMPC_FPR_MASK == 0xFFFF
  CMPC_FPR = CMPC_FPR_VALUE;
    #elif CMPC_FPR_MASK == CMPC_FPR_VALUE
  CMPC_FPR |= CMPC_FPR_VALUE;
    #elif CMPC_FPR_VALUE == 0
  CMPC_FPR &= ~CMPC_FPR_MASK;
    #else
  CMPC_FPR = (CMPC_FPR & (~CMPC_FPR_MASK)) | CMPC_FPR_VALUE;
    #endif
  #elif defined(CMPC_FPR_VALUE)
  CMPC_FPR = CMPC_FPR_VALUE;
  #endif

  /* Register 'CMPC_CR1' initialization */
  #ifdef CMPC_CR1_VALUE_1
  CMPC_CR1 = CMPC_CR1_VALUE_1;
  #endif

  /* Register 'CMPC_SCR' initialization */
  #ifdef CMPC_SCR_VALUE
  CMPC_SCR = CMPC_SCR_VALUE;
  #endif

  /* Register 'CMPC_CR0' initialization */
  #ifdef CMPC_CR0_VALUE
  CMPC_CR0 = CMPC_CR0_VALUE;
  #endif

  /* Register 'CMPC_DACCR' initialization */
  #if CMPC_DACCR_MASK
    #if CMPC_DACCR_MASK == 0xFFFF
  CMPC_DACCR = CMPC_DACCR_VALUE;
    #elif CMPC_DACCR_MASK == CMPC_DACCR_VALUE
  CMPC_DACCR |= CMPC_DACCR_VALUE;
    #elif CMPC_DACCR_VALUE == 0
  CMPC_DACCR &= ~CMPC_DACCR_MASK;
    #else
  CMPC_DACCR = (CMPC_DACCR & (~CMPC_DACCR_MASK)) | CMPC_DACCR_VALUE;
    #endif
  #elif defined(CMPC_DACCR_VALUE)
  CMPC_DACCR = CMPC_DACCR_VALUE;
  #endif

  /* Register 'CMPC_MUXCR' initialization */
  #ifdef CMPC_MUXCR_VALUE
  CMPC_MUXCR = CMPC_MUXCR_VALUE;
  #endif

  /* Register 'CMPC_CR1' initialization */
  #if CMPC_CR1_MASK_2
    #if CMPC_CR1_MASK_2 == 0xFFFF
  CMPC_CR1 = CMPC_CR1_VALUE_2;
    #elif CMPC_CR1_MASK_2 == CMPC_CR1_VALUE_2
  CMPC_CR1 |= CMPC_CR1_VALUE_2;
    #elif CMPC_CR1_VALUE_2 == 0
  CMPC_CR1 &= ~CMPC_CR1_MASK_2;
    #else
  CMPC_CR1 = (CMPC_CR1 & (~CMPC_CR1_MASK_2)) | CMPC_CR1_VALUE_2;
    #endif
  #elif defined(CMPC_CR1_VALUE_2)
  CMPC_CR1 = CMPC_CR1_VALUE_2;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END CMPC_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
