/** ###################################################################
 **     Filename    : COP_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.1
 **     Abstract    :
 **          This file implements the COP module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void COP_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file COP_Init.c
 * @version 1.1
 * @brief This file implements the COP module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE COP_Init. */

#include "COP_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void COP_Init(void) {

  /* Register 'COP_CTRL' initialization */
  #ifdef COP_CTRL_VALUE_1
  COP_CTRL = COP_CTRL_VALUE_1;
  #endif

  /* Register 'COP_TOUT' initialization */
  #ifdef COP_TOUT_VALUE
  COP_TOUT = COP_TOUT_VALUE;
  #endif

  /* Register 'COP_INTVAL' initialization */
  #ifdef COP_INTVAL_VALUE
  COP_INTVAL = COP_INTVAL_VALUE;
  #endif

  /* Register 'COP_WINDOW' initialization */
  #ifdef COP_WINDOW_VALUE
  COP_WINDOW = COP_WINDOW_VALUE;
  #endif

  /* Register 'COP_CTRL' initialization */
  #if COP_CTRL_MASK_2
    #if COP_CTRL_MASK_2 == 0xFFFF
  COP_CTRL = COP_CTRL_VALUE_2;
    #elif COP_CTRL_MASK_2 == COP_CTRL_VALUE_2
  COP_CTRL |= COP_CTRL_VALUE_2;
    #elif COP_CTRL_VALUE_2 == 0
  COP_CTRL &= ~COP_CTRL_MASK_2;
    #else
  COP_CTRL = (COP_CTRL & (~COP_CTRL_MASK_2)) | COP_CTRL_VALUE_2;
    #endif
  #elif defined(COP_CTRL_VALUE_2)
  COP_CTRL = COP_CTRL_VALUE_2;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END COP_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
