/** ###################################################################
 **     Filename    : DACA_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the DACA module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void DACA_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file DACA_Init.c
 * @version 1.0
 * @brief This file implements the DACA module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE DACA_Init. */

#include "DACA_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void DACA_Init(void) {

  /* Register 'DACA_CTRL1' initialization */
  #ifdef DACA_CTRL1_VALUE
  DACA_CTRL1 = DACA_CTRL1_VALUE;
  #endif

  /* Register 'DACA_DATAREG_FMT0' initialization */
  #if DACA_DATAREG_FMT0_MASK
    #if DACA_DATAREG_FMT0_MASK == 0xFFFF
  DACA_DATAREG_FMT0 = DACA_DATAREG_FMT0_VALUE;
    #elif DACA_DATAREG_FMT0_MASK == DACA_DATAREG_FMT0_VALUE
  DACA_DATAREG_FMT0 |= DACA_DATAREG_FMT0_VALUE;
    #elif DACA_DATAREG_FMT0_VALUE == 0
  DACA_DATAREG_FMT0 &= ~DACA_DATAREG_FMT0_MASK;
    #else
  DACA_DATAREG_FMT0 = (DACA_DATAREG_FMT0 & (~DACA_DATAREG_FMT0_MASK)) | DACA_DATAREG_FMT0_VALUE;
    #endif
  #elif defined(DACA_DATAREG_FMT0_VALUE)
  DACA_DATAREG_FMT0 = DACA_DATAREG_FMT0_VALUE;
  #endif

  /* Register 'DACA_DATAREG_FMT1' initialization */
  #if DACA_DATAREG_FMT1_MASK
    #if DACA_DATAREG_FMT1_MASK == 0xFFFF
  DACA_DATAREG_FMT1 = DACA_DATAREG_FMT1_VALUE;
    #elif DACA_DATAREG_FMT1_MASK == DACA_DATAREG_FMT1_VALUE
  DACA_DATAREG_FMT1 |= DACA_DATAREG_FMT1_VALUE;
    #elif DACA_DATAREG_FMT1_VALUE == 0
  DACA_DATAREG_FMT1 &= ~DACA_DATAREG_FMT1_MASK;
    #else
  DACA_DATAREG_FMT1 = (DACA_DATAREG_FMT1 & (~DACA_DATAREG_FMT1_MASK)) | DACA_DATAREG_FMT1_VALUE;
    #endif
  #elif defined(DACA_DATAREG_FMT1_VALUE)
  DACA_DATAREG_FMT1 = DACA_DATAREG_FMT1_VALUE;
  #endif

  /* Register 'DACA_MINVAL_FMT0' initialization */
  #if DACA_MINVAL_FMT0_MASK
    #if DACA_MINVAL_FMT0_MASK == 0xFFFF
  DACA_MINVAL_FMT0 = DACA_MINVAL_FMT0_VALUE;
    #elif DACA_MINVAL_FMT0_MASK == DACA_MINVAL_FMT0_VALUE
  DACA_MINVAL_FMT0 |= DACA_MINVAL_FMT0_VALUE;
    #elif DACA_MINVAL_FMT0_VALUE == 0
  DACA_MINVAL_FMT0 &= ~DACA_MINVAL_FMT0_MASK;
    #else
  DACA_MINVAL_FMT0 = (DACA_MINVAL_FMT0 & (~DACA_MINVAL_FMT0_MASK)) | DACA_MINVAL_FMT0_VALUE;
    #endif
  #elif defined(DACA_MINVAL_FMT0_VALUE)
  DACA_MINVAL_FMT0 = DACA_MINVAL_FMT0_VALUE;
  #endif

  /* Register 'DACA_MINVAL_FMT1' initialization */
  #if DACA_MINVAL_FMT1_MASK
    #if DACA_MINVAL_FMT1_MASK == 0xFFFF
  DACA_MINVAL_FMT1 = DACA_MINVAL_FMT1_VALUE;
    #elif DACA_MINVAL_FMT1_MASK == DACA_MINVAL_FMT1_VALUE
  DACA_MINVAL_FMT1 |= DACA_MINVAL_FMT1_VALUE;
    #elif DACA_MINVAL_FMT1_VALUE == 0
  DACA_MINVAL_FMT1 &= ~DACA_MINVAL_FMT1_MASK;
    #else
  DACA_MINVAL_FMT1 = (DACA_MINVAL_FMT1 & (~DACA_MINVAL_FMT1_MASK)) | DACA_MINVAL_FMT1_VALUE;
    #endif
  #elif defined(DACA_MINVAL_FMT1_VALUE)
  DACA_MINVAL_FMT1 = DACA_MINVAL_FMT1_VALUE;
  #endif

  /* Register 'DACA_MAXVAL_FMT0' initialization */
  #if DACA_MAXVAL_FMT0_MASK
    #if DACA_MAXVAL_FMT0_MASK == 0xFFFF
  DACA_MAXVAL_FMT0 = DACA_MAXVAL_FMT0_VALUE;
    #elif DACA_MAXVAL_FMT0_MASK == DACA_MAXVAL_FMT0_VALUE
  DACA_MAXVAL_FMT0 |= DACA_MAXVAL_FMT0_VALUE;
    #elif DACA_MAXVAL_FMT0_VALUE == 0
  DACA_MAXVAL_FMT0 &= ~DACA_MAXVAL_FMT0_MASK;
    #else
  DACA_MAXVAL_FMT0 = (DACA_MAXVAL_FMT0 & (~DACA_MAXVAL_FMT0_MASK)) | DACA_MAXVAL_FMT0_VALUE;
    #endif
  #elif defined(DACA_MAXVAL_FMT0_VALUE)
  DACA_MAXVAL_FMT0 = DACA_MAXVAL_FMT0_VALUE;
  #endif

  /* Register 'DACA_MAXVAL_FMT1' initialization */
  #if DACA_MAXVAL_FMT1_MASK
    #if DACA_MAXVAL_FMT1_MASK == 0xFFFF
  DACA_MAXVAL_FMT1 = DACA_MAXVAL_FMT1_VALUE;
    #elif DACA_MAXVAL_FMT1_MASK == DACA_MAXVAL_FMT1_VALUE
  DACA_MAXVAL_FMT1 |= DACA_MAXVAL_FMT1_VALUE;
    #elif DACA_MAXVAL_FMT1_VALUE == 0
  DACA_MAXVAL_FMT1 &= ~DACA_MAXVAL_FMT1_MASK;
    #else
  DACA_MAXVAL_FMT1 = (DACA_MAXVAL_FMT1 & (~DACA_MAXVAL_FMT1_MASK)) | DACA_MAXVAL_FMT1_VALUE;
    #endif
  #elif defined(DACA_MAXVAL_FMT1_VALUE)
  DACA_MAXVAL_FMT1 = DACA_MAXVAL_FMT1_VALUE;
  #endif

  /* Register 'DACA_STEPVAL_FMT0' initialization */
  #if DACA_STEPVAL_FMT0_MASK
    #if DACA_STEPVAL_FMT0_MASK == 0xFFFF
  DACA_STEPVAL_FMT0 = DACA_STEPVAL_FMT0_VALUE;
    #elif DACA_STEPVAL_FMT0_MASK == DACA_STEPVAL_FMT0_VALUE
  DACA_STEPVAL_FMT0 |= DACA_STEPVAL_FMT0_VALUE;
    #elif DACA_STEPVAL_FMT0_VALUE == 0
  DACA_STEPVAL_FMT0 &= ~DACA_STEPVAL_FMT0_MASK;
    #else
  DACA_STEPVAL_FMT0 = (DACA_STEPVAL_FMT0 & (~DACA_STEPVAL_FMT0_MASK)) | DACA_STEPVAL_FMT0_VALUE;
    #endif
  #elif defined(DACA_STEPVAL_FMT0_VALUE)
  DACA_STEPVAL_FMT0 = DACA_STEPVAL_FMT0_VALUE;
  #endif

  /* Register 'DACA_STEPVAL_FMT1' initialization */
  #if DACA_STEPVAL_FMT1_MASK
    #if DACA_STEPVAL_FMT1_MASK == 0xFFFF
  DACA_STEPVAL_FMT1 = DACA_STEPVAL_FMT1_VALUE;
    #elif DACA_STEPVAL_FMT1_MASK == DACA_STEPVAL_FMT1_VALUE
  DACA_STEPVAL_FMT1 |= DACA_STEPVAL_FMT1_VALUE;
    #elif DACA_STEPVAL_FMT1_VALUE == 0
  DACA_STEPVAL_FMT1 &= ~DACA_STEPVAL_FMT1_MASK;
    #else
  DACA_STEPVAL_FMT1 = (DACA_STEPVAL_FMT1 & (~DACA_STEPVAL_FMT1_MASK)) | DACA_STEPVAL_FMT1_VALUE;
    #endif
  #elif defined(DACA_STEPVAL_FMT1_VALUE)
  DACA_STEPVAL_FMT1 = DACA_STEPVAL_FMT1_VALUE;
  #endif

  /* Register 'DACA_CTRL0' initialization */
  #ifdef DACA_CTRL0_VALUE
  DACA_CTRL0 = DACA_CTRL0_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END DACA_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
