/** ###################################################################
 **     Filename    : DACB_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the DACB module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void DACB_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file DACB_Init.c
 * @version 1.0
 * @brief This file implements the DACB module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE DACB_Init. */

#include "DACB_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void DACB_Init(void) {

  /* Register 'DACB_CTRL1' initialization */
  #ifdef DACB_CTRL1_VALUE
  DACB_CTRL1 = DACB_CTRL1_VALUE;
  #endif

  /* Register 'DACB_DATAREG_FMT0' initialization */
  #if DACB_DATAREG_FMT0_MASK
    #if DACB_DATAREG_FMT0_MASK == 0xFFFF
  DACB_DATAREG_FMT0 = DACB_DATAREG_FMT0_VALUE;
    #elif DACB_DATAREG_FMT0_MASK == DACB_DATAREG_FMT0_VALUE
  DACB_DATAREG_FMT0 |= DACB_DATAREG_FMT0_VALUE;
    #elif DACB_DATAREG_FMT0_VALUE == 0
  DACB_DATAREG_FMT0 &= ~DACB_DATAREG_FMT0_MASK;
    #else
  DACB_DATAREG_FMT0 = (DACB_DATAREG_FMT0 & (~DACB_DATAREG_FMT0_MASK)) | DACB_DATAREG_FMT0_VALUE;
    #endif
  #elif defined(DACB_DATAREG_FMT0_VALUE)
  DACB_DATAREG_FMT0 = DACB_DATAREG_FMT0_VALUE;
  #endif

  /* Register 'DACB_DATAREG_FMT1' initialization */
  #if DACB_DATAREG_FMT1_MASK
    #if DACB_DATAREG_FMT1_MASK == 0xFFFF
  DACB_DATAREG_FMT1 = DACB_DATAREG_FMT1_VALUE;
    #elif DACB_DATAREG_FMT1_MASK == DACB_DATAREG_FMT1_VALUE
  DACB_DATAREG_FMT1 |= DACB_DATAREG_FMT1_VALUE;
    #elif DACB_DATAREG_FMT1_VALUE == 0
  DACB_DATAREG_FMT1 &= ~DACB_DATAREG_FMT1_MASK;
    #else
  DACB_DATAREG_FMT1 = (DACB_DATAREG_FMT1 & (~DACB_DATAREG_FMT1_MASK)) | DACB_DATAREG_FMT1_VALUE;
    #endif
  #elif defined(DACB_DATAREG_FMT1_VALUE)
  DACB_DATAREG_FMT1 = DACB_DATAREG_FMT1_VALUE;
  #endif

  /* Register 'DACB_MINVAL_FMT0' initialization */
  #if DACB_MINVAL_FMT0_MASK
    #if DACB_MINVAL_FMT0_MASK == 0xFFFF
  DACB_MINVAL_FMT0 = DACB_MINVAL_FMT0_VALUE;
    #elif DACB_MINVAL_FMT0_MASK == DACB_MINVAL_FMT0_VALUE
  DACB_MINVAL_FMT0 |= DACB_MINVAL_FMT0_VALUE;
    #elif DACB_MINVAL_FMT0_VALUE == 0
  DACB_MINVAL_FMT0 &= ~DACB_MINVAL_FMT0_MASK;
    #else
  DACB_MINVAL_FMT0 = (DACB_MINVAL_FMT0 & (~DACB_MINVAL_FMT0_MASK)) | DACB_MINVAL_FMT0_VALUE;
    #endif
  #elif defined(DACB_MINVAL_FMT0_VALUE)
  DACB_MINVAL_FMT0 = DACB_MINVAL_FMT0_VALUE;
  #endif

  /* Register 'DACB_MINVAL_FMT1' initialization */
  #if DACB_MINVAL_FMT1_MASK
    #if DACB_MINVAL_FMT1_MASK == 0xFFFF
  DACB_MINVAL_FMT1 = DACB_MINVAL_FMT1_VALUE;
    #elif DACB_MINVAL_FMT1_MASK == DACB_MINVAL_FMT1_VALUE
  DACB_MINVAL_FMT1 |= DACB_MINVAL_FMT1_VALUE;
    #elif DACB_MINVAL_FMT1_VALUE == 0
  DACB_MINVAL_FMT1 &= ~DACB_MINVAL_FMT1_MASK;
    #else
  DACB_MINVAL_FMT1 = (DACB_MINVAL_FMT1 & (~DACB_MINVAL_FMT1_MASK)) | DACB_MINVAL_FMT1_VALUE;
    #endif
  #elif defined(DACB_MINVAL_FMT1_VALUE)
  DACB_MINVAL_FMT1 = DACB_MINVAL_FMT1_VALUE;
  #endif

  /* Register 'DACB_MAXVAL_FMT0' initialization */
  #if DACB_MAXVAL_FMT0_MASK
    #if DACB_MAXVAL_FMT0_MASK == 0xFFFF
  DACB_MAXVAL_FMT0 = DACB_MAXVAL_FMT0_VALUE;
    #elif DACB_MAXVAL_FMT0_MASK == DACB_MAXVAL_FMT0_VALUE
  DACB_MAXVAL_FMT0 |= DACB_MAXVAL_FMT0_VALUE;
    #elif DACB_MAXVAL_FMT0_VALUE == 0
  DACB_MAXVAL_FMT0 &= ~DACB_MAXVAL_FMT0_MASK;
    #else
  DACB_MAXVAL_FMT0 = (DACB_MAXVAL_FMT0 & (~DACB_MAXVAL_FMT0_MASK)) | DACB_MAXVAL_FMT0_VALUE;
    #endif
  #elif defined(DACB_MAXVAL_FMT0_VALUE)
  DACB_MAXVAL_FMT0 = DACB_MAXVAL_FMT0_VALUE;
  #endif

  /* Register 'DACB_MAXVAL_FMT1' initialization */
  #if DACB_MAXVAL_FMT1_MASK
    #if DACB_MAXVAL_FMT1_MASK == 0xFFFF
  DACB_MAXVAL_FMT1 = DACB_MAXVAL_FMT1_VALUE;
    #elif DACB_MAXVAL_FMT1_MASK == DACB_MAXVAL_FMT1_VALUE
  DACB_MAXVAL_FMT1 |= DACB_MAXVAL_FMT1_VALUE;
    #elif DACB_MAXVAL_FMT1_VALUE == 0
  DACB_MAXVAL_FMT1 &= ~DACB_MAXVAL_FMT1_MASK;
    #else
  DACB_MAXVAL_FMT1 = (DACB_MAXVAL_FMT1 & (~DACB_MAXVAL_FMT1_MASK)) | DACB_MAXVAL_FMT1_VALUE;
    #endif
  #elif defined(DACB_MAXVAL_FMT1_VALUE)
  DACB_MAXVAL_FMT1 = DACB_MAXVAL_FMT1_VALUE;
  #endif

  /* Register 'DACB_STEPVAL_FMT0' initialization */
  #if DACB_STEPVAL_FMT0_MASK
    #if DACB_STEPVAL_FMT0_MASK == 0xFFFF
  DACB_STEPVAL_FMT0 = DACB_STEPVAL_FMT0_VALUE;
    #elif DACB_STEPVAL_FMT0_MASK == DACB_STEPVAL_FMT0_VALUE
  DACB_STEPVAL_FMT0 |= DACB_STEPVAL_FMT0_VALUE;
    #elif DACB_STEPVAL_FMT0_VALUE == 0
  DACB_STEPVAL_FMT0 &= ~DACB_STEPVAL_FMT0_MASK;
    #else
  DACB_STEPVAL_FMT0 = (DACB_STEPVAL_FMT0 & (~DACB_STEPVAL_FMT0_MASK)) | DACB_STEPVAL_FMT0_VALUE;
    #endif
  #elif defined(DACB_STEPVAL_FMT0_VALUE)
  DACB_STEPVAL_FMT0 = DACB_STEPVAL_FMT0_VALUE;
  #endif

  /* Register 'DACB_STEPVAL_FMT1' initialization */
  #if DACB_STEPVAL_FMT1_MASK
    #if DACB_STEPVAL_FMT1_MASK == 0xFFFF
  DACB_STEPVAL_FMT1 = DACB_STEPVAL_FMT1_VALUE;
    #elif DACB_STEPVAL_FMT1_MASK == DACB_STEPVAL_FMT1_VALUE
  DACB_STEPVAL_FMT1 |= DACB_STEPVAL_FMT1_VALUE;
    #elif DACB_STEPVAL_FMT1_VALUE == 0
  DACB_STEPVAL_FMT1 &= ~DACB_STEPVAL_FMT1_MASK;
    #else
  DACB_STEPVAL_FMT1 = (DACB_STEPVAL_FMT1 & (~DACB_STEPVAL_FMT1_MASK)) | DACB_STEPVAL_FMT1_VALUE;
    #endif
  #elif defined(DACB_STEPVAL_FMT1_VALUE)
  DACB_STEPVAL_FMT1 = DACB_STEPVAL_FMT1_VALUE;
  #endif

  /* Register 'DACB_CTRL0' initialization */
  #ifdef DACB_CTRL0_VALUE
  DACB_CTRL0 = DACB_CTRL0_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END DACB_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
