/** ###################################################################
 **     Filename    : DMA_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.2
 **     Abstract    :
 **          This file implements the DMA module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void DMA_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file DMA_Init.c
 * @version 1.2
 * @brief This file implements the DMA module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE DMA_Init. */

#include "DMA_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void DMA_Init(void) {

  /* Register 'DMA_DSR_BCR0' initialization */
  #if DMA_DSR_BCR0_MASK_1
    #if DMA_DSR_BCR0_MASK_1 == 0xFFFFFFFF
  DMA_DSR_BCR0 = DMA_DSR_BCR0_VALUE_1;
    #elif DMA_DSR_BCR0_MASK_1 == DMA_DSR_BCR0_VALUE_1
  DMA_DSR_BCR0 |= DMA_DSR_BCR0_VALUE_1;
    #elif DMA_DSR_BCR0_VALUE_1 == 0
  DMA_DSR_BCR0 &= ~DMA_DSR_BCR0_MASK_1;
    #else
  DMA_DSR_BCR0 = (DMA_DSR_BCR0 & (~DMA_DSR_BCR0_MASK_1)) | DMA_DSR_BCR0_VALUE_1;
    #endif
  #elif defined(DMA_DSR_BCR0_VALUE_1)
  DMA_DSR_BCR0 = DMA_DSR_BCR0_VALUE_1;
  #endif

  /* Register 'DMA_DSR_BCR1' initialization */
  #if DMA_DSR_BCR1_MASK_1
    #if DMA_DSR_BCR1_MASK_1 == 0xFFFFFFFF
  DMA_DSR_BCR1 = DMA_DSR_BCR1_VALUE_1;
    #elif DMA_DSR_BCR1_MASK_1 == DMA_DSR_BCR1_VALUE_1
  DMA_DSR_BCR1 |= DMA_DSR_BCR1_VALUE_1;
    #elif DMA_DSR_BCR1_VALUE_1 == 0
  DMA_DSR_BCR1 &= ~DMA_DSR_BCR1_MASK_1;
    #else
  DMA_DSR_BCR1 = (DMA_DSR_BCR1 & (~DMA_DSR_BCR1_MASK_1)) | DMA_DSR_BCR1_VALUE_1;
    #endif
  #elif defined(DMA_DSR_BCR1_VALUE_1)
  DMA_DSR_BCR1 = DMA_DSR_BCR1_VALUE_1;
  #endif

  /* Register 'DMA_DSR_BCR2' initialization */
  #if DMA_DSR_BCR2_MASK_1
    #if DMA_DSR_BCR2_MASK_1 == 0xFFFFFFFF
  DMA_DSR_BCR2 = DMA_DSR_BCR2_VALUE_1;
    #elif DMA_DSR_BCR2_MASK_1 == DMA_DSR_BCR2_VALUE_1
  DMA_DSR_BCR2 |= DMA_DSR_BCR2_VALUE_1;
    #elif DMA_DSR_BCR2_VALUE_1 == 0
  DMA_DSR_BCR2 &= ~DMA_DSR_BCR2_MASK_1;
    #else
  DMA_DSR_BCR2 = (DMA_DSR_BCR2 & (~DMA_DSR_BCR2_MASK_1)) | DMA_DSR_BCR2_VALUE_1;
    #endif
  #elif defined(DMA_DSR_BCR2_VALUE_1)
  DMA_DSR_BCR2 = DMA_DSR_BCR2_VALUE_1;
  #endif

  /* Register 'DMA_DSR_BCR3' initialization */
  #if DMA_DSR_BCR3_MASK_1
    #if DMA_DSR_BCR3_MASK_1 == 0xFFFFFFFF
  DMA_DSR_BCR3 = DMA_DSR_BCR3_VALUE_1;
    #elif DMA_DSR_BCR3_MASK_1 == DMA_DSR_BCR3_VALUE_1
  DMA_DSR_BCR3 |= DMA_DSR_BCR3_VALUE_1;
    #elif DMA_DSR_BCR3_VALUE_1 == 0
  DMA_DSR_BCR3 &= ~DMA_DSR_BCR3_MASK_1;
    #else
  DMA_DSR_BCR3 = (DMA_DSR_BCR3 & (~DMA_DSR_BCR3_MASK_1)) | DMA_DSR_BCR3_VALUE_1;
    #endif
  #elif defined(DMA_DSR_BCR3_VALUE_1)
  DMA_DSR_BCR3 = DMA_DSR_BCR3_VALUE_1;
  #endif

  /* Register 'DMA_REQC' initialization */
  #if DMA_REQC_MASK_1
    #if DMA_REQC_MASK_1 == 0xFFFFFFFF
  DMA_REQC = DMA_REQC_VALUE_1;
    #elif DMA_REQC_MASK_1 == DMA_REQC_VALUE_1
  DMA_REQC |= DMA_REQC_VALUE_1;
    #elif DMA_REQC_VALUE_1 == 0
  DMA_REQC &= ~DMA_REQC_MASK_1;
    #else
  DMA_REQC = (DMA_REQC & (~DMA_REQC_MASK_1)) | DMA_REQC_VALUE_1;
    #endif
  #elif defined(DMA_REQC_VALUE_1)
  DMA_REQC = DMA_REQC_VALUE_1;
  #endif

  /* Register 'DMA_REQC' initialization */
  #if DMA_REQC_MASK_2
    #if DMA_REQC_MASK_2 == 0xFFFFFFFF
  DMA_REQC = DMA_REQC_VALUE_2;
    #elif DMA_REQC_MASK_2 == DMA_REQC_VALUE_2
  DMA_REQC |= DMA_REQC_VALUE_2;
    #elif DMA_REQC_VALUE_2 == 0
  DMA_REQC &= ~DMA_REQC_MASK_2;
    #else
  DMA_REQC = (DMA_REQC & (~DMA_REQC_MASK_2)) | DMA_REQC_VALUE_2;
    #endif
  #elif defined(DMA_REQC_VALUE_2)
  DMA_REQC = DMA_REQC_VALUE_2;
  #endif
  #ifdef DMA_SAR0_VALUE
  DMA_SAR0 = DMA_SAR0_VALUE;
  #endif
  #ifdef DMA_SAR1_VALUE
  DMA_SAR1 = DMA_SAR1_VALUE;
  #endif
  #ifdef DMA_SAR2_VALUE
  DMA_SAR2 = DMA_SAR2_VALUE;
  #endif
  #ifdef DMA_SAR3_VALUE
  DMA_SAR3 = DMA_SAR3_VALUE;
  #endif
  #ifdef DMA_DAR0_VALUE
  DMA_DAR0 = DMA_DAR0_VALUE;
  #endif
  #ifdef DMA_DAR1_VALUE
  DMA_DAR1 = DMA_DAR1_VALUE;
  #endif
  #ifdef DMA_DAR2_VALUE
  DMA_DAR2 = DMA_DAR2_VALUE;
  #endif
  #ifdef DMA_DAR3_VALUE
  DMA_DAR3 = DMA_DAR3_VALUE;
  #endif

  /* Register 'DMA_DSR_BCR0' initialization */
  #if DMA_DSR_BCR0_MASK_2
    #if DMA_DSR_BCR0_MASK_2 == 0xFFFFFFFF
  DMA_DSR_BCR0 = DMA_DSR_BCR0_VALUE_2;
    #elif DMA_DSR_BCR0_MASK_2 == DMA_DSR_BCR0_VALUE_2
  DMA_DSR_BCR0 |= DMA_DSR_BCR0_VALUE_2;
    #elif DMA_DSR_BCR0_VALUE_2 == 0
  DMA_DSR_BCR0 &= ~DMA_DSR_BCR0_MASK_2;
    #else
  DMA_DSR_BCR0 = (DMA_DSR_BCR0 & (~DMA_DSR_BCR0_MASK_2)) | DMA_DSR_BCR0_VALUE_2;
    #endif
  #elif defined(DMA_DSR_BCR0_VALUE_2)
  DMA_DSR_BCR0 = DMA_DSR_BCR0_VALUE_2;
  #endif

  /* Register 'DMA_DSR_BCR1' initialization */
  #if DMA_DSR_BCR1_MASK_2
    #if DMA_DSR_BCR1_MASK_2 == 0xFFFFFFFF
  DMA_DSR_BCR1 = DMA_DSR_BCR1_VALUE_2;
    #elif DMA_DSR_BCR1_MASK_2 == DMA_DSR_BCR1_VALUE_2
  DMA_DSR_BCR1 |= DMA_DSR_BCR1_VALUE_2;
    #elif DMA_DSR_BCR1_VALUE_2 == 0
  DMA_DSR_BCR1 &= ~DMA_DSR_BCR1_MASK_2;
    #else
  DMA_DSR_BCR1 = (DMA_DSR_BCR1 & (~DMA_DSR_BCR1_MASK_2)) | DMA_DSR_BCR1_VALUE_2;
    #endif
  #elif defined(DMA_DSR_BCR1_VALUE_2)
  DMA_DSR_BCR1 = DMA_DSR_BCR1_VALUE_2;
  #endif

  /* Register 'DMA_DSR_BCR2' initialization */
  #if DMA_DSR_BCR2_MASK_2
    #if DMA_DSR_BCR2_MASK_2 == 0xFFFFFFFF
  DMA_DSR_BCR2 = DMA_DSR_BCR2_VALUE_2;
    #elif DMA_DSR_BCR2_MASK_2 == DMA_DSR_BCR2_VALUE_2
  DMA_DSR_BCR2 |= DMA_DSR_BCR2_VALUE_2;
    #elif DMA_DSR_BCR2_VALUE_2 == 0
  DMA_DSR_BCR2 &= ~DMA_DSR_BCR2_MASK_2;
    #else
  DMA_DSR_BCR2 = (DMA_DSR_BCR2 & (~DMA_DSR_BCR2_MASK_2)) | DMA_DSR_BCR2_VALUE_2;
    #endif
  #elif defined(DMA_DSR_BCR2_VALUE_2)
  DMA_DSR_BCR2 = DMA_DSR_BCR2_VALUE_2;
  #endif

  /* Register 'DMA_DSR_BCR3' initialization */
  #if DMA_DSR_BCR3_MASK_2
    #if DMA_DSR_BCR3_MASK_2 == 0xFFFFFFFF
  DMA_DSR_BCR3 = DMA_DSR_BCR3_VALUE_2;
    #elif DMA_DSR_BCR3_MASK_2 == DMA_DSR_BCR3_VALUE_2
  DMA_DSR_BCR3 |= DMA_DSR_BCR3_VALUE_2;
    #elif DMA_DSR_BCR3_VALUE_2 == 0
  DMA_DSR_BCR3 &= ~DMA_DSR_BCR3_MASK_2;
    #else
  DMA_DSR_BCR3 = (DMA_DSR_BCR3 & (~DMA_DSR_BCR3_MASK_2)) | DMA_DSR_BCR3_VALUE_2;
    #endif
  #elif defined(DMA_DSR_BCR3_VALUE_2)
  DMA_DSR_BCR3 = DMA_DSR_BCR3_VALUE_2;
  #endif

  /* Register 'DMA_DCR0' initialization */
  #if DMA_DCR0_MASK
    #if DMA_DCR0_MASK == 0xFFFFFFFF
  DMA_DCR0 = DMA_DCR0_VALUE;
    #elif DMA_DCR0_MASK == DMA_DCR0_VALUE
  DMA_DCR0 |= DMA_DCR0_VALUE;
    #elif DMA_DCR0_VALUE == 0
  DMA_DCR0 &= ~DMA_DCR0_MASK;
    #else
  DMA_DCR0 = (DMA_DCR0 & (~DMA_DCR0_MASK)) | DMA_DCR0_VALUE;
    #endif
  #elif defined(DMA_DCR0_VALUE)
  DMA_DCR0 = DMA_DCR0_VALUE;
  #endif

  /* Register 'DMA_DCR1' initialization */
  #if DMA_DCR1_MASK
    #if DMA_DCR1_MASK == 0xFFFFFFFF
  DMA_DCR1 = DMA_DCR1_VALUE;
    #elif DMA_DCR1_MASK == DMA_DCR1_VALUE
  DMA_DCR1 |= DMA_DCR1_VALUE;
    #elif DMA_DCR1_VALUE == 0
  DMA_DCR1 &= ~DMA_DCR1_MASK;
    #else
  DMA_DCR1 = (DMA_DCR1 & (~DMA_DCR1_MASK)) | DMA_DCR1_VALUE;
    #endif
  #elif defined(DMA_DCR1_VALUE)
  DMA_DCR1 = DMA_DCR1_VALUE;
  #endif

  /* Register 'DMA_DCR2' initialization */
  #if DMA_DCR2_MASK
    #if DMA_DCR2_MASK == 0xFFFFFFFF
  DMA_DCR2 = DMA_DCR2_VALUE;
    #elif DMA_DCR2_MASK == DMA_DCR2_VALUE
  DMA_DCR2 |= DMA_DCR2_VALUE;
    #elif DMA_DCR2_VALUE == 0
  DMA_DCR2 &= ~DMA_DCR2_MASK;
    #else
  DMA_DCR2 = (DMA_DCR2 & (~DMA_DCR2_MASK)) | DMA_DCR2_VALUE;
    #endif
  #elif defined(DMA_DCR2_VALUE)
  DMA_DCR2 = DMA_DCR2_VALUE;
  #endif

  /* Register 'DMA_DCR3' initialization */
  #if DMA_DCR3_MASK
    #if DMA_DCR3_MASK == 0xFFFFFFFF
  DMA_DCR3 = DMA_DCR3_VALUE;
    #elif DMA_DCR3_MASK == DMA_DCR3_VALUE
  DMA_DCR3 |= DMA_DCR3_VALUE;
    #elif DMA_DCR3_VALUE == 0
  DMA_DCR3 &= ~DMA_DCR3_MASK;
    #else
  DMA_DCR3 = (DMA_DCR3 & (~DMA_DCR3_MASK)) | DMA_DCR3_VALUE;
    #endif
  #elif defined(DMA_DCR3_VALUE)
  DMA_DCR3 = DMA_DCR3_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END DMA_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
