/** ###################################################################
 **     Filename    : EWM_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.1
 **     Abstract    :
 **          This file implements the EWM module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void EWM_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file EWM_Init.c
 * @version 1.1
 * @brief This file implements the EWM module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE EWM_Init. */

#include "EWM_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void EWM_Init(void) {

  /* Register 'EWM_CLKCTRL' initialization */
  #ifdef EWM_CLKCTRL_VALUE
  EWM_CLKCTRL = EWM_CLKCTRL_VALUE;
  #endif

  /* Register 'EWM_CLKPRESCALER' initialization */
  #ifdef EWM_CLKPRESCALER_VALUE
  EWM_CLKPRESCALER = EWM_CLKPRESCALER_VALUE;
  #endif

  /* Register 'EWM_CMPL' initialization */
  #ifdef EWM_CMPL_VALUE
  EWM_CMPL = EWM_CMPL_VALUE;
  #endif

  /* Register 'EWM_CMPH' initialization */
  #ifdef EWM_CMPH_VALUE
  EWM_CMPH = EWM_CMPH_VALUE;
  #endif

  /* Register 'EWM_CTRL' initialization */
  #ifdef EWM_CTRL_VALUE
  EWM_CTRL = EWM_CTRL_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END EWM_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
