/** ###################################################################
 **     Filename    : FMC_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the FMC module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void FMC_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file FMC_Init.c
 * @version 1.0
 * @brief This file implements the FMC module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE FMC_Init. */

#include "FMC_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void FMC_Init(void) {

  /* Register 'FMC_PFAPR' initialization */
  #if FMC_PFAPR_MASK
    #if FMC_PFAPR_MASK == 0xFFFFFFFF
  FMC_PFAPR = FMC_PFAPR_VALUE;
    #elif FMC_PFAPR_MASK == FMC_PFAPR_VALUE
  FMC_PFAPR |= FMC_PFAPR_VALUE;
    #elif FMC_PFAPR_VALUE == 0
  FMC_PFAPR &= ~FMC_PFAPR_MASK;
    #else
  FMC_PFAPR = (FMC_PFAPR & (~FMC_PFAPR_MASK)) | FMC_PFAPR_VALUE;
    #endif
  #elif defined(FMC_PFAPR_VALUE)
  FMC_PFAPR = FMC_PFAPR_VALUE;
  #endif

  /* Register 'FMC_PFB0CR' initialization */
  #if FMC_PFB0CR_MASK
    #if FMC_PFB0CR_MASK == 0xFFFFFFFF
  FMC_PFB0CR = FMC_PFB0CR_VALUE;
    #elif FMC_PFB0CR_MASK == FMC_PFB0CR_VALUE
  FMC_PFB0CR |= FMC_PFB0CR_VALUE;
    #elif FMC_PFB0CR_VALUE == 0
  FMC_PFB0CR &= ~FMC_PFB0CR_MASK;
    #else
  FMC_PFB0CR = (FMC_PFB0CR & (~FMC_PFB0CR_MASK)) | FMC_PFB0CR_VALUE;
    #endif
  #elif defined(FMC_PFB0CR_VALUE)
  FMC_PFB0CR = FMC_PFB0CR_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END FMC_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
