/** ###################################################################
 **     Filename    : PIT1_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the PIT1 module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void PIT1_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file PIT1_Init.c
 * @version 1.0
 * @brief This file implements the PIT1 module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE PIT1_Init. */

#include "PIT1_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void PIT1_Init(void) {

  PIT1_CTRL = 0;

  /* Register 'PIT1_MOD' initialization */
  #ifdef PIT1_MOD_VALUE
  PIT1_MOD = PIT1_MOD_VALUE;
  #endif

  /* Register 'PIT1_CTRL' initialization */
  #ifdef PIT1_CTRL_VALUE
  PIT1_CTRL = PIT1_CTRL_VALUE;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END PIT1_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
