/** ###################################################################
 **     Filename    : QSCI1_Init.c
 **     Processor   : MC56F82748VLH
 **     Version     : 1.0
 **     Abstract    :
 **          This file implements the QSCI1 module initialization
 **          according to the Peripheral Initialization settings, and
 **          defines interrupt service routines prototypes.
 **
 **     Contents    :
 **         Int   - void QSCI1_Init(void);
 **
 **     Copyright : 1997 - 2013 Freescale Semiconductor, Inc. All Rights Reserved.
 **     SOURCE DISTRIBUTION PERMISSIBLE as directed in End User License Agreement.
 **
 **     http      : www.freescale.com
 **     mail      : support@freescale.com
 ** ################################################################### */

/*!
 * @file QSCI1_Init.c
 * @version 1.0
 * @brief This file implements the QSCI1 module initialization according to the
 *        Peripheral Initialization settings, and defines interrupt service
 *        routines prototypes.
 */


/* MODULE QSCI1_Init. */

#include "QSCI1_Init.h"
#include "MC56F82748.h"
#include "Init_Config.h"

#ifdef __cplusplus
extern "C" {
#endif

void QSCI1_Init(void) {

  QSCI1_CTRL1 &= ~0xC;
  /* Clear flags */
  #ifdef QSCI1_CLEAR_FLAGS
  QSCI1_STAT |= 0x10;
  #endif

  /* Register 'QSCI1_RATE' initialization */
  #ifdef QSCI1_RATE_VALUE
  QSCI1_RATE = QSCI1_RATE_VALUE;
  #endif

  /* Register 'QSCI1_CTRL3' initialization */
  #if QSCI1_CTRL3_MASK_1
    #if QSCI1_CTRL3_MASK_1 == 0xFFFF
  QSCI1_CTRL3 = QSCI1_CTRL3_VALUE_1;
    #elif QSCI1_CTRL3_MASK_1 == QSCI1_CTRL3_VALUE_1
  QSCI1_CTRL3 |= QSCI1_CTRL3_VALUE_1;
    #elif QSCI1_CTRL3_VALUE_1 == 0
  QSCI1_CTRL3 &= ~QSCI1_CTRL3_MASK_1;
    #else
  QSCI1_CTRL3 = (QSCI1_CTRL3 & (~QSCI1_CTRL3_MASK_1)) | QSCI1_CTRL3_VALUE_1;
    #endif
  #elif defined(QSCI1_CTRL3_VALUE_1)
  QSCI1_CTRL3 = QSCI1_CTRL3_VALUE_1;
  #endif

  /* Register 'QSCI1_CTRL1' initialization */
  #if QSCI1_CTRL1_MASK_1
    #if QSCI1_CTRL1_MASK_1 == 0xFFFF
  QSCI1_CTRL1 = QSCI1_CTRL1_VALUE_1;
    #elif QSCI1_CTRL1_MASK_1 == QSCI1_CTRL1_VALUE_1
  QSCI1_CTRL1 |= QSCI1_CTRL1_VALUE_1;
    #elif QSCI1_CTRL1_VALUE_1 == 0
  QSCI1_CTRL1 &= ~QSCI1_CTRL1_MASK_1;
    #else
  QSCI1_CTRL1 = (QSCI1_CTRL1 & (~QSCI1_CTRL1_MASK_1)) | QSCI1_CTRL1_VALUE_1;
    #endif
  #elif defined(QSCI1_CTRL1_VALUE_1)
  QSCI1_CTRL1 = QSCI1_CTRL1_VALUE_1;
  #endif

  /* Register 'QSCI1_CTRL2' initialization */
  #if QSCI1_CTRL2_MASK
    #if QSCI1_CTRL2_MASK == 0xFFFF
  QSCI1_CTRL2 = QSCI1_CTRL2_VALUE;
    #elif QSCI1_CTRL2_MASK == QSCI1_CTRL2_VALUE
  QSCI1_CTRL2 |= QSCI1_CTRL2_VALUE;
    #elif QSCI1_CTRL2_VALUE == 0
  QSCI1_CTRL2 &= ~QSCI1_CTRL2_MASK;
    #else
  QSCI1_CTRL2 = (QSCI1_CTRL2 & (~QSCI1_CTRL2_MASK)) | QSCI1_CTRL2_VALUE;
    #endif
  #elif defined(QSCI1_CTRL2_VALUE)
  QSCI1_CTRL2 = QSCI1_CTRL2_VALUE;
  #endif

  /* Register 'QSCI1_CTRL3' initialization */
  #if QSCI1_CTRL3_MASK_2
    #if QSCI1_CTRL3_MASK_2 == 0xFFFF
  QSCI1_CTRL3 = QSCI1_CTRL3_VALUE_2;
    #elif QSCI1_CTRL3_MASK_2 == QSCI1_CTRL3_VALUE_2
  QSCI1_CTRL3 |= QSCI1_CTRL3_VALUE_2;
    #elif QSCI1_CTRL3_VALUE_2 == 0
  QSCI1_CTRL3 &= ~QSCI1_CTRL3_MASK_2;
    #else
  QSCI1_CTRL3 = (QSCI1_CTRL3 & (~QSCI1_CTRL3_MASK_2)) | QSCI1_CTRL3_VALUE_2;
    #endif
  #elif defined(QSCI1_CTRL3_VALUE_2)
  QSCI1_CTRL3 = QSCI1_CTRL3_VALUE_2;
  #endif

  /* Register 'QSCI1_CTRL1' initialization */
  #if QSCI1_CTRL1_MASK_2
    #if QSCI1_CTRL1_MASK_2 == 0xFFFF
  QSCI1_CTRL1 = QSCI1_CTRL1_VALUE_2;
    #elif QSCI1_CTRL1_MASK_2 == QSCI1_CTRL1_VALUE_2
  QSCI1_CTRL1 |= QSCI1_CTRL1_VALUE_2;
    #elif QSCI1_CTRL1_VALUE_2 == 0
  QSCI1_CTRL1 &= ~QSCI1_CTRL1_MASK_2;
    #else
  QSCI1_CTRL1 = (QSCI1_CTRL1 & (~QSCI1_CTRL1_MASK_2)) | QSCI1_CTRL1_VALUE_2;
    #endif
  #elif defined(QSCI1_CTRL1_VALUE_2)
  QSCI1_CTRL1 = QSCI1_CTRL1_VALUE_2;
  #endif
}

#ifdef __cplusplus
}
#endif

/* END QSCI1_Init. */

/** ###################################################################
 **
 **     This file is a part of Processor Expert static initialization
 **     library for the Freescale 56800 series of microcontrollers.
 **
 ** ################################################################### */
