/*****************************************************************************
*
* Motorola Inc.
* (c) Copyright 2001,2002 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name:         flash.h
*
* Description:       Prototype of flash descriptor and config file related functions
*
* Modules Included:  None
*
* Author:  William Jiang (William.Jiang@freescale.com)
*          Daniel Malik (daniel.malik@motorola.com)
*
****************************************************************************/

#define MAX_FLASH_UNITS		16			/* how many flash blocks do we have at maximum */
#define MAX_PAGE_COUNT		256			/* maximum flash size is 64k (or 128k interleaved) - (256 pages, 256 words each) */
#define MAX_LINE_LENGTH		300			/* max line length in input config file */
#define PMEM_ADDR_DEFAULT	0x8700		/* where to download code of algorithms by default */
#define DMEM_ADDR_DEFAULT	0			/* where to download data tables by default */
#define HFM_BASE_DEFAULT	0x00F400 //0xFFF400	/* where is the HFM unit by default */
#define HFMCLK_DEFAULT		0x28		/* default HFM clock prescaler (for 8MHz crystal) */
#define FLASH_BLOCK_SIZE	32768	/* size of one flash block, flash units composed from multiple blocks
									   need to be mass erased & blank checked per block */
#define OPT1_OFFSET			0x001B		/* Option Data 1 Register (OPT1) containing OSC trim value */
//#define OCCS_BASE_DEFAULT	0x00F130      // for 56f803x, it is 0xf130; for 56f01x, it is 0x00F0F0	/* Base address of OCCS */
#define OCCS_BASE_DEFAULT	0x00E2B0      // Ethan,	A.S 	PLL Control Register (OCCS_CTRL) /* Base address of OCCS */
#define OCTRL_OFFSET		0x0004		/* offset to OCTRL with TRIM value */
#define SIM_BASE_DEFAULT	0xF100
#define AS_SIM_CTRL			0xE400	//Ethan, A.S SIM Control Register
#define SIM_NVMOPT2H	0xE42C	//Ethan, Non-Volatile Memory Option Register 2 (High)
#define OCCS_OSCTL1 	0xE2B4	//Ethan, Oscillator Control Register 1 (OCCS_OSCTL1)
#define OCCS_OSCTL2 	0xE2B5	//Ethan, Oscillator Control Register 2 (OCCS_OSCTL2)
#define FTFA_FCNFG		0x1C781  //Ethan, Flash Configuration Register (FTFA_FCNFG)
#define FTFA_BASE_PTR       0xE3C0		//Ethan, /** Peripheral FTFA base pointer */

/* Ethan, Add for FTFA register control */
    /* Flash Status Register (FSTAT)*/
    #define FTFx_SSD_FSTAT_OFFSET               0x00000000
    #define FTFx_SSD_FSTAT_CCIF                 0x80
    #define FTFx_SSD_FSTAT_RDCOLERR             0x40
    #define FTFx_SSD_FSTAT_ACCERR               0x20
    #define FTFx_SSD_FSTAT_FPVIOL               0x10
    #define FTFx_SSD_FSTAT_MGSTAT0              0x01

    /* Flash configuration register (FCNFG)*/
    #define FTFx_SSD_FCNFG_OFFSET               0x00000001
    #define FTFx_SSD_FCNFG_CCIE                 0x80
    #define FTFx_SSD_FCNFG_RDCOLLIE             0x40
    #define FTFx_SSD_FCNFG_ERSAREQ              0x20
    #define FTFx_SSD_FCNFG_ERSSUSP              0x10
    #define FTFx_SSD_FCNFG_RAMRDY               0x02
    #define FTFx_SSD_FCNFG_EEERDY               0x01

    /* Flash security register (FSEC) */
    #define FTFx_SSD_FSEC_OFFSET                0x00000002
    #define FTFx_SSD_FSEC_KEYEN                 0xC0
    #define FTFx_SSD_FSEC_FSLACC                0x0C
    #define FTFx_SSD_FSEC_SEC                   0x03

    #define FLASH_NOT_SECURE                   0x01
    #define FLASH_SECURE_BACKDOOR_ENABLED      0x02
    #define FLASH_SECURE_BACKDOOR_DISABLED     0x04

    /* Flash Option Register (FOPT) */
    #define FTFx_SSD_FOPT_OFFSET                0x00000003
#if 0
    /* Flash common command object registers (FCCOB0-B) */
    #define FTFx_SSD_FCCOB0_OFFSET              0x00000007
    #define FTFx_SSD_FCCOB1_OFFSET              0x00000006
    #define FTFx_SSD_FCCOB2_OFFSET              0x00000005
    #define FTFx_SSD_FCCOB3_OFFSET              0x00000004
    #define FTFx_SSD_FCCOB4_OFFSET              0x0000000B
    #define FTFx_SSD_FCCOB5_OFFSET              0x0000000A
    #define FTFx_SSD_FCCOB6_OFFSET              0x00000009
    #define FTFx_SSD_FCCOB7_OFFSET              0x00000008
    #define FTFx_SSD_FCCOB8_OFFSET              0x0000000F
    #define FTFx_SSD_FCCOB9_OFFSET              0x0000000E
    #define FTFx_SSD_FCCOBA_OFFSET              0x0000000D
    #define FTFx_SSD_FCCOBB_OFFSET              0x0000000C
#else
    /* Flash common command object registers (FCCOB0-B) */ //This is address, not offset
    #define FTFx_SSD_FCCOB0_OFFSET              0xE3C3
    #define FTFx_SSD_FCCOB1_OFFSET              0xE3C3
    #define FTFx_SSD_FCCOB2_OFFSET              0xE3C2
    #define FTFx_SSD_FCCOB3_OFFSET              0xE3C2
    #define FTFx_SSD_FCCOB4_OFFSET              0xE3C5
    #define FTFx_SSD_FCCOB5_OFFSET              0xE3C5
    #define FTFx_SSD_FCCOB6_OFFSET              0xE3C4
    #define FTFx_SSD_FCCOB7_OFFSET              0xE3C4
    #define FTFx_SSD_FCCOB8_OFFSET              0xE3C7
    #define FTFx_SSD_FCCOB9_OFFSET              0xE3C7
    #define FTFx_SSD_FCCOBA_OFFSET              0xE3C6
    #define FTFx_SSD_FCCOBB_OFFSET              0xE3C6
#endif

    /* P-Flash protection registers (FPROT0-3) */
    #define FTFx_SSD_FPROT0_OFFSET              0xE3C9
    #define FTFx_SSD_FPROT1_OFFSET              0xE3C9
    #define FTFx_SSD_FPROT2_OFFSET              0xE3C8
    #define FTFx_SSD_FPROT3_OFFSET              0xE3C8

    /* D-Flash protection registers (FDPROT) */
    #define FTFx_SSD_FDPROT_OFFSET              0x00000017

    /* EERAM Protection Register (FEPROT)  */
    #define FTFx_SSD_FEPROT_OFFSET              0x00000016

    #define GETINDEX(i) ((((i)/4) << 3) + 3 - (i)) // (i/4)*8 + 3 - i

/*------------- Flash hardware algorithm operation commands -------------*/
#define FTFx_VERIFY_BLOCK               0x00
#define FTFx_VERIFY_SECTION             0x01
#define FTFx_PROGRAM_CHECK              0x02
#define FTFx_READ_RESOURCE              0x03
#define FTFx_PROGRAM_LONGWORD           0x06
#define FTFx_PROGRAM_PHRASE             0x07
#define FTFx_ERASE_BLOCK                0x08
#define FTFx_ERASE_SECTOR               0x09
#define FTFx_PROGRAM_SECTION            0x0B
#define FTFx_VERIFY_ALL_BLOCK           0x40
#define FTFx_READ_ONCE                  0x41
#define FTFx_PROGRAM_ONCE               0x43
#define FTFx_ERASE_ALL_BLOCK            0x44
#define FTFx_SECURITY_BY_PASS           0x45
#define FTFx_PFLASH_SWAP                0x46
#define FTFx_PROGRAM_PARTITION          0x80
#define FTFx_SET_EERAM                  0x81

/* _FTFx_DX_64_48_32_16K_0K_0K_1K_0K_H_*/
#define FTFA  /* this is FTFA module, so some commands are not available */

#define BYTE2WORD(x) ((x)>>1)
#define WORD2BYTE(x) ((x)<<1)

/* PFlash sector size */ 
#define FTFx_PSECTOR_SIZE       0x00000400      /* 1 KB size */
#define DEBLOCK_SIZE            0x00000000      /* 0 KB size */


/* Address offset and size of PFlash IFR and DFlash IFR */
#define PFLASH_IFR_OFFSET                 0x00000000
#define PFLASH_IFR_SIZE                   0x00000100
#define DFLASH_IFR_OFFSET                 0x00000000 
#define DFLASH_IFR_SIZE                   0x00000100 


#define FTFx_LONGWORD_SIZE                0x0004     /* 4 bytes */

/* Size for checking alignment of a section */
#define PERSSEC_ALIGN_SIZE      FTFx_LONGWORD_SIZE  /* check align of erase sector on PFlash function */
#define PGMCHK_ALIGN_SIZE       FTFx_LONGWORD_SIZE      /* check align of program check function */
#define PRD1SEC_ALIGN_SIZE      FTFx_LONGWORD_SIZE  /* check align of verify section on PFlash function */
#define RDRSRC_ALIGN_SIZE       FTFx_LONGWORD_SIZE      /* check align of read resource function */

#define RSRC_CODE_IDX			0x8			/* fccob index to store resource code */
#define RDRSRC_LAST_IDX			0x8			/* last index of fccob for read resource command */
#define RDRSRC_SIZE				0x4			/* size to be read out in read resource command */
#define PGMONCE_LAST_IDX		0x7  		/* last index of fccob for programonce command */


/* Just For 56F82748 {*/
#define BUFFER_SIZE_BYTE          0x100
#define PGM_SIZE_BYTE             0x4 /* programale size */

#define EE_ENABLE                 0x00
#define RAM_ENABLE                0xFF
#define DEBUGENABLE               0x00

#define PSECTOR_SIZE              0x400    /* 1 KB size */
#define DSECTOR_SIZE              0x00     /* 0 KB size */

/* FTFL module base */
#define FTFx_REG_BASE             0x1C780
#define PFLASH_BLOCK_BASE         0x00004000
#define DEFLASH_BLOCK_BASE        0xFFFFFFFF  
#define EERAM_BLOCK_BASE          0x14000000

#define PBLOCK_SIZE               0x00010000      /* 64 KB size */
#define EERAM_BLOCK_SIZE          0x00000000      /* 0 KB size */

#define PBLOCK_NUM                1 /* number of individual Pflash block */

/* destination to program security key back to flash location */
#define SECURITY_LOCATION         (0x206 +  PFLASH_BLOCK_BASE)   /* Word address */
#define SECURITY_SIZE             0x4
#define READRESOURCE_SIZE         0x40
#define BACKDOOR_KEY_LOCATION     (0x200 +  PFLASH_BLOCK_BASE)

#define PGMSEC_ALIGN              0x4
#define VRFSEC_ALIGN              0x4 
/* Just For 56F82748 }*/


typedef unsigned long UINT32;
typedef unsigned short UINT16;
typedef unsigned char UINT8;
typedef volatile unsigned char VUINT8;
#define READ8(address)                  ((UINT8)(*(VUINT8*)(address)))

/*-------------------- Callback function prototype ---------------------*/
typedef void (* PCALLBACK)(void);
//typedef BOOL (* PFLASH_SWAP_CALLBACK)(UINT8);
/*--------------------Null Callback function defination ----------------*/
#define NULL_CALLBACK                   ((PCALLBACK)0xFFFFFFFF)
#define NULL_SWAP_CALLBACK              ((PFLASH_SWAP_CALLBACK)0xFFFFFFFF)
/*---------------- Flash SSD Configuration Structure -------------------*/
typedef struct _ssd_config
{
    UINT32      ftfxRegBase;        /* FTFx control register base */
    UINT32      PFlashBlockBase;    /* base address of PFlash block */
    UINT32      PFlashBlockSize;    /* size of PFlash block */
    UINT32      DFlashBlockBase;    /* base address of DFlash block */
    UINT32      DFlashBlockSize;    /* size of DFlash block */
    UINT32      EERAMBlockBase;     /* base address of EERAM block */
    UINT32      EEEBlockSize;       /* size of EEE block */
//    BOOL        DebugEnable;        /* background debug mode enable bit */
    PCALLBACK   CallBack;           /* pointer to callback function */
} FLASH_SSD_CONFIG, *PFLASH_SSD_CONFIG;


typedef struct {
		unsigned long int	start;			/* beginning of the block in memory map */
		unsigned long int	end;			/* end of block in memory map */
		unsigned char		progmem;		/* 1-pflash, 0-dflash */
		unsigned char		bank;			/* register bank selection */
		unsigned char		bootmem;		/* boot mem */
		unsigned char		sectors;		/* number of sectors */
		unsigned int		pagesize;		/* size of flash page */
		unsigned char		interleaved;	/* 1=interleaved, 0=normal */
		unsigned char 		*page_erase_map; /* bit0: 0=not yet erased, 1=already erased */
											 /* bit1: 1=request to erase this page (set by S-rec processing routine), 0=preserve page */
		unsigned int		*data;			/* pointer to array where data are stored */
} flash_unit;

typedef struct {
	flash_unit flash_units[MAX_FLASH_UNITS];
	int flash_count;						/* number of flash units */
	unsigned long int flash_base;			/* base address of the Flash programming interface */
	unsigned char flash_clkdiv;				/* flash clock divisor */
	unsigned long int pram_addr;			/* address of program RAM memory region used for algorithm execution */
	unsigned long int dram_addr;			/* address of data RAM memory region used for algorithm data */
	unsigned long int sim_addr;				/* address of SIM for reset purposes */
	unsigned long int occs_addr;			/* occs base address */
	unsigned char page_erase;				/* 1: page erase, 0: mass erase */
} flash_constants;

/* Comments:

*/

int read_setup(char *path, flash_constants flash_param[]);
int flash_prepare(flash_constants *flash_param);
