/*****************************************************************************
*
* Motorola Inc.
* (c) Copyright 2001,2002 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name:         flash_over_jtag_v3.c
*
* Description:       Main application module
*
* Modules Included:
*	void usage(void);
*	void redirect_pport(char *text);
*	int handleoptions(int argc,char *argv[]);
*	int main (int argc,char *argv[]);
*	void sys_init(void);
*	void display_memory(mem_read_constants mem_read);
*
* Author: Daniel Malik (daniel.malik@freescale.com)
*		  William Jiang (william.jiang@freescale.com)
****************************************************************************/

/*
Changes:
		alpha 0.2	added -fastport option to make the tool work on brand new very fast computers with too fast printer port
					port access changed to zlio driver
		alpha 0.3	msvcrt.lib added to link to support long filenames and paths with spaces in them & prolonged max path length to MAX_PATH (system defined var)
		alpha 0.4	option -d was added (leave the part in debug mode on exit as opposed to resetting it)
		alpha 0.5	the zlioport driver was not closed anywhere, now it is being closed in the cleanup routine
		alpha 0.6	the zliopert.sys driver was installed from current working directory, now it is installed from where the exe file resides
		alpha 0.7&0.8	added test for zlportio.sys existence
		alpha 0.9	changed the pram download code to assign 0 to PC prior to download
		alpha 1.0	removed check for MA bit in OMR, this test does not work reliably on 8323
		alpha 1.1   added the check back, it was probably false alarm
		alpha 1.2   fixed minor bug in BCD2DEC conversion
		alpha 1.3   fixed overflow bug in S-rec write routine, changed character display order in view memory command, added jump to 0x20000 in case /RESET is not connected
		alpha 1.4   added sim_addr parameter into the flash cfg file to reset the part via SWRST bit in case /RESET is not connected
		alpha 1.5	changed jtag disconnect (added select_master_tap() call), changed the S-rec line processing routine (fixed extra byte bug)
		alpha 1.6	fixed S-record output (data separator was incorrect)
		alpha 2.0	ported to 56F801X family by William Jiang
		r3.0		to start application after programming, please define START_APPLICATION 
					at the beginning of the jtag.c

*/

#include <stdio.h>
#include <conio.h>
#ifdef WIN32
	#include <windows.h>
	#include "port_io.h"
#endif
#ifdef MSDOS
	#include <time.h>		/* use time instead of GetTickCount under DOS */
#endif


//------------------include into HiLo's system----------------
#include "hw_access.h" //kevin
#include "flash.h"
#include "flash_over_jtag.h"
#include "jtag.h"
#include "report.h"
//#include "srec.h"  //kevin
#include "exit_codes.h"
FLASH_SSD_CONFIG flashSSDConfig =
{
    FTFx_REG_BASE,          /* FTFx control register base */
    PFLASH_BLOCK_BASE,      /* base address of PFlash block */
    PBLOCK_SIZE,            /* size of PFlash block */
    DEFLASH_BLOCK_BASE,     /* base address of DFlash block */
    0,                      /* size of DFlash block */
    EERAM_BLOCK_BASE,       /* base address of EERAM block */
    0,                      /* size of EEE block */
//    DEBUGENABLE,            /* background debug mode enable bit */
    NULL_CALLBACK           /* pointer to callback function */
};
//------------------include into HiLo's system----------------

//#define scan_in_dr  jtag_instruction_exec(int instruction, int instr_len) {


extern void tog_led(UINT8);
extern unsigned int eonce_ftfa_execute_command(unsigned char *pCommandArray, unsigned char index);

extern unsigned int pport_data;
extern unsigned int jtag_port;		/* contains printer port port number*/



#if env_type==FSL_internal_use

operations operation=PROGRAM_FLASH;				/* what the tool is going to do: programming flash is default */
#ifdef WIN32
	#define FILENAME_MAX_LEN	MAX_PATH
#endif
#ifdef MSDOS
	#define FILENAME_MAX_LEN	256
#endif
void cleanup(void) {
	jtag_disconnect();
	#ifdef WIN32
		zliostop();
	#endif
	// for cancel srec.h
	//close_log();
}

void usage(void) {
	print("\r\nUsage:\r\nFlash_over_JTAG [<options>] \r\n\n");
	print("Options:\r\n");
	print("-E\tErase all flash and verify\r\n");
	print("-P\tProgram flash and verify\r\n");
	print("-R\tRead resource\r\n");
	print("-S\tGet security state\r\n");
	print("-X\tErase flash sector\r\n");
	print("-Y\tGet flash Protection\r\n");
	print("-Z\tSet flash Protection\r\n");
	print("-T\tToggle GPIO/LED\r\n");
	print("-H\tHelp\r\n");
	print("\n");
}
#endif




/* Main program */
int main (int argc,char *argv[]) {
	int i;
	unsigned long int j;
	int parcount;						/* number of arguments passed to the program */
	unsigned char unsecure_key[PGM_SIZE_BYTE] = {0xFE, 0xFF, 0xFF, 0xFF};
	unsigned char buffer[BUFFER_SIZE_BYTE];
	UINT32 FailAddr;
	UINT32 destination;         /* Address of the target location */
	UINT32 destination_word;         /* Address of the target location */
	UINT32 size;
	UINT32 retval;
	UINT8 DataArray[64];
	UINT8  securityStatus;      /* Return protection status */
	UINT16 number;
	UINT32  protectStatus1;       /* Store Protection Status Value of PFLASH */
	dsc target;
	UINT8 tempV;



#if env_type == FSL_internal_use
	#ifdef WIN32
		unsigned long int t1,t2,t3,t4,t5;	/* timing of each phase */
		t1=GetTickCount();
	#endif
	#ifdef MSDOS
		unsigned int t1,t5;					/* timing */
		t1=time(NULL);
	#endif


  #if port_IO_lib == ON
	#ifdef WIN32
		if (!zlioinit()) {
			print("Unable to access the I/O driver\r\n");
			return(SYSTEM_ERROR);
		}
		if (!zliosetiopm(1)) {
			print("Unable to gain direct access to I/O ports\r\n");
			return(SYSTEM_ERROR);
		}
	#endif
	i=atexit(cleanup);  /* install at exit function to clean up system */
	if (i!=0) {
		print("Error setting \"at exit\" function\r\n");
		return(SYSTEM_ERROR);
	}

	//if ((argc < 1) || (argc > 2)) {	/* number of parameters is incorrect */
	if (argc != 2) {	/* number of parameters is incorrect */
		print("Number of parameters incorrect or other error\r\n");
		usage();
		return(PARAM_ERROR);
	}
  #endif  //port_IO_lib
	print("DSP56F82748 Flash loader. Compiled on %s, %s.\r\n",__DATE__,__TIME__);
	print("version Alpha 1.0\r\n");
	print("(c) Freescale, 2014 by Ethan Cheng\r\n\n");
#endif
	/*--------------------------------------------------------------------------------
	 *   ↑System set up in win7 32bit with zlportiolibrary ↑
	 *--------------------------------------------------------------------------------*/

	i = jtag_init();
	j = init_target(&target);
#if env_type==FSL_internal_use
	printf("Chip ID: 0x%08lx\r\n",target.chipID);
	printf("Core ID: 0x%08lx status: 0x%02x \n" \
		       ,target.coreID,target.status);
	if (i) {
		print("Command Converter not connected or disabled!\r\n");
		return(JTAG_ERROR);
	}
	if (j) 
	    return(DSP_ERROR);
#endif


	switch (*argv[1]) {
	    case 'E':
		retval = FlashEraseAllBlock(); //if ok, return SUCCESS (0)
		    if(retval) printf("  FlashEraseAllBlock ERROR !!\n");
		    else       printf("  EraseAllBlock SUCCEED. \n");
		break;
	    case 'e':
		/**************************************************************************
		 *                          FlashEraseAllBlock()                          *
		 **************************************************************************/
		retval = FlashEraseAllBlock(); //if ok, return SUCCESS (0)
#if env_type == FSL_internal_use
		if(retval) printf("  FlashEraseAllBlock ERROR !!\n");
		else       printf("  EraseAllBlock SUCCEED. \n");
#endif


		retval = FlashVerifyAllBlock(0);
#if env_type == FSL_internal_use
		    if(retval) print("  FlashVerifyAllBlock ERROR !!\n");
		    else       print("  FlashVerifyAllBlock SUCCEED. \n");
#endif

		/* Program the Security Byte in the Flash Configuration Field to an unsecure value */
		DataArray[0]=0xfe; DataArray[1]=0xff; DataArray[2]=0xff; DataArray[3]=0xff;
		retval = FlashProgram_4bytes_LongWord(0x40c, DataArray);


#if env_type == FSL_internal_use
		if(retval) print("  Program the Security Byte failed !!\n");
		else       print("  Program the Security Byte SUCEED.\n");
#endif
		break;

	    case 'L':
	    case 'l':
		destination = 0x0; //start write from address=0
		tempV = 0x3;  
		retval = SUCCESS;

		do {
		    //write random number into flash
		    DataArray[0] = tempV;
		    DataArray[1] = tempV+1;
		    DataArray[2] = tempV+2;
		    DataArray[3] = tempV+3; 
		    //neglect section inside 0x400~0x40f
		    if ((destination>=0x400) & destination<=0x40f)  {
			destination += 4;
			continue; 
		    }
		    
		    retval = FlashProgram_4bytes_LongWord(destination, DataArray);
		    if (retval != SUCCESS) 
			print("program long failed at 0x%07lx  ", destination);
		    else //when SUCCESS
			print("program long(4 bytes)  at 0x%07lx  ", destination);


		    //--------------Verify Flash Content-----------------------------
		    retval = FlashCheck_4bytes_LongWord(destination, DataArray);

		    printf("check: ");
		    if (retval != SUCCESS) printf("--Fail--!\n");
		    else                   printf("OK\n");


		    tempV += 4;destination += 4;
		} while (destination <= 0xffff); //less than 64kB
		break;


	    case 'R':
	    case 'r':
		printf("-----Flash content-----");
		destination_word = 0x0;


		for (i = 0; i < (8*10); i++) { //print i words
		    number = Flash_Read_2Bytes(destination_word);
		    destination = destination_word<<1; //translate to byte address

		    if ( (destination&0xf) == 0x0)
			print("\n%07x: ", destination);
		    print("%04x ", number);

		    destination_word++;
		}

		print("\n----------------------------------------------", destination);
		destination_word = 0x8000>>1;
		for (i = 0; i < (8*10); i++) { //print i words
		    number = Flash_Read_2Bytes(destination_word);
		    destination = destination_word<<1; //translate to byte address

		    if ( (destination&0xf) == 0x0)
			print("\n%07x: ", destination);
		    print("%04x ", number);

		    destination_word++;
		}
		break;

	    case 'T':
	    case 't':
		tog_led(0);
		system("pause");

		tog_led(0xff);
		system("pause");

		tog_led(0);
		system("pause");

		tog_led(0xff);
		system("pause");
		break;	


	    default :
		usage();
		break;
	}
	return(SUCCESS);
}
