/*****************************************************************************
*
* Motorola Inc.
* (c) Copyright 2001,2002 Motorola, Inc.
* ALL RIGHTS RESERVED.  eonce_ftfa_execute_command
*
******************************************************************************
*
* File Name:         jtag.h
*
* Description:       Jtag and OnCE access prototypes and macros
*
* Modules Included:  None
*
* Author: Daniel Malik (daniel.malik@motorola.com)
*
****************************************************************************/
#define RETRY_DEBUG	10			/* how many JTAGIR polls should we try to wait for entry into DEBUG mode */
#define JTAG_PATH_LEN_MAX 256	
/* maximum JTAG DR & IR path lenght. High numbers do not matter, but the measure routine will take longer to execute */
#define BLANK_SKIP_TRESHOLD	20	/* restart the target code if more than X words == 0xffff */


struct DSCinternal {
    unsigned long int chipID;
    unsigned long int coreID;
    int data_pl;  /* lengths of JTAG paths */
    int instr_pl;
    int status;

    unsigned char Flash_Status;
};
typedef struct DSCinternal dsc;



/* prototypes */
UINT16 Flash_Read_2Bytes(UINT16 addr);
unsigned short REG_READ(unsigned short reg_addr);
unsigned int eonce_ftfa_execute_command(unsigned char *pCommandArray, unsigned char index);
unsigned int FlashProgram_4bytes_LongWord(unsigned int stAddr,unsigned char *data);
unsigned int FlashCheck_4bytes_LongWord(unsigned int stAddr,unsigned char *data);
unsigned int eonce_hfm_execute_command2(unsigned char command, \
				unsigned long int address, unsigned short word);
unsigned int eonce_hfm_execute_command(unsigned char command, flash_unit flash_desc,unsigned long int address);
int eonce_program_pll(flash_constants *flash_param);
				

char eonce_trim_relax_oscillator(void);
void jtag_data_write8_shift_dr(unsigned int data);
void jtag_data_write7(unsigned int data);

int jtag_init(void);	/* returns 0 on success, -1 if command converter not found */
int jtag_instruction_exec(int instruction, int instr_len);
unsigned long int jtag_data_shift(unsigned long int data, int bit_count);
int init_target (dsc *);
void jtag_disconnect(void);
void jtag_data_write8(unsigned int data);
void jtag_data_write16(unsigned int data);
unsigned int jtag_data_read16(void);
unsigned int jtag_data_read8(void);
void jtag_data_write_n_words(unsigned int n,unsigned int *data);
void set_port(unsigned int port);

void core_status(int status);
void select_core_tap(void);
void select_master_tap(void);
void jtag_security_lockout(flash_constants *flash_param);	/* recovery fro lockout */

/* calculates CRC16 based on the polynomial x^16+x^15+x^2+1 */
unsigned int calc_crc(unsigned int *start,unsigned int *end);
/* faster algorithm using table */
unsigned int calc_crc_tab(unsigned int *start,unsigned int *end);

/* programs HFM clock divisor */
char enoce_set_hfmdiv(flash_constants *flash_param);

/* checks security */
char enoce_hfm_security(flash_constants *flash_param);

/* reading & writing memory */
char eonce_mem_read(mem_read_constants *mem_read, flash_constants *flash_param);
char eonce_flash_erase(flash_constants *flash_param);
char eonce_program_flash(flash_constants *flash_param);
char eonce_verify_flash(flash_constants *flash_param);

/* routines for handling multiple devices in the JTAG chain */
int jtag_measure_paths(void);
int get_data_pl(void);		/* returns data path lenght measured by the measure routine */
int get_instr_pl(void);		/* returns instruction path lenght measured by the measure routine */
int get_data_pp(void);
//int get_instr_pp(void);
void set_data_pp(int length);
//void set_instr_pp(int length);

/* wait for DSP to come out of reset */
void set_DSP_wait(char wait);

/* adjusting for very fast printer ports */
void set_fast_port(char state);

/* exit mode - leave the part in debug mode or reset it */
void set_exit_mode(unsigned char mode);

/* Ethan, Add for 56F827XX { */
UINT32 FlashEraseAllBlock(void);
UINT32 FlashVerifyAllBlock(unsigned char marginLevel);
UINT32 FlashProgramLongword(PFLASH_SSD_CONFIG PSSDConfig, unsigned int destination, unsigned int size, unsigned char* pData);
UINT32 FlashProgramCheck(PFLASH_SSD_CONFIG PSSDConfig,  UINT32  destination, UINT32  size, \
								UINT8*  pExpectedData,UINT32* pFailAddr, UINT8   marginLevel);
UINT32 FlashReadResource(PFLASH_SSD_CONFIG PSSDConfig, UINT32 destination, UINT8* pDataArray, UINT8  resourceSelectCode);
UINT32 FlashGetSecurityState(PFLASH_SSD_CONFIG PSSDConfig, UINT8* securityState);
UINT32 FlashEraseSector(PFLASH_SSD_CONFIG PSSDConfig, UINT32 destination, UINT32 size);
UINT32 FlashVerifySection(PFLASH_SSD_CONFIG PSSDConfig, UINT32 destination, UINT16 Number, UINT8 marginLevel);
UINT32 PFlashGetProtection(PFLASH_SSD_CONFIG PSSDConfig, UINT32* protectStatus);
UINT32 PFlashSetProtection(PFLASH_SSD_CONFIG PSSDConfig, UINT32 protectStatus);

/* Ethan, Add for 56F827XX } */

/* Executes OnCE command */
#define eonce_instruction_exec(instruction, rw, go, ex) jtag_data_write8(instruction|(ex<<5)|(go<<6)|(rw<<7))

#define eonce_instruction_exec_shift_dr(instruction, rw, go, ex) jtag_data_write8_shift_dr(instruction|(ex<<5)|(go<<6)|(rw<<7))


/* Transfers multiple 16-bit words of data into the OnCE through DR-shift of Jtag */
void eonce_data_write(unsigned int words, unsigned int data0, unsigned int data1, unsigned int data2);

/* Reads 16-bit data from the OnCE through DR-shift of Jtag */
#define eonce_data_read() jtag_data_read16()

/* Executes DSP instruction */
/* transfers the whole opcode as one long stream */
#if 1
/* entry expected: run-test-idle state,
 * return state:   run-test-idle state 
*/
#define eonce_execute_instruction(words,opcode1,opcode2,opcode3) \
	JTAG_TMS_SET;									/* Go to Select-DR-Scan */	\
	JTAG_TCK_RESET;											\
	JTAG_TCK_SET;	\
	JTAG_TMS_RESET;								/* Go to Capture-DR */	\
	JTAG_TCK_RESET;			\
	WAIT_100_NS;			\
	WAIT_100_NS;			\
	JTAG_TCK_SET;			\
	JTAG_TCK_RESET;								/* Go to Shift-DR */	\
	JTAG_TCK_SET;								/* Now the Jtag is in the Shift-DR state */	\
	eonce_instruction_exec_shift_dr(0x04,0,1,0);\
	JTAG_TMS_SET;	\
	JTAG_TCK_RESET;	\
	JTAG_TCK_SET;	/* go to Exit1-DR */	\
	JTAG_TCK_RESET;	\
	JTAG_TCK_SET;	/* go to update_dr */	\
	JTAG_TMS_RESET;							\
	JTAG_TCK_RESET;							\
	JTAG_TCK_SET;	/* go to run-test-idle */		\
	eonce_data_write(words,opcode1,opcode2,opcode3)

#else
#define eonce_execute_instruction(words,opcode1,opcode2,opcode3) eonce_instruction_exec(0x04,0,1,0);\
										  						 eonce_data_write(words,opcode1,opcode2,opcode3)


#endif


/* Executes one word DSP instruction */
#define eonce_execute_instruction1(opcode) eonce_instruction_exec(0x04,0,1,0);\
										   jtag_data_write16(opcode)

/* Executes two word DSP instruction */
#define eonce_execute_instruction2(opcode1, opcode2) eonce_instruction_exec(0x04,0,0,0);\
													 jtag_data_write16(opcode1);\
													 eonce_instruction_exec(0x04,0,1,0);\
													 jtag_data_write16(opcode2)


/* Executes three word DSP instruction */
#define eonce_execute_instruction3(opcode1, opcode2, opcode3) eonce_instruction_exec(0x04,0,0,0);\
															  jtag_data_write16(opcode1);\
															  eonce_instruction_exec(0x04,0,0,0);\
															  jtag_data_write16(opcode2);\
															  eonce_instruction_exec(0x04,0,1,0);\
															  jtag_data_write16(opcode3)

/* reads OSR */
#define eonce_read_status_reg() (eonce_instruction_exec(0x03,1,0,0),\
								jtag_data_read16())

/* exits debug mode and starts executing code */
#define eonce_exit_debug_mode()	eonce_instruction_exec(0x01f,0,0,1)

/* reads Eonce base address */
#define eonce_read_base_addr() (eonce_instruction_exec(0x05,1,0,0),\
								jtag_data_read8())

/* downloads code to PRAM of the target */
char eonce_pgm_dload(const unsigned int *pgm, unsigned int pgm_size, flash_constants *flash_param);

/* downloads data to DRAM of the target */
char eonce_data_dload(const unsigned int *data, unsigned int data_size, flash_constants *flash_param);

/* enter debug mode by issuing debug request & enable once jtag commands */
#define eonce_enter_debug_mode()	(jtag_instruction_exec(0x7,4),\
									 jtag_instruction_exec(0x6,4))

/* reads EOnCE control reg */
#define eonce_ctrl_read() (eonce_instruction_exec(0x01,1,0,0),\
						   jtag_data_read8())

/* writes EOnCE control reg */
#define eonce_ctrl_write(data) eonce_instruction_exec(0x01,0,0,0);\
							   jtag_data_write8(data);

/* --------------- Real-time data exchange --------------- */

/* writes data into upper ORx register of the target */
#define eonce_tx_upper_data(data) eonce_instruction_exec(0x0d,0,0,0);\
								  jtag_data_write16(data)

/* reads data from upper OTx register of the target */
#define eonce_rx_upper_data() (eonce_instruction_exec(0x09,1,0,0),\
							   jtag_data_read16())	

/* reads data from upper OTx register of the target */
#define eonce_rx_lower_data() (eonce_instruction_exec(0x07,1,0,0),\
							   jtag_data_read16())

/* reads status of OTx & ORx registers */
#define eonce_data_status() (eonce_instruction_exec(0x06,1,0,0),\
							 jtag_data_read8())

/* --------------- Instructions --------------- */

#if 0
/* move.l #value,r0 */
#define eonce_move_long_to_r0(value)	eonce_execute_instruction(3,0xe418,value&0xffff,value>>16)
//#define eonce_move_long_to_r0(value)	once_execute_instruction3(0xe418,value&0xffff,value>>16)

/* move.l #value,n */
#define eonce_move_long_to_n(value)		eonce_execute_instruction(3,0xe41e,value&0xffff,value>>16)
//#define eonce_move_long_to_n(value)		eonce_execute_instruction3(0xe41e,value&0xffff,value>>16)

/* bfclr #value,x:(r0) */
#define eonce_bfclr_at_r0(value)		eonce_execute_instruction(2,0x8040,value,0)

/* bfclr #value,x:(r0+n) */
#define eonce_bfclr_at_r0_disp(value,disp)	eonce_execute_instruction(3,0x8044,disp,value)

/* bfset #value,x:(r0+n) */
#define eonce_bfset_at_r0_disp(value,disp)	eonce_execute_instruction(3,0x8244,disp,value)

/* move #value,y0 */
#define eonce_move_value_to_y0(value)	eonce_execute_instruction(2,0x8745,value,0)
//#define eonce_move_value_to_y0(value)	eonce_execute_instruction2(0x8745, value)

/* move y0,x:(r0)+ */
#define eonce_move_y0_at_r0_inc()		eonce_execute_instruction(1,0xd500,0,0)
//#define eonce_move_y0_at_r0_inc()		eonce_execute_instruction1(0xd500)

/* move #value,pc */
#define eonce_move_value_to_pc(value)	eonce_execute_instruction(3,0xE71E,value&0xffff,value>>16)

/* move pc,r4 */
#define eonce_move_pc_to_r4()			eonce_execute_instruction(1,0xE716,0,0)

/* move x:(r0),y0 */
#define eonce_move_at_r0_y0()			eonce_execute_instruction(1,0xF514,0,0)

/* move y0,x:(r0) */
#define eonce_move_y0_at_r0()			eonce_execute_instruction(1,0xd514,0,0)

/* move y1,x:(r0) */
#define eonce_move_y1_at_r0()			eonce_execute_instruction(1,0xd714,0,0)

/* move.l r4,y */
#define eonce_move_r4_to_y()			eonce_execute_instruction(1,0xe764,0,0)

/* move.l r3,y */
#define eonce_move_r3_to_y()			eonce_execute_instruction(1,0xe763,0,0)

/* move.l r2,y */
#define eonce_move_r2_to_y()			eonce_execute_instruction(1,0xe762,0,0)

/* move.l r0,y */
#define eonce_move_r0_to_y()			eonce_execute_instruction(1,0xe760,0,0)

/* bfclr <mask>,omr */
#define eonce_bfclr_omr(mask)			eonce_execute_instruction(2,0x815c,mask,0)

/* move.w omr,y0 */
#define eonce_move_omr_to_y0()			eonce_execute_instruction(1,0x851c,0,0)

/* move.w y0,p:(r0)+ */
#define eonce_move_y0_at_pr0_inc()		eonce_execute_instruction(1,0x8560,0,0)

/* move.w p:(r0)+,y0 */
#define eonce_move_at_pr0_inc_to_y0()	eonce_execute_instruction(1,0x8568,0,0)

/* move.w p:(r2)+,y0 */
#define eonce_move_at_pr2_inc_to_y0()	eonce_execute_instruction(1,0x856A,0,0)

/* move.l #value,r2 */
#define eonce_move_long_to_r2(value)	eonce_execute_instruction(3,0xe41A,value&0xffff,value>>16)

/* move y0,x:(r2) */
#define eonce_move_y0_at_r2()			eonce_execute_instruction(1,0xd516,0,0)

/* move.w y1,x:(r2) */
#define eonce_move_y1_at_r2()			eonce_execute_instruction(1,0xd716,0,0)

/* move.w x:(r2),Y0 */
#define eonce_move_at_r2_to_y0()		eonce_execute_instruction(1,0xF516,0,0)

/* move.w x:(R2+<disp>),Y0 */
#define eonce_move_at_r2_disp_to_y0(disp)		eonce_execute_instruction(2,0xF542,disp,0)

/* move.w #<value>,x:(R2) */
#define eonce_move_value_at_r2(value)			eonce_execute_instruction(2,0x8642,value,0)

/* move.w #<value>,x:(R2+<disp>) */
#define eonce_move_value_at_r2_disp(value,disp)	eonce_execute_instruction(3,0x8646,value,disp)

/* move.w #<value>,x:(R3+<disp>) */
#define eonce_move_value_at_r3_disp(value,disp)	eonce_execute_instruction(3,0x8647,value,disp)

/* move.l #value,r3 */
#define eonce_move_long_to_r3(value)	eonce_execute_instruction(3,0xE41B,value&0xffff,value>>16)

/* move.w y0,p:(r3)+ */
#define eonce_move_y0_at_pr3_inc()		eonce_execute_instruction(1,0x8563,0,0)

/* move.w y0,x:(r3) */
#define eonce_move_y0_at_r3()			eonce_execute_instruction(1,0xD503,0,0)

/* nop */
#define eonce_nop()						eonce_execute_instruction(1,0xe700,0,0)

/* move.w y0,x:(r0)+ */
#define eonce_move_y0_at_r0_inc()		eonce_execute_instruction(1,0xd500,0,0)

/* move.w x:(r0)+,y0 */
#define eonce_move_at_r0_inc_to_y0()	eonce_execute_instruction(1,0xf500,0,0)

#else	// ok by William Jiang

/* move.l #value,r0 */
#define eonce_move_long_to_r0(value)	eonce_execute_instruction3(0xe418,value&0xffff,value>>16)

/* move.l #value,n */
#define eonce_move_long_to_n(value)		eonce_execute_instruction3(0xe41e,value&0xffff,value>>16)

/* bfclr #value,x:(r0) */
#define eonce_bfclr_at_r0(value)		eonce_execute_instruction2(0x8040,value)

/* bfclr #value,x:(r0+n) */
#define eonce_bfclr_at_r0_disp(value,disp)	eonce_execute_instruction3(0x8044,disp,value)

/* bfset #value,x:(r0+n) */
#define eonce_bfset_at_r0_disp(value,disp)	eonce_execute_instruction3(0x8244,disp,value)

/* move #value,y0 */
#define eonce_move_value_to_y0(value)	eonce_execute_instruction2(0x8745,value)
//#define eonce_move_value_to_y0(value)	eonce_execute_instruction2(0x8745, value)

/* move y0,x:(r0)+ */
//#define eonce_move_y0_at_r0_inc()		eonce_execute_instruction(1,0xd500,0,0)
#define eonce_move_y0_at_r0_inc()		eonce_execute_instruction1(0xd500)

/* move #value,pc */
#define eonce_move_value_to_pc(value)	eonce_execute_instruction3(0xE71E,value&0xffff,value>>16)

/* move pc,r4 */
#define eonce_move_pc_to_r4()			eonce_execute_instruction1(0xE716)

/* move x:(r0),y0 */
#define eonce_move_at_r0_y0()			eonce_execute_instruction1(0xF514)

/* move y0,x:(r0) */
#define eonce_move_y0_at_r0()			eonce_execute_instruction1(0xd514)

/* move y1,x:(r0) */
#define eonce_move_y1_at_r0()			eonce_execute_instruction1(0xd714)

/* move.l r4,y */
#define eonce_move_r4_to_y()			eonce_execute_instruction1(0xe764)

/* move.l r3,y */
#define eonce_move_r3_to_y()			eonce_execute_instruction1(0xe763)

/* move.l r2,y */
#define eonce_move_r2_to_y()			eonce_execute_instruction1(0xe762)

/* move.l r0,y */
#define eonce_move_r0_to_y()			eonce_execute_instruction1(0xe760)

/* bfclr <mask>,omr */
#define eonce_bfclr_omr(mask)			eonce_execute_instruction2(0x815c,mask)

/* move.w omr,y0 */
#define eonce_move_omr_to_y0()			eonce_execute_instruction1(0x851c)

/* move.w y0,p:(r0)+ */
#define eonce_move_y0_at_pr0_inc()		eonce_execute_instruction1(0x8560)

/* move.w p:(r0)+,y0 */
#define eonce_move_at_pr0_inc_to_y0()	eonce_execute_instruction1(0x8568)

/* move.w p:(r2)+,y0 */
#define eonce_move_at_pr2_inc_to_y0()	eonce_execute_instruction1(0x856A)

/* move.l #value,r2 */
#define eonce_move_long_to_r2(value)	eonce_execute_instruction3(0xe41A,value&0xffff,value>>16)

/* move y0,x:(r2) */
#define eonce_move_y0_at_r2()			eonce_execute_instruction1(0xd516)

/* move.w y1,x:(r2) */
#define eonce_move_y1_at_r2()			eonce_execute_instruction1(0xd716)

/* move.w x:(r2),Y0 */
#define eonce_move_at_r2_to_y0()		eonce_execute_instruction1(0xF516)

/* move.w x:(R2+<disp>),Y0 */
#define eonce_move_at_r2_disp_to_y0(disp)		eonce_execute_instruction2(0xF542,disp)

/* move.w #<value>,x:(R2) */
#define eonce_move_value_at_r2(value)			eonce_execute_instruction2(0x8642,value)

/* move.w #<value>,x:(R2+<disp>) */
#define eonce_move_value_at_r2_disp(value,disp)	eonce_execute_instruction3(0x8646,value,disp)

/* move.w #<value>,x:(R3+<disp>) */
#define eonce_move_value_at_r3_disp(value,disp)	eonce_execute_instruction3(0x8647,value,disp)

/* move.l #value,r3 */
#define eonce_move_long_to_r3(value)	eonce_execute_instruction3(0xE41B,value&0xffff,value>>16)

/* move.w y0,p:(r3)+ */
#define eonce_move_y0_at_pr3_inc()		eonce_execute_instruction1(0x8563)

/* move.w y0,x:(r3) */
#define eonce_move_y0_at_r3()			eonce_execute_instruction1(0xD503)

/* nop */
#define eonce_nop()						eonce_execute_instruction1(0xe700)

/* move.w y0,x:(r0)+ */
#define eonce_move_y0_at_r0_inc()		eonce_execute_instruction1(0xd500)

/* move.w x:(r0)+,y0 */
#define eonce_move_at_r0_inc_to_y0()	eonce_execute_instruction1(0xf500)

/* move.w r4,x:(r0) */
#define eonce_move_r4_at_r0()		eonce_execute_instruction1(0xdc14)	

/*
P:00000216: E4FF                move.w   #-1,X0
P:00000217: 8A84                moveu.w  X0,M01
*/

#define eonce_set_linear_addr_mode()	eonce_execute_instruction1(0xe4ff); \
										eonce_execute_instruction1(0x8a84)									

#define eonce_move_value_to_y1(value)	eonce_execute_instruction2(0x8747,value)

#endif
