/*****************************************************************************
*
* Motorola Inc.
* (c) Copyright 2001,2002 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name:         flash_over_jtag.c
*
* Description:       Flash config file processing
*
* Modules Included:
*	int read_setup(char *path, flash_constants flash_param[])
*	int flash_prepare(flash_constants *flash_param)
*
* Author: Daniel Malik (daniel.malik@motorola.com)
*
****************************************************************************/
#include "hw_access.h"

#if env_type==FSL_internal_use

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#endif


#include "report.h"
#include "flash.h"


/* skip over current entry & nonprintable characters */
char *skip(char *ptr) {
	while ((*ptr)&&(*ptr!=' ')&&(*ptr!='\t')&&(*ptr!='=')) ptr++;	/* skip over printable chars (current entry) */
	while ((*ptr==' ')||(*ptr=='\t')||(*ptr=='\r')||(*ptr=='\n')||(*ptr=='=')) ptr++;	/* skip over delimiter */
	return(ptr);
}

/* reads number in decimal or hexadecimal format */
unsigned long int read_number(char *ptr) {
	unsigned long int result;
	unsigned char base=10;
	if (*ptr=='0' && *(ptr+1)=='x') {
		ptr+=2;
		base=16;
	}
	result=0;
	while (((*ptr>='0')&&(*ptr<='9'))||((*ptr>='A')&&(*ptr<='F'))||((*ptr>='a')&&(*ptr<='f'))) {
		result*=base;
		if ((*ptr>='0')&&(*ptr<='9')) result+=*ptr-'0'; else
			if ((*ptr>='A')&&(*ptr<='F')) result+=*ptr-'A'+10; else
				result+=*ptr-'a'+10;
		ptr++;
	}
	return(result);
}

/* Reads flash set-up from disk file */
/* returns number of flash blocks on success, -1 on file error */
int read_setup(char *path, flash_constants *flash_param) {
  #if env_type == FSL_internal_use
	int i;
	char *line_ptr;
	FILE *input;
	char line[MAX_LINE_LENGTH+1];
	input=fopen(path,"r");
	if (input==NULL) {
		print("Cannot open file \"%s\"\r\n",path);
		return(-1);
	}
	i=0;	/* count flash blocks in i */
	while ((i<MAX_FLASH_UNITS)&&(!feof(input))) {
		if (fgets(line,MAX_LINE_LENGTH,input)==NULL) break;
		if ((line[0]=='#')||(line[0]=='\r')||(line[0]=='\n')) continue;	/* comment */
		if (!strncmp(line,"set_hfmclkd",11)) {
			line_ptr=skip(line);
			flash_param->flash_clkdiv=read_number(line_ptr);
			continue;
		}
		else if (!strncmp(line,"set_hfm_base",12)) {
			line_ptr=skip(line);
			flash_param->flash_base=read_number(line_ptr);
			continue;
		}
		else if (!strncmp(line,"add_hfm_unit",12)) {
			line_ptr=skip(line);
			flash_param->flash_units[i].start=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].end=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].bank=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].sectors=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].pagesize=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].progmem=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].bootmem=read_number(line_ptr);
			line_ptr=skip(line_ptr);
			flash_param->flash_units[i].interleaved=read_number(line_ptr);
			i++;
			continue;
		}
		else if (!strncmp(line,"set_pram_base",13)) {
			line_ptr=skip(line);
			flash_param->pram_addr=read_number(line_ptr);
			continue;
		}
		else if (!strncmp(line,"set_dram_base",13)) {
			line_ptr=skip(line);
			flash_param->dram_addr=read_number(line_ptr);
			continue;
		}
		else if (!strncmp(line,"set_simr_addr",13)) {
			line_ptr=skip(line);
			flash_param->sim_addr=read_number(line_ptr);
			continue;
		}
		else if (!strncmp(line,"set_occs_addr",13)) {
			line_ptr=skip(line);
			flash_param->occs_addr=read_number(line_ptr);
			continue;
		}		
		print("Flash config file command ignored: %s\r",line);
	}
	print("%d flash units defined in the config file.\r\n",i);
	fclose(input);
	return(i);
  #endif
	;
}



/* prepares memory for flash blocks */
/* allocates memory and fills data buffers */
/* returns -1 on error */
int flash_prepare(flash_constants *flash_param) {
  #if env_type==FSL_internal_use
	long int i;
	unsigned long int addr;
	for (i=0;i<flash_param->flash_count;i++) {
		/* allocate mem */
		flash_param->flash_units[i].data=(unsigned int*)calloc(flash_param->flash_units[i].end-flash_param->flash_units[i].start+1,sizeof(unsigned int));
		if (flash_param->flash_units[i].data==NULL) {
			print("Memory allocation error for flash unit #%d\r\n",i);
			return(-1);
		}
		for(addr=0;addr<(flash_param->flash_units[i].end-flash_param->flash_units[i].start+1);addr++) *(flash_param->flash_units[i].data+addr)=65535;
		flash_param->flash_units[i].page_erase_map=(unsigned char*)calloc(MAX_PAGE_COUNT,sizeof(unsigned int));
		if (flash_param->flash_units[i].page_erase_map==NULL) {
			print("Memory allocation error for flash unit #%d\r\n",i);
			return(-2);
		}
		for(addr=0;addr<MAX_PAGE_COUNT;addr++) *(flash_param->flash_units[i].page_erase_map+addr)=0;
	}
	return(0);
  #endif
}
