/*****************************************************************************
*
* Motorola Inc.
* (c) Copyright 2001,2002 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name:         flash_over_jtag.h
*
* Description:       Main application prototypes
*
* Modules Included:  None
*
* Author: Daniel Malik (daniel.malik@motorola.com)
*
****************************************************************************/

typedef enum {
    PROGRAM_FLASH,
    READ_MEMORY,
    VIEW_MEMORY,
    LOCKOUT_RECOVERY,
    FTFA_FLASH_PRG,
} operations;

typedef struct {
	unsigned long int start;	/* beginning of the block */
	unsigned long int end;		/* end of the block */
	unsigned char pmem;			/* 1-pmem, 0-dmem */
	unsigned int *data;			/* pointer to array where data are to be stored */
} mem_read_constants;

void sys_init(void);
void cleanup(void);
void usage(void);
void redirect_pport(char *text);
int handleoptions(int argc,char *argv[]);
int main (int argc,char *argv[]);
void display_memory(mem_read_constants mem_read);

