/*****************************************************************************
*
* Motorola Inc.
* (c) Copyright 2001,2002 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name:         hw_access.h
*
* Description:       Macros for accessing the JTAG hardware
*                    
* Modules Included:  None 
*
* Author: William Jiang (William.Jiang@freescale.com)
*		Daniel Malik (daniel.malik@motorola.com)                    
* 
****************************************************************************/
#ifndef __HW_ACCESS_H
#define __HW_ACCESS_H

  
  #define FSL_internal_use 0
  #define woody_Programmer 1
  #define ON 1
  #define OFF 0

  #define print_inside_function 0  //kevin
  #define irdr_dump_by_printf 0
  
//*****************************************************
//-----------------------------------------------------
  #define env_type FSL_internal_use     //-------------
//-----------------------------------------------------
//*****************************************************


//*****************************************************
  #if env_type == woody_Programmer
//*****************************************************
    #define WAIT_100_NS			;

    #define JTAG_TCK_SET		;
    #define JTAG_TCK_RESET		;
  
    #define JTAG_TMS_SET		;
    #define JTAG_TMS_RESET		;
    
    #define JTAG_TDI_SET		;
    #define JTAG_TDI_RESET		;
    
    #define JTAG_TDO_VALUE              (0)
    #define JTAG_TDO_VALUE_SHIFTED_15 	(0)
    
  
  /* predefined by kevin */
    #define port_IO_lib  OFF
    #define JTAG_TDI_ASSIGN(i)	if (i&0x0001) JTAG_TDI_SET else JTAG_TDI_RESET
  
  
//*****************************************************
  #elif env_type == FSL_internal_use
//*****************************************************
    #define port_IO_lib  ON


    #include <conio.h>
    
    //#ifdef __LCC__		/* redefine hw access macros for the LCC compiler */
    #define	outp		_outp
    #define	inp			_inp
    //#endif
    
    // extern "C" unsigned int initdelay(void);
    // extern "C" void delay50ns(void);
    
    #define WAIT_100_NS			inp(jtag_port+1)
    //#define WAIT_100_NS			outp(jtag_port,pport_data)
    
    #define JTAG_PORT_DEFAULT	0x378
    #define JTAG_RESET_MASK		0x0001		/* D0, pin 2 */
    #define JTAG_TMS_MASK		0x0002		/* D1, pin 3 */
    #define JTAG_TCK_MASK		0x0004		/* D2, pin 4 */
    #define JTAG_TDI_MASK		0x0008		/* D3, pin 5 */
    #define JTAG_TRST_MASK		0x0010		/* D4, pin 6 */
    #define JTAG_ID_OUT_MASK	0x0040		/* D6, pin 8 */
    #define JTAG_VCC_MASK		0x0080		/* D7, pin 9 */
    
    #define JTAG_TDO_MASK		0x0080		/* BUSY, pin 11 */
    #define JTAG_TDO_SHIFT		7			/* number of bits to shift the data register to get the TDO value at bit 0 */
    
    #define JTAG_ID_IN_MASK		0x0008		/* ERROR, pin 15 */
    
    /**************************************************************************/
    
    #define JTAG_TCK_SET		pport_data|=JTAG_TCK_MASK;outp(jtag_port,pport_data);	\
    							{ int c;	\
    							for(c=0;c<8;c++) {WAIT_100_NS;};	\
    							}
    							
    #define JTAG_TCK_RESET		pport_data&=~JTAG_TCK_MASK;outp(jtag_port,pport_data);	\
    							{ int c;	\
    							for(c=0;c<8;c++) {WAIT_100_NS;};	\
    							}
    
    #define JTAG_TMS_SET		pport_data|=JTAG_TMS_MASK
    #define JTAG_TMS_RESET		pport_data&=~JTAG_TMS_MASK
    
    #define JTAG_TDI_SET		{pport_data|=JTAG_TDI_MASK;}
    #define JTAG_TDI_RESET		{pport_data&=~JTAG_TDI_MASK;}
    
    #define JTAG_TDI_ASSIGN(i)	if (i&0x0001) JTAG_TDI_SET else JTAG_TDI_RESET
    
    #define JTAG_TRST_SET		pport_data|=JTAG_TRST_MASK;outp(jtag_port,pport_data)
    #define JTAG_TRST_RESET		pport_data&=~JTAG_TRST_MASK;outp(jtag_port,pport_data)
    
    #define JTAG_RESET_SET		pport_data&=~JTAG_RESET_MASK;outp(jtag_port,pport_data)
    #define JTAG_RESET_RESET	pport_data|=JTAG_RESET_MASK;outp(jtag_port,pport_data)
    
    #define JTAG_ID_SET			pport_data|=JTAG_ID_OUT_MASK;outp(jtag_port,pport_data)
    #define JTAG_ID_RESET		pport_data&=~JTAG_ID_OUT_MASK;outp(jtag_port,pport_data)
    
    #define JTAG_VCC_SET		pport_data|=JTAG_VCC_MASK;outp(jtag_port,pport_data)
    #define JTAG_VCC_RESET		pport_data&=~JTAG_VCC_MASK;outp(jtag_port,pport_data)
    
    #define JTAG_TDO_VALUE				((~inp(jtag_port+1)&JTAG_TDO_MASK) >> JTAG_TDO_SHIFT)
    #define JTAG_TDO_VALUE_SHIFTED_15 	((~inp(jtag_port+1)&JTAG_TDO_MASK) << (15-JTAG_TDO_SHIFT))
    
    /*
    #define JTAG_TDO_VALUE				(outp(jtag_port,pport_data),((~inp(jtag_port+1)&JTAG_TDO_MASK) >> JTAG_TDO_SHIFT))
    #define JTAG_TDO_VALUE_SHIFTED_15 	(outp(jtag_port,pport_data),((~inp(jtag_port+1)&JTAG_TDO_MASK) << (15-JTAG_TDO_SHIFT)))
    */
    #define JTAG_ID_VALUE				(inp(jtag_port+1)&JTAG_ID_IN_MASK)

#endif



#endif
