/***************************************************************************************/
/* FILE NAME: DMA.c                           COPYRIGHT (c) Freescale 2015   */
/*                                                      All Rights Reserved  						 */
/* DESCRIPTION: DMA init program    for LSP/SDADC Example                 */
/*                                                                                             				 */
/***************************************************************************************/	
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE 			 */
/* ---   -----------    ----------    ---------------------                                     		     */
/* 1.0	  A Turner   			April 2015   Initial Public Release        		     */
/***************************************************************************************/

#include "../headers/typedefs.h"
#include "../headers/mpc5777m.h"
void eDMA_Init(void);


extern vint16_t SDADC1_RESULTS[];
extern vuint32_t SDADC1_SFR[];

		

/****************** Configure the eDMA - Loop of transfers ********************/
void eDMA_Init(void)
{


//Configure SDADC Mux  channels
 DMAMUX_2.CHCFG[0].R= 0x82;                         	//Configures the eDMA MUX 2 to set SDADC1 EOC on eDMA channel 16



// /* Configure CH16 */
 eDMA_0.TCD[16].SADDR.R = (vuint32_t)&SDADC_1.CDR.R +2;
 eDMA_0.TCD[16].ATTR.B.SMOD = 0;    
 eDMA_0.TCD[16].ATTR.B.SSIZE = 0x1; /* 16-bit */
 eDMA_0.TCD[16].ATTR.B.DMOD = 0;
 eDMA_0.TCD[16].ATTR.B.DSIZE = 0x1; /* 16-bit */
 eDMA_0.TCD[16].SOFF.R = 0;
 eDMA_0.TCD[16].NBYTES.MLNO.B.NBYTES = 16; /* 2x 8 bits = 16bits */
 eDMA_0.TCD[16].SLAST.R = 0;
 eDMA_0.TCD[16].DADDR.R = (vuint32_t)((uint16_t *)&SDADC1_RESULTS);
 eDMA_0.TCD[16].CITER.ELINKYES.R = 0;     
// eDMA_0.TCD[16].CITER.ELINKYES.B.LINKCH = 0;
 eDMA_0.TCD[16].CITER.ELINKYES.B.CITER = 50;
 eDMA_0.TCD[16].DOFF.R = 0x2;
 eDMA_0.TCD[16].DLASTSGA.R = -800;
 eDMA_0.TCD[16].BITER.ELINKYES.B.BITER = 50;
 eDMA_0.TCD[16].BITER.ELINKYES.B.ELINK = 0;
 eDMA_0.TCD[16].BITER.ELINKYES.B.LINKCH = 0;
 eDMA_0.TCD[16].CSR.B.BWC = 0;    
 eDMA_0.TCD[16].CSR.B.MAJORLINKCH = 0; /*No Linking */
 eDMA_0.TCD[16].CSR.B.MAJORELINK = 0; 
 eDMA_0.TCD[16].CSR.B.ESG = 0;
 eDMA_0.TCD[16].CSR.B.DREQ = 1;
 eDMA_0.TCD[16].CSR.B.INTHALF = 0;
 eDMA_0.TCD[16].CSR.B.INTMAJOR = 0;
 



  eDMA_0.ERQL.R |= 0x00010000;
 
}/* eDMA_Init */
