/***************************************************************************************/
/* FILE NAME: interrupt_routines.c         COPYRIGHT (c) Freescale 2015   */
/*                                                      All Rights Reserved  						 */
/* DESCRIPTION: Interrupt handles for LSP Filter example                         */
/*                                                                                             				 */
/***************************************************************************************/	
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE 			 */
/* ---   -----------    ----------    ---------------------                                     		     */
/* 1.0	  A Turner   			April 2015   Initial Public Release        		     */
/***************************************************************************************/

/*************************** Interrupt Service Routines *********************************/
#include "../../headers/project.h"


extern void RESET_KEY_SDADC1(void);
extern void SDADC_INIT(void);
extern void SDADC_ERR005749_SDADC1(void);
extern void SDADC_STIME (void);
extern uint8_t FIFO_DEPTH ;
extern vint16_t SDADC1_RESULTS_Int[400];
extern vint16_t SDADC1_RESULTS[400];
extern vint16_t SDADC1_ADJUSTED[400];
extern vuint16_t arraypnt;
extern vuint32_t OS_DONE ;



/* PIT0 CH2 */
 void IRQ_PIT0_CH2 (void){


 PIT_0.TIMER[2].TCTRL.B.TIE = 0x0;		/* Disable the interrupt from TIMER */  
 PIT_0.TIMER[2].TFLG.B.TIF = 0x1;		/* Clear the interrupt flag */  
 RESET_KEY_SDADC1();
 
}



/*IRQ for SDADC2 */

void IRQ_SDADC1 (void)
{
SDADC_1.SFR.B.DFORF = 1;                  //Clear the DFORF bit
SDADC_1.SFR.B.DFFF = 1;                   //Clear the DFFFF bit

while ( SDADC_1.SFR.B.DFEF != 1) 
{
if (arraypnt == 400)
{
arraypnt = 0;
}
SDADC1_RESULTS_Int[arraypnt] = SDADC_1.CDR.R;
arraypnt ++;
}

}
