/***************************************************************************************/
/* FILE NAME: main.c                           COPYRIGHT (c) Freescale 2015   */
/*                                                      All Rights Reserved  						 */
/* DESCRIPTION: Main C program    for LSP/SDADC Example                   */
/*                                                                                             				 */
/***************************************************************************************/	
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE 			 */
/* ---   -----------    ----------    ---------------------                                     		     */
/* 1.0	  A Turner   			April 2015   Initial Public Release        		     */
/***************************************************************************************/
#include "../headers/project.h"


extern void xcptn_xmpl(void);
extern void MC_MODE_INIT(void);
extern void SDADC_INIT(void);
extern void eDMA_Init(void);
extern void SDADC_STIME (void); 
extern void ui32_dsp_filter_run(void);
extern void SDADC_ERR005749_SDADC1(void);
extern void SDADC_STIME (void);
#pragma alignvar (16)
vint16_t SDADC1_RESULTS_Int[400];  /*Stores results of Software read ADC conversions*/
#pragma alignvar (16)
vint16_t SDADC1_RESULTS[400];      /*Stores results of DMA read ADC conversions*/
#pragma alignvar (16)
vuint16_t arraypnt = 0;

/************************************ Main ***********************************/
int main(){




MC_MODE_INIT();                      /* Setup the MCU clocks and modes SDADC clock is configured here */

 xcptn_xmpl ();                       /* Configure and Enable Interrupts */
 
 #ifdef DMA_Drain
 eDMA_Init ();					      /* Configure DMA channel 16 to transfer SDADC1 results to SDADC1_RESULTS array*/
 #endif
 
 SDADC_INIT();						   /* Generation of calibration offset and averaging is done in ISR for DMA 16 after first major DMA transfer completed */
								  
 SDADC_ERR005749_SDADC1();            /* Flushes FIFO as per Errata ERR005749 */
 SDADC_STIME ();                                 /* Set up PIT triggered ISR to trigger SDADC RESET after 100uS SDADC Startup time*/
 
 

 while (eDMA_0.TCD[16].CSR.B.DONE !=1)
 {
 }
 
 
 
  ui32_dsp_filter_run();  
  
  while (1){}

}
 




