/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS {

// Define Core 0 Flash Allocation
   FLASH_SIZE = 256K       
// Define Core 0 Flash Base Address 
   FLASH_BASE_ADDR = 0x01080000
        
// Define Core 0 SRAM Allocation  
   C0_SRAM_SIZE =  16K    
// Define Processor 0 SRAM Base Address
   C0_SRAM_BASE_ADDR = 0x4001C000   

// Define Core 0 Local Instruction SRAM Allocation  
   C0_LOCALIMEM_SIZE =  16K    
// Define Processor 0 Local Instruction SRAM Base Address
   C0_LOCALIMEM_BASE_ADDR = 0x50000000   
   
// Define Core 0 Local Data SRAM Allocation  
   C0_LOCALDMEM_SIZE =  64K    
// Define Processor 0 Local Data SRAM Base Address
   C0_LOCALDMEM_BASE_ADDR = 0x50800000  
	
// Stack located at end of SRAM     
// Define Stack Size
   STACK_SIZE = 1K        
       
}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/
MEMORY {
//    int_flash : org = FLASH_BASE_ADDR,     len = FLASH_SIZE
    int_sram  : org = C0_SRAM_BASE_ADDR,   len = C0_SRAM_SIZE-STACK_SIZE
//    stack_ram : org = (C0_SRAM_BASE_ADDR+C0_SRAM_SIZE-STACK_SIZE)  len = STACK_SIZE
     stack_ram : org = C0_LOCALDMEM_BASE_ADDR  len = STACK_SIZE
}

SECTIONS
{
    .init             : {} > int_sram			
    .text             : {} > .              /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */
                                            
    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */

    .xptn_vectors ALIGN(0x1000)   : {} > int_sram   /* Exception Vector Table (IVPR) - align 4K boundary */
    .IVOR4_Handler ALIGN(0x1000)  : {} > .          /* IVOR4 HW Vector Table (IVPR) - align 4K boundary */	
    .isrvectbl    ALIGN(0x1000)   : {} > .          /* ISR Vector Table - must be 4K aligned */
     
    .data             : {} > int_sram       /* Initialised Data                */
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/
    
    .heap   ALIGN(16) PAD(1K)         : {} > int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */

/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/

/*-------- LABELS USED IN CODE -------------------------------*/
        
/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);

__DATA_SIZE   = SIZEOF(.data);
__SDATA_SIZE  = SIZEOF(.sdata);

/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
//    __ghs_romstart  = MEMADDR(int_flash);
//    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
//    __ghs_rombootcodestart = MEMADDR(int_flash);
//    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}

