/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  EERAMSetProtection.c                                      *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"
/************************************************************************
*
*  Function Name    : EERAMSetProtection.c
*  Description      : This function retrieves current EERAM protection status. 
*  Arguments        : PFLASH_SSD_CONFIG, UINT8
*  Return Value     : UINT32
*
*************************************************************************/
#if (DEBLOCK_SIZE != 0)
UINT32 EERAMSetProtection(PFLASH_SSD_CONFIG pSSDConfig, UINT8 protectStatus)
{
    UINT32 ret;       /* return code variable */
    ret = FTFx_OK;
    /* Check if EERAM is set for EEE */
    if(0x0 == (REG_BIT_GET(pSSDConfig->ftfxRegBase + FTFx_SSD_FCNFG_OFFSET, FTFx_SSD_FCNFG_EEERDY)))
    {
        /* EERAM is not set for EEE */
        ret = FTFx_ERR_NOEEE;
        goto EXIT;
    }
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FEPROT_OFFSET, protectStatus);
    if ( protectStatus != REG_READ(pSSDConfig->ftfxRegBase + FTFx_SSD_FEPROT_OFFSET))
    {
        ret = FTFx_ERR_CHANGEPROT;
    }   
    
EXIT:
    /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}
#endif /* of DEBLOCK_SIZE */
/* end of file */
