/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashCheckSum.c                                           *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

/***********************************************************************
*
*  Function Name    : FlashCheckSum.c
*  Description      : This function is used to calculate checksum value 
*                     for the specified flash range.
*  Arguments        : PFLASH_SSD_CONFIG,UINT32 ,UINT32 ,UINT32*
*  Return Value     : UINT32
*
************************************************************************/
UINT32 FlashCheckSum(PFLASH_SSD_CONFIG pSSDConfig, \
                                UINT32 destination, \
                                UINT32 size, \
                                UINT32* PSum)
                              
{
    UINT32 counter;          /* Counter for callback operation */
    UINT32 data;             /* Data read from Flash address */
    UINT32 ret = FTFx_OK;       /* Return code variable */
    UINT32 endAddress;       /* P Flash end address */
    ret = FTFx_OK;
    counter = 0;
    /* convert to byte address */
    destination = WORD2BYTE(destination);
    /* calculating Flash end address */
    endAddress = destination + size;
    
    /* check for valid range of the target addresses */
    if ((destination < WORD2BYTE(pSSDConfig->PFlashBlockBase)) || 
        (endAddress > (WORD2BYTE(pSSDConfig->PFlashBlockBase) + pSSDConfig->PFlashBlockSize)))
    {
#if(DEBLOCK_SIZE)        
        if ((destination < WORD2BYTE(pSSDConfig->DFlashBlockBase)) || 
        (endAddress > (WORD2BYTE(pSSDConfig->DFlashBlockBase) + pSSDConfig->DFlashBlockSize)))
        {
#endif /* End of if(DEBLOCK_SIZE) */             
            /* return an error code FTFx_ERR_RANGE */
            ret = FTFx_ERR_RANGE;
            goto EXIT;
#if(DEBLOCK_SIZE)              
        }
        
#endif /* End of if(DEBLOCK_SIZE) */        
    }      
    *PSum = 0;
    /* doing sum operation */
    while(size > 0)
    {          
        data = READ8(destination);
        *PSum += (UINT32)data;
        destination += 1;
        size -= 1;

        /* Check if need to serve callback function */
        if((++counter) >= FLASH_CALLBACK_CS)
        {
            /* serve callback function if counter reaches limitation */
            if(NULL_CALLBACK != pSSDConfig->CallBack)
            {
                (pSSDConfig->CallBack)();
            }
            /* Reset counter */
            counter = 0;
        }
    }            

EXIT:
     if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}
/* end of file */
