/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashEraseResume.c                                        *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

/****************************************************************************
*
*  Function Name    : FlashEraseSector
*  Description      : Perform erase operation on Flash
*  Arguments        : PFLASH_SSD_CONFIG, UINT32, UINT32, pFLASHCOMMANDSEQUENCE
*  Return Value     : UINT32
*
*****************************************************************************/
UINT32 FlashEraseSector(PFLASH_SSD_CONFIG pSSDConfig, \
                                  UINT32 dest, \
                                  UINT32 size, \
                                  pFLASHCOMMANDSEQUENCE pFlashCommandSequence)                                                                    
{
 
    UINT32 ret;      /* return code variable */
    UINT32 sectorSize ,temp;        /* size of one sector */
    ret = FTFx_OK;
    /* convert to byte address */
    dest = WORD2BYTE(dest);
    
#if (DEBLOCK_SIZE)
    temp = WORD2BYTE(pSSDConfig->DFlashBlockBase);
    if((dest >= temp) && (dest < (temp + pSSDConfig->DFlashBlockSize)))
    {
        dest = dest - temp + 0x800000;
        sectorSize = FTFx_DSECTOR_SIZE;
    }  
    else             
#endif
    {
        temp = WORD2BYTE(pSSDConfig->PFlashBlockBase);
        if((dest >= temp) && (dest < (temp + pSSDConfig->PFlashBlockSize)))    
        {
            dest -= temp;
            sectorSize = FTFx_PSECTOR_SIZE;
        }else{
            ret = FTFx_ERR_ACCERR;
            goto EXIT;
        }
    }      
     
    /* check if the size is sector alignment or not */
    if(size & (sectorSize-1))
    {
        /* return an error code FTFx_ERR_SIZE */
        ret = FTFx_ERR_SIZE;
        goto EXIT;
    }
  
    while(size > 0)
    {
       /* clear RDCOLERR & ACCERR & FPVIOL flag in flash status register. Write 1 to clear*/
        REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET,FTFx_SSD_FSTAT_ERROR_BITS);   
        /* passing parameter to the command */
        REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB0_OFFSET, FTFx_ERASE_SECTOR);
        REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB1_OFFSET, GET_BIT_16_23(dest));
        REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB2_OFFSET, GET_BIT_8_15(dest));
        REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB3_OFFSET, GET_BIT_0_7(dest));

       /* calling flash command sequence function to execute the command */
        ret = pFlashCommandSequence(pSSDConfig);
            
        /* checking the success of command execution */
        if(FTFx_OK != ret)
        {
            break;
        }
        else
        {
            /* update size and destination address */
            size -= sectorSize;
            dest += sectorSize;
        }
    }

EXIT:
    /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}

/* end of file */

