/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashProgramOnce.c                                       *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"
/************************************************************************
*
*  Function Name    : FlashProgramOnce.c
*  Description      : Program a data record into a dedicated 64 bytes 
*                        (divided into 16 data records) region in
*                     the P-Flash IFR which stores critical information
*                     for the user
*  Arguments        : PFLASH_SSD_CONFIG, UINT8 , UINT8*, pFLASHCOMMANDSEQUENCE
*  Return Value     : UINT32
*
*************************************************************************/
UINT32 FlashProgramOnce(PFLASH_SSD_CONFIG pSSDConfig, \
                             UINT8 recordIndex,\
                             UINT8* pDataArray, \
                             pFLASHCOMMANDSEQUENCE pFlashCommandSequence)                                                                   
{

    UINT8 i;
    UINT32 ret;       /* return code variable */

   /* clear RDCOLERR & ACCERR & FPVIOL flag in flash status register. Write 1 to clear*/
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET,FTFx_SSD_FSTAT_ERROR_BITS);
    
    /* passing parameter to the command */
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB0_OFFSET, FTFx_PROGRAM_ONCE);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB1_OFFSET, recordIndex);

    for (i = 0; i < PGM_SIZE_BYTE; i ++)
    {
         REG_WRITE(pSSDConfig->ftfxRegBase + (i+8),pDataArray[i] );
    }    
    /* calling flash command sequence function to execute the command */
    ret = pFlashCommandSequence(pSSDConfig);     
   
    /* Enter Debug state if enabled */
     if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}

/* end of file */


