/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashProgramSection.c                                     *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"
/************************************************************************
*
*  Function Name    : FlashProgramSection.c
*  Description      : Program data into Flash
*  Arguments        : PFLASH_SSD_CONFIG, UINT32, UINT16,
*                     pFLASHCOMMANDSEQUENCE
*  Return Value     : UINT32
*
*************************************************************************/
#ifndef FTFA
UINT32 FlashProgramSection(PFLASH_SSD_CONFIG pSSDConfig, \
                                                UINT32 dest, \
                                                UINT16 Number, \
                                                pFLASHCOMMANDSEQUENCE pFlashCommandSequence)
{
 
    UINT32 ret;      /* return code variable */
    UINT32 temp;
    
    /* check RAMRDY bit of the flash configuration register */
    if(0 == (REG_BIT_GET(pSSDConfig->ftfxRegBase + FTFx_SSD_FCNFG_OFFSET, FTFx_SSD_FCNFG_RAMRDY)))
    {
        /* return an error code FTFx_ERR_RAMRDY */
        ret = FTFx_ERR_RAMRDY;
        goto EXIT;
    }
    /* convert to byte addr */
    dest = WORD2BYTE(dest);
#if (DEBLOCK_SIZE)
    temp = WORD2BYTE(pSSDConfig->DFlashBlockBase);
    if((dest >= temp) && (dest < (temp + pSSDConfig->DFlashBlockSize)))
    {
        dest = dest - temp + 0x800000;
    }  
    else     
#endif
    {
        temp = WORD2BYTE(pSSDConfig->PFlashBlockBase);
        if((dest >= temp) && (dest < (temp + pSSDConfig->PFlashBlockSize)))    
        {
            dest -= temp;
        }else{
            ret = FTFx_ERR_ACCERR;
            goto EXIT;
        }
    }
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET,FTFx_SSD_FSTAT_ERROR_BITS);   
    /* passing parameter to command */
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB0_OFFSET, FTFx_PROGRAM_SECTION);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB1_OFFSET, GET_BIT_16_23(dest));
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB2_OFFSET, GET_BIT_8_15(dest));
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB3_OFFSET, GET_BIT_0_7(dest));
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB4_OFFSET, GET_BIT_8_15(Number));
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB5_OFFSET, GET_BIT_0_7(Number));

    
   /* calling flash command sequence function to execute the command */
    ret = pFlashCommandSequence(pSSDConfig);        

EXIT:
    /* Enter Debug state if enabled */
    if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}
#endif /* of FTFA */
/* end of file */


