/*****************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010-2013, All Rights Reserved  *
******************************************************************************

******************************************************************************
*                                                                            *
*        Standard Software Flash Driver For FTFx                             *
*                                                                            *
* FILE NAME     :  FlashVerifyAllBlock.c                                     *
* DATE          :  Dec 25, 2013                                              *
*                                                                            *
* AUTHOR        :  FPT Team                                                  *
* E-mail        :  r56611@freescale.com                                      *
*                                                                            *
******************************************************************************/

/************************** CHANGES ******************************************
0.0.1       06.09.2010      FPT Team      Initial Version
1.0.0       12.25.2013      FPT Team      Optimize code 
******************************************************************************/
/* include the header files */
#include "SSD_FTFx.h"

/************************************************************************
*
*  Function Name    : FlashVerifyAllBlock.c
*  Description      : This function will check to see if the P-Flash 
*                     and D-Flash blocks as well as EERAM, E-Flash records
*                     and D-Flash IFR have been erased to the specifed read
*                     margin level, if applicable, and will release security
*                     if the readout passes.
*  Arguments        : PFLASH_SSD_CONFIG,UINT8, pFLASHCOMMANDSEQUENCE
*  Return Value     : UINT32
*
*************************************************************************/
UINT32 FlashVerifyAllBlock(PFLASH_SSD_CONFIG pSSDConfig, \
                                                UINT8 marginLevel, \
                                                pFLASHCOMMANDSEQUENCE pFlashCommandSequence)
{
    UINT32 ret;         /* return code variable */
   /* clear RDCOLERR & ACCERR & FPVIOL flag in flash status register. Write 1 to clear*/
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FSTAT_OFFSET,FTFx_SSD_FSTAT_ERROR_BITS);
    
    /* passing parameter to the command */
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB0_OFFSET, FTFx_VERIFY_ALL_BLOCK);
    REG_WRITE(pSSDConfig->ftfxRegBase + FTFx_SSD_FCCOB1_OFFSET, marginLevel);
    /* calling flash command sequence function to execute the command */
    ret = pFlashCommandSequence(pSSDConfig);
  
    
    /* Giving Control to BDM if enabled */
    /* Enter Debug state if enabled */
     if (TRUE == (pSSDConfig->DebugEnable))
    {
        ENTER_DEBUG_MODE;
    }

    return(ret);
}
/* end of file */