
#include "common.h"


#define D4DLCD_FLEX_BASE_ADDRESS  0x60010000
#define FLEX_BASE_ADDRESS         0x60000000
#define FLEX_ADRESS_MASK          0x00010000




void flex_bus_init(void)
{
    SIM_SCGC5 |= SIM_SCGC5_PORTA_MASK | SIM_SCGC5_PORTB_MASK | SIM_SCGC5_PORTC_MASK | SIM_SCGC5_PORTD_MASK | SIM_SCGC5_PORTE_MASK;

    PORTC_PCR0  = PORT_PCR_MUX(5); // AD14
    PORTC_PCR1  = PORT_PCR_MUX(5); // AD13
    PORTC_PCR2  = PORT_PCR_MUX(5); // AD12
    PORTC_PCR3  = PORT_PCR_MUX(5); // CLKOUT
    PORTC_PCR4  = PORT_PCR_MUX(5); // AD11
    PORTC_PCR5  = PORT_PCR_MUX(5); // AD10
    PORTC_PCR6  = PORT_PCR_MUX(5); // AD9
    PORTC_PCR7  = PORT_PCR_MUX(5); // AD8
    PORTC_PCR8  = PORT_PCR_MUX(5); // AD7
    PORTC_PCR9  = PORT_PCR_MUX(5); // AD6
    PORTC_PCR10 = PORT_PCR_MUX(5); // AD5
    PORTC_PCR11 = PORT_PCR_MUX(5); // RW
    PORTD_PCR1  = PORT_PCR_MUX(5); // CS0
    PORTD_PCR2  = PORT_PCR_MUX(5); // AD4
    PORTD_PCR3  = PORT_PCR_MUX(5); // AD3
    PORTD_PCR4  = PORT_PCR_MUX(5); // AD2
    PORTD_PCR5  = PORT_PCR_MUX(5); // AD1
    PORTD_PCR6  = PORT_PCR_MUX(5); // AD0
    PORTB_PCR17 = PORT_PCR_MUX(5); // AD16
    PORTB_PCR18 = PORT_PCR_MUX(5); // AD15

    SIM_CLKDIV1 &= ~SIM_CLKDIV1_OUTDIV3_MASK;
    SIM_CLKDIV1 |= SIM_CLKDIV1_OUTDIV3(0x1);
    SIM_SOPT2   |= SIM_SOPT2_FBSL(3);
    SIM_SCGC7   |= SIM_SCGC7_FLEXBUS_MASK;
    
  	FB_CSAR0 = FLEX_BASE_ADDRESS; // CS0 base address
  	FB_CSMR0 = FLEX_ADRESS_MASK | FB_CSMR_V_MASK; 
  	FB_CSCR0 = FB_CSCR_BLS_MASK | FB_CSCR_AA_MASK | (FB_CSCR_PS(2));
}
