
/*
 * File:		lcd_display_demo.c
 * Purpose:		Main process
 *
 */

#include "common.h"
#include "mcg.h"
//#include "sim.h"
//#include "pit.h"
#include "isr.h"
#include "smc.h"
#include "uart.h"
#include "sdram.h"
#include "flexbus.h"
#include "lcdc.h"
#include "pic.h"

/* Jumper settings on LCD story - TWR-LCD-REV A:
*************************************************
** Mode    | SW1-DIP1(PS2)   SW1-DIP2(PS0)      *
***********|*************************************            
** SPI     |  OFF     	       ON               *  
** FB 16b  |  ON              OFF               *
*************************************************/
// TWRK65 + My LCD SW1 configuration:
// POS:   1 2 3 4 5 6 7 8
// SPI:   0 1 1 1 C 1 1 0 // C = Chip Select settings
// FLEX:  1 0 1 1 1 1 1 0


#include "lcd.h"


void lcd_show(void);
/*
    This demo show pictures stored in SDRAM, 

    then the SDRAM and flexbus working together.
*/
int main (void)
{
    printf("Running the K65F/K66F(K60-2M) lcd_demo project.\n");
    
    lcd_show();
}


void lcd_show(void)
{
    // point to SDRAM
    short * p1 = (short*)0x70000000;
    short * p2 = (short*)0x70100000;
    int i;

    // initiate SDRAM, flex bus and LCD
    sdramc_init(120*1000);
    flex_bus_init();
    lcdc_init();

    // load image from on-chip flash to SDRAM
    for(i=0; i<320*240; i++)
    {
        p1[i] = pic1[i];
        p2[i] = pic2[i];
    }

    // show image from SDRAM to LCD which is connected by flex bus
    while(1)
    {
        lcdc_fill_window_pic(0,0,319, 239, (unsigned short *)p1);
        for(i=0; i<1000*1000*10; i++);
        lcdc_fill_window_pic(0,0,319, 239, (unsigned short *)p2);
        for(i=0; i<1000*1000*10; i++);
    }
}

/********************************************************************/
