

#include "common.h"
#include "flexbus.h"

#define LCDC_ADRESS_CMD    0x60000000
#define LCDC_ADRESS_DATA   0x60010000

#define LCDC_SCREEN_PIXEL_X 320
#define LCDC_SCREEN_PIXEL_Y 240

static void lcdc_send_data(unsigned short value)
{
    *((unsigned short*)LCDC_ADRESS_DATA) = value;
}
static void lcdc_send_cmd(unsigned short cmd)
{
    *((unsigned short*)LCDC_ADRESS_CMD) = cmd;
}

const unsigned short init_data[] = 
{
    0x0000,  0x0001,

    0x0003,  0xAEAC, 0x000C,  0x0007, 0x000D,  0x000F, 0x000E,  0x2900, 0x001E,  0x00B3,

    0x0001,  0x2B3F, 0x0002,  0x0600, 0x0010,  0x0000, 0x0011,  0x60B0,

    0x0005,  0x0000, 0x0006,  0x0000, 0x0016,  0xEF1C, 0x0017,  0x0003, 0x0007,  0x0233,
    0x000B,  0x5312, 0x000F,  0x0000,

    0x0041,  0x0000, 0x0042,  0x0000, 0x0048,  0x0000, 0x0049,  0x013F, 0x0044,  0xEF00, 
    0x0045,  0x0000, 0x0046,  0x013F, 0x004A,  0x0000, 0x004B,  0x0000,

    0x0030,  0x0707, 0x0031,  0x0704, 0x0032,  0x0204, 0x0033,  0x0201, 0x0034,  0x0203,
    0x0035,  0x0204, 0x0036,  0x0204, 0x0037,  0x0502, 0x003A,  0x0302, 0x003B,  0x0500,
    0x0023 , 0x0000, 0x0024 , 0x0000
};
static void lcdc_fill_initial_data(const unsigned short data[], unsigned int count)
{
    int i;

    for (i=0; i<count; i+=2)
    {
        lcdc_send_cmd((unsigned short)data[i]);
        lcdc_send_data((unsigned short)data[i+1]);       
    }
}

static void lcdc_delay(int n)
{
    int i;
    for(i=0; i<n*10; i++);
}

void lcdc_set_window(unsigned short x1, unsigned short y1, unsigned short x2, unsigned short y2)
{
    unsigned short x1_x2;
    unsigned short Addr1, Addr2;

    // landscape

    //*
    Addr1 = (unsigned short)(LCDC_SCREEN_PIXEL_Y - 1 - y1);
    Addr2 = x1;
    x1_x2 = (unsigned short)((Addr1<<8) + (LCDC_SCREEN_PIXEL_Y - 1 - y2));    // pack X-Values into one word
    y1 = x1;
    y2 = x2;
    // */

    // landscape 180
    /*
    Addr1 = y1; 
    Addr2 = (unsigned short)(D4D_SCREEN_SIZE_LONGER_SIDE - 1 - x1);    // pack X-Values into one word
    x1_x2 = (unsigned short)((y2<<8) + y1);
    y1 = (unsigned short)(D4D_SCREEN_SIZE_LONGER_SIDE - 1 - x2);
    y2 = Addr2;
    */
    
    // set Window
    lcdc_send_cmd(0x0044); 
    lcdc_send_data((unsigned short)x1_x2);

    lcdc_send_cmd(0x0045);
    lcdc_send_data((unsigned short)y1);

    lcdc_send_cmd(0x0046);
    lcdc_send_data((unsigned short)y2);

    // set Start Address counter
    lcdc_send_cmd(0x004e);
    lcdc_send_data((unsigned short)Addr1);

    lcdc_send_cmd(0x004f);
    lcdc_send_data((unsigned short)Addr2);

    lcdc_send_cmd(0x0022);
}

void lcdc_set_orientation(void)
{
    lcdc_send_cmd(0x0011);
    lcdc_send_data(0x60a8); // landscape
    //lcdc_send_data(0x6098); // landscape 180
}

void lcdc_init(void)
{
    lcdc_fill_initial_data(&init_data[0], 2);    lcdc_delay(15); 
    lcdc_fill_initial_data(&init_data[2], 10);   lcdc_delay(15); 
    lcdc_fill_initial_data(&init_data[12], 8);   lcdc_delay(150);
    lcdc_fill_initial_data(&init_data[20], 14);  lcdc_delay(20);
    lcdc_fill_initial_data(&init_data[34], 18);  lcdc_delay(20);    
    lcdc_fill_initial_data(&init_data[52], 24);  lcdc_delay(31);

    lcdc_set_orientation();
    //lcdc_set_window(0, 0, 1, 1);
}

void lcdc_fill_window( unsigned short x1, 
                       unsigned short y1, 
                       unsigned short x2, 
                       unsigned short y2, 
                       unsigned short color )
{
    int i, i_max; int j;

    lcdc_set_window(x1, y1, x2, y2);
    i_max = (x2-x1+1) * (y2-y1+1);

    for (i=0; i < i_max ; ++i)
    { lcdc_send_data(color); for(j=0;j<1000*50;j++); }
}



void lcdc_fill_window_pic( unsigned short x1, 
                           unsigned short y1, 
                           unsigned short x2, 
                           unsigned short y2, 
                           unsigned short *data )
{
    int i, i_max;

    lcdc_set_window(x1, y1, x2, y2);
    i_max = (x2-x1+1) * (y2-y1+1);

    for (i=0; i < i_max; i++)
    { 
        lcdc_send_data(data[i]);
    }
}






