

#include "common.h"
#include "sysinit.h"

#define  BURSTLENGTH     0
#define  BURSTTYPE       0
#define  CASLATENCY      1
#define  OPMODE          0
#define  WRITEBURSTMODE  0


#define  ADDR9     9
#define  ADDR10    10
#define  ADDR11    11
#define  ADDR12    12
#define  ADDR13    13
#define  ADDR14    14
#define  ADDR15    15
#define  ADDR16    16
#define  ADDR17    17
#define  ADDR18    18
#define  ADDR19    19
#define  ADDR20    20
#define  ADDR21    21
#define  ADDR22    22
#define  ADDR23    23

#define  SDRAM_A0     ADDR15
#define  SDRAM_A1     ADDR14
#define  SDRAM_A2     ADDR13
#define  SDRAM_A3     ADDR12
#define  SDRAM_A4     ADDR11
#define  SDRAM_A5     ADDR10
#define  SDRAM_A6     ADDR9
#define  SDRAM_A7     ADDR17
#define  SDRAM_A8     ADDR18
#define  SDRAM_A9     ADDR19
#define  SDRAM_A10    ADDR20
#define  SDRAM_A11    ADDR21
#define  SDRAM_A12    ADDR22
#define  SDRAM_A13    ADDR23

void sdramc_write8(int address, int8_t data){
  *(int8_t *)(address) = data;
}
void sdramc_gpio_init(void)
{
    //For K65, K66 don't have SDRAMC_D11-D0
    //Configure SDRAM Data  GPIOs
    //1. set pin mux as SDRAM_xx function
    //2. high drive strength set

    // BS3
    PORTB_PCR20 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[31] 
    PORTB_PCR21 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[30] 
    PORTB_PCR22 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[29]
    PORTB_PCR23 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[28] 
    PORTC_PCR12 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[27] 
    PORTC_PCR13 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[26] 
    PORTC_PCR14 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[25] 
    PORTC_PCR15 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[24]

    // BS2
    PORTB_PCR6  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[23] 
    PORTB_PCR7  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[22] 
    PORTB_PCR8  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[21] 
    PORTB_PCR9  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[20] 
    PORTB_PCR10 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[19] 
    PORTB_PCR11 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[18]
    PORTB_PCR16 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[17]
    PORTB_PCR17 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[16]

    //BS1
    PORTA_PCR24 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[15]
    PORTA_PCR25 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[14]
    PORTA_PCR26 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[13]
    PORTA_PCR27 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[12]
    PORTA_PCR30 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[11]
    PORTA_PCR31 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[10]
    PORTB_PCR12 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[9]
    PORTB_PCR13 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[8]

    //BS0
    PORTB_PCR14 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[7]
    PORTB_PCR15 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[6]
    PORTC_PCR24 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[5]
    PORTC_PCR25 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[4]
    PORTC_PCR26 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[3]
    PORTC_PCR27 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[2]
    PORTC_PCR28 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[1]
    PORTC_PCR29 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_D[0]

    //Configure SDRAM Address  GPIOs
    //1. set pin mux as SDRAM_xx function
    //2. high drive strength set
    PORTD_PCR5 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[9]
    PORTD_PCR4 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[10]
    PORTD_PCR3 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[11]
    PORTD_PCR2 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[12]
    PORTC_PCR10 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[13]
    PORTC_PCR9 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[14]
    PORTC_PCR8 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[15]
    PORTC_PCR7 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[16]
    PORTC_PCR6 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[17]
    PORTC_PCR5 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[18]
    PORTC_PCR4 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[19]
    PORTC_PCR2 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[20]
    PORTC_PCR1 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[21]
    PORTC_PCR0 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[22]
    PORTB_PCR18= PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;           //  SDRAM_A[23]

    //Config control signals
    // Enable the SDRAMC_CLKOUT function on PTC3 (alt5 function) 
    SIM_SOPT2 &= ~SIM_SOPT2_CLKOUTSEL_MASK; // clear clkoout field
    SIM_SOPT2 |= SIM_SOPT2_CLKOUTSEL(0);    // select Flexbus clock  
    PORTC_PCR3  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_CLK

    PORTD_PCR7  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_CKE
    PORTB_PCR0  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_CAS_B  
    PORTB_PCR1  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_RAS_B
    PORTB_PCR3  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_CS0_B
    PORTB_PCR4  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_CS1_B
    PORTB_PCR2  = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_WE
    PORTC_PCR17 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_DQM3
    PORTC_PCR16 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_DQM2
    PORTC_PCR18 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_DQM1
    PORTC_PCR19 = PORT_PCR_MUX(5)|PORT_PCR_DSE_MASK;          // SDRAM_DQM0
} 
void delay_time_us(int core_clk_freq_mhz, int delay_time)
{
  //cal the time to delay in us unit
  delay_time = (core_clk_freq_mhz * delay_time)/4;//4 asm code,checking from disassembly code
  while(delay_time--){
  }
}
void sdramc_pall(int sdramc_base_addr){ 
//PALL command set to SDRAM_AC0 reg
SDRAM_AC0 |= SDRAM_AC_IP_MASK;

//   printf("SDRAM_AC0 = 0x%x\n",SDRAM_AC0);

//Preform PALL to SDRAM 
sdramc_write8(sdramc_base_addr, 0xFF);

//  printf("SDRAM_AC0 = 0x%x\n",SDRAM_AC0);

//Wait Trp time, 20ns is good enough for SDRAM Spec
//no code need here, function return is long enough
 }

void sdramc_mrs(int sdramc_base_addr,int burst_length, int burst_type, int cas_latency, int op_mode, int write_burst_mode){

  int mrs_addr;
  
  mrs_addr = 0;
  
  //take care here, MRS address is portsize/column size determind, need to 
  //update the code here accordingly as external memory connection 
  
  
  //MRS address mapping
  //A2-A0: burst length
  //       000->1 
  //       001->2
  //       010->4
  //       011->8
  //       res
  //
  //A3:     burst type
  //        0 -> seq
  //        1 -> Interleave
  //
  //A6-A4: CAS latency
  //       000-> res
  //       001-> 1
  //       010-> 2
  //       011-> 3
  //       res
  //A8-A7: Operationg Mode
  //       00->Stardard Operation
  //       res
  //A9:    Write Burst Mode
  //       0-> Programmed Burst Length
  //       1-> Single Location Access
  
  //MRS address mapping is not in little-endian mode, so modify the mrs command for little-endian
  //sdram address
  //A2-A0
  if(burst_length&0x1){
    mrs_addr |= 1<<SDRAM_A0;
  }
  if(burst_length&0x2){
    mrs_addr |= 1<<SDRAM_A1;
  }
  if(burst_length&0x4){
    mrs_addr |= 1<<SDRAM_A2;
  }  

  //sdram address
  //A3 
  if(burst_type&0x1){
    mrs_addr |= 1<<SDRAM_A3;
  }  
 
  //sdram address
  //A6-A4
  if(cas_latency&0x1){
    mrs_addr |= 1<<SDRAM_A4;
  }
  if(cas_latency&0x2){
    mrs_addr |= 1<<SDRAM_A5;
  }
  if(cas_latency&0x4){
    mrs_addr |= 1<<SDRAM_A6;
  }  


 
  //sdramc      sdram address
  //A8-A7
  if(op_mode&0x1){
    mrs_addr |= 1<<SDRAM_A7;
  }
  if(op_mode&0x2){
    mrs_addr |= 1<<SDRAM_A8;
  }
    
  //sdramc      sdram address
  //A9
  if(write_burst_mode&0x1){
    mrs_addr |= 1<<SDRAM_A9;
  }
  
  //MRS command
 SDRAM_AC0 |= SDRAM_AC_IMRS_MASK;
 
// printf("SDRAM_AC0 = 0x%x\n",SDRAM_AC0);
 
 mrs_addr = sdramc_base_addr + mrs_addr;
 
 sdramc_write8(mrs_addr, 0xaa);
 
// printf("SDRAM_AC0 = 0x%x\n",SDRAM_AC0);
 
}
void sdramc_init(int core_clock_freq_khz)
{
    int   SDRAM_BASE_ADDRESS = 0x70000000;
    int   sdramc_clk_khz;
    int   sdram_rc;

    sdramc_clk_khz = core_clock_freq_khz / (((SIM_CLKDIV1 & SIM_CLKDIV1_OUTDIV3_MASK) >> 20)+ 1);

    /* Enable all of the port clocks. These have to be enabled to configure
    * pin muxing options, so most code will need all of these on anyway.
    */
    SIM_SCGC5 |= (SIM_SCGC5_PORTA_MASK
              | SIM_SCGC5_PORTB_MASK
              | SIM_SCGC5_PORTC_MASK
              | SIM_SCGC5_PORTD_MASK
              | SIM_SCGC5_PORTE_MASK );

    clkout_init();
    SIM_SCGC7 |= SIM_SCGC7_SDRAMC_MASK|SIM_SCGC7_FLEXBUS_MASK;
    //fb_byte select and sdram_dqm functionality enabled, otherwise, no sdram_dqm output
    FB_CSPMCR = FB_CSPMCR_GROUP2(2)|FB_CSPMCR_GROUP3(2)|FB_CSPMCR_GROUP4(2)|FB_CSPMCR_GROUP5(2);
    //disable flexbus clock after CSPMCR write to avoid unexpected behavioral
    SIM_SCGC7 &= ~SIM_SCGC7_FLEXBUS_MASK;

    //init SDRAMC GPIOs
    sdramc_gpio_init();

    //wait 100us
    delay_time_us(core_clock_freq_khz/1000, 100);

    //21MHz, 4096 ROWs, 64ms
    //1. each row refresh time = (64ms/4096)= 15.625us
    //2. bus clock cycles = 21MHz * 15.625 = 328.125 = 328
    //3. RC = 328/16  - 1 = 20.5 - 1 = 20 -1 = 19 = 0x13
    sdram_rc = (int)(((float)(sdramc_clk_khz/1000)*(float)(64000/4096))/16 - 1);
    SDRAM_CTRL = SDRAM_CTRL_RTIM(1)|SDRAM_CTRL_RC(sdram_rc);
    //Set Base address
    SDRAM_AC0 = SDRAM_BASE_ADDRESS|SDRAM_AC_CASL(1)|SDRAM_AC_CBM(3)|SDRAM_AC_PS(0);
    // 64M Byte 
    SDRAM_CM0 = 0x00FF0001;

    //PALL command
    sdramc_pall(SDRAM_BASE_ADDRESS);

    //Refresh command
    SDRAM_AC0 |= SDRAM_AC_RE_MASK;
    //wait 8 refresh commands
    delay_time_us(core_clock_freq_khz/1000, 8*16);

    sdramc_mrs(SDRAM_BASE_ADDRESS,BURSTLENGTH,BURSTTYPE,CASLATENCY,OPMODE,WRITEBURSTMODE);
}

void sdramc_ernter_self(void)
{
  //init self refresh command to external SDRAM
  SDRAM_CTRL |= SDRAM_CTRL_IS_MASK; 
}

void sdramc_exits_elf(void)
{
    //exit self refresh command to external SDRAM
    SDRAM_CTRL &= ~SDRAM_CTRL_IS_MASK;
}








