/*******************
 *
 * Copyright 1998-2003 IAR Systems.  All rights reserved.
 *
 * $Revision: 38614 $
 *
 * This is a template implementation of the "__write" function used by
 * the standard library.  Replace it with a system-specific
 * implementation.
 *
 * The "__write" function should output "size" number of bytes from
 * "buffer" in some application-specific way.  It should return the
 * number of characters written, or _LLIO_ERROR on failure.
 *
 * If "buffer" is zero then __write should perform flushing of
 * internal buffers, if any.  In this case "handle" can be -1 to
 * indicate that all handles should be flushed.
 *
 * The template implementation below assumes that the application
 * provides the function "MyLowLevelPutchar".  It should return the
 * character written, or -1 on failure.
 *
 ********************/
#include <yfuns.h>
#include "common.h"
#ifdef LPUART_DEMO
#include "lpuart.h"
#else
#include "uart.h"
#endif

#ifndef CONSOLE_SUPPORT

_STD_BEGIN

#pragma module_name = "?__write"

void uart_putchar (UART_MemMapPtr, char);

/*
 * If the __write implementation uses internal buffering, uncomment
 * the following line to ensure that we are called with "buffer" as 0
 * (i.e. flush) when the application terminates.
 */

size_t __write(int handle, const unsigned char * buffer, size_t size)
{
  /* Remove the #if #endif pair to enable the implementation */
#if 1    

  size_t nChars = 0;

  if (buffer == 0)
  {
    /*
     * This means that we should flush internal buffers.  Since we
     * don't we just return.  (Remember, "handle" == -1 means that all
     * handles should be flushed.)
     */
    return 0;
  }

  /* This template only writes to "standard out" and "standard err",
   * for all other file handles it returns failure. */
  if (handle != _LLIO_STDOUT && handle != _LLIO_STDERR)
  {
    return _LLIO_ERROR;
  }

  for (/* Empty */; size != 0; --size)
  {
#if 1
#ifdef LPUART_DEMO
    if( *buffer == '\n')
      lpuart_putchar(LPTERM_PORT, '\r'); //return carriage
    lpuart_putchar(LPTERM_PORT, *buffer++); /*doesnt return error number*/
#else
    if( *buffer == '\n')
      uart_putchar(TERM_PORT,'\r'); //return carriage
    uart_putchar(TERM_PORT,*buffer++); /*doesnt return error number*/
#endif
#endif
    
    ++nChars;
  }

  return nChars;

#else

  /* Always return error code when implementation is disabled. */
  return _LLIO_ERROR;

#endif

}

_STD_END

#endif