/**
  Copyright (c) 2013 - 2014 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	DAL.h
  \brief    	
  \author   	Freescale Semiconductor
  \author         SASD Automotive     
  \author    R11515
  \version    
  \date     	
  \warning    (If needed)

  * History:
  
*/
#ifndef _DAL_H
#define _DAL_H

/*
 **************************************************************
 * Defines, Macros and Typedefs 
 **************************************************************/
/* Constant Macros */
#define DERIVATIVE_ADDRESS    ((UINT16)0xE0A2u)
#define PT_DERIVATIVE         (*(UINT8*)DERIVATIVE_ADDRESS)
#define TWO_AXIS_DERIVATIVE_1 ((UINT8)0x5Bu)
#define TWO_AXIS_DERIVATIVE_2 ((UINT8)0x1Bu)
#define ONE_AXIS_DERIVATIVE_1 ((UINT8)0x5Au)
#define ONE_AXIS_DERIVATIVE_2 ((UINT8)0x6Au)
#define ONE_AXIS_DERIVATIVE_3 ((UINT8)0x1Au)

/* --- 2-axes derivative calls --- */
#define TWO_AXES_RESET              ((UINT16)0xE000) 
#define TWO_AXES_READ_VOLT          ((UINT16)0xE003) 
#define TWO_AXES_COMP_VOLT          ((UINT16)0xE006) 
#define TWO_AXES_READ_TEMP          ((UINT16)0xE009) 
#define TWO_AXES_COMP_TEMP          ((UINT16)0xE00C) 
#define TWO_AXES_READ_PRESSURE      ((UINT16)0xE00F) 
#define TWO_AXES_COMP_PRESSURE      ((UINT16)0xE012) 
#define TWO_AXES_READ_ACCEL_X       ((UINT16)0xE015)
#define TWO_AXES_READ_DYN_X         ((UINT16)0xE018) 
#define TWO_AXES_COMP_X             ((UINT16)0xE01B)
#define TWO_AXES_READ_ACCEL_Z       ((UINT16)0xE01E) 
#define TWO_AXES_READ_DYN_Z         ((UINT16)0xE021) 
#define TWO_AXES_COMP_Z             ((UINT16)0xE024) 
#define TWO_AXES_READ_ACCEL_XZ      ((UINT16)0xE027) 
#define TWO_AXES_READ_DYN_XZ        ((UINT16)0xE02A) 
#define TWO_AXES_COMP_XZ            ((UINT16)0xE02D) 
#define TWO_AXES_READ_V0            ((UINT16)0xE030) 
#define TWO_AXES_READ_V1            ((UINT16)0xE033) 
#define TWO_AXES_LFOCAL             ((UINT16)0xE036) 
#define TWO_AXES_MFOCAL             ((UINT16)0xE039)
#define TWO_AXES_RF_ENABLE          ((UINT16)0xE03C)
#define TWO_AXES_RF_RESET           ((UINT16)0xE03F) 
#define TWO_AXES_RF_READ_DATA       ((UINT16)0xE042) 
#define TWO_AXES_RF_READ_DATA_R     ((UINT16)0xE045) 
#define TWO_AXES_RF_WRITE_DATA      ((UINT16)0xE048) 
#define TWO_AXES_RF_WRITE_DATA_R    ((UINT16)0xE04B) 
#define TWO_AXES_RF_CONFIG_DATA     ((UINT16)0xE04E)
/* Reserved */ 
#define TWO_AXES_RF_SET_TX          ((UINT16)0xE054) 
#define TWO_AXES_RF_DYN_POWER       ((UINT16)0xE057)
#define TWO_AXES_MSG_INIT           ((UINT16)0xE05A) 
#define TWO_AXES_MSG_READ           ((UINT16)0xE05D) 
#define TWO_AXES_MSG_WRITE          ((UINT16)0xE060) 
#define TWO_AXES_CHECKSUM_XOR       ((UINT16)0xE063) 
#define TWO_AXES_CRC8               ((UINT16)0xE066) 
#define TWO_AXES_CRC16              ((UINT16)0xE069) 
#define TWO_AXES_SQRT               ((UINT16)0xE06C) 
#define TWO_AXES_READ_ID            ((UINT16)0xE06F) 
#define TWO_AXES_LF_ENABLE          ((UINT16)0xE072) 
#define TWO_AXES_LF_READ_DATA       ((UINT16)0xE075) 
#define TWO_AXES_WIRE_AND_ADC_CHECK ((UINT16)0xE078) 
#define TWO_AXES_FLASH_WRITE        ((UINT16)0xE07B) 
#define TWO_AXES_FLASH_CHECK        ((UINT16)0xE07E) 
#define TWO_AXES_FLASH_ERASE        ((UINT16)0xE081) 
#define TWO_AXES_FLASH_PROTECT      ((UINT16)0xE084)
/* Reserved */
#define TWO_AXES_MULT_SIGN_INT16    ((UINT16)0xE08A)
#define TWO_AXES_WAVG               ((UINT16)0xE08D) 
#define TWO_AXES_RDE                ((UINT16)0xE090)

/* --- 2-axes UUMA indices */
#define TWO_AXES_V_INDEX  ((UINT8)0u)
#define TWO_AXES_T_INDEX  ((UINT8)1u)
#define TWO_AXES_P_INDEX  ((UINT8)2u)
#define TWO_AXES_X_INDEX  ((UINT8)3u)
#define TWO_AXES_Z_INDEX  ((UINT8)4u)


/* --- 1-axis derivative calls --- */
#define ONE_AXIS_RESET              ((UINT16)0xE000) 
#define ONE_AXIS_READ_VOLT          ((UINT16)0xE003) 
#define ONE_AXIS_COMP_VOLT          ((UINT16)0xE006) 
#define ONE_AXIS_READ_TEMP          ((UINT16)0xE009) 
#define ONE_AXIS_COMP_TEMP          ((UINT16)0xE00C) 
#define ONE_AXIS_READ_PRESSURE      ((UINT16)0xE00F) 
#define ONE_AXIS_COMP_PRESSURE      ((UINT16)0xE012) 
#define ONE_AXIS_READ_ACCEL         ((UINT16)0xE015) 
#define ONE_AXIS_COMP_ACCEL         ((UINT16)0xE018) 
#define ONE_AXIS_READ_V0            ((UINT16)0xE01B) 
#define ONE_AXIS_READ_V1            ((UINT16)0xE01E) 
#define ONE_AXIS_LFOCAL             ((UINT16)0xE021) 
#define ONE_AXIS_MFOCAL             ((UINT16)0xE024) 
#define ONE_AXIS_WAVG               ((UINT16)0xE027) 
#define ONE_AXIS_RF_RESET           ((UINT16)0xE02A) 
#define ONE_AXIS_RF_READ_DATA       ((UINT16)0xE02D) 
#define ONE_AXIS_RF_READ_DATA_R     ((UINT16)0xE030) 
#define ONE_AXIS_RF_WRITE_DATA      ((UINT16)0xE033) 
#define ONE_AXIS_RF_WRITE_DATA_R    ((UINT16)0xE036) 
#define ONE_AXIS_RF_CONFIG_DATA     ((UINT16)0xE039)
#define ONE_AXIS_RF_SET_TX          ((UINT16)0xE03F) 
#define ONE_AXIS_RF_DYN_POWER       ((UINT16)0xE042) 
#define ONE_AXIS_MSG_INIT           ((UINT16)0xE045) 
#define ONE_AXIS_MSG_READ           ((UINT16)0xE048) 
#define ONE_AXIS_MSG_WRITE          ((UINT16)0xE04B) 
#define ONE_AXIS_CHECKSUM_XOR       ((UINT16)0xE04E) 
#define ONE_AXIS_CRC8               ((UINT16)0xE051) 
#define ONE_AXIS_CRC16              ((UINT16)0xE054) 
#define ONE_AXIS_SQRT               ((UINT16)0xE057) 
#define ONE_AXIS_READ_ID            ((UINT16)0xE05A) 
#define ONE_AXIS_LF_ENABLE          ((UINT16)0xE05D) 
#define ONE_AXIS_LF_READ_DATA       ((UINT16)0xE060) 
#define ONE_AXIS_WIRE_AND_ADC_CHECK ((UINT16)0xE063) 
#define ONE_AXIS_FLASH_WRITE        ((UINT16)0xE066) 
#define ONE_AXIS_FLASH_CHECK        ((UINT16)0xE069) 
#define ONE_AXIS_FLASH_ERASE        ((UINT16)0xE06C) 
#define ONE_AXIS_READ_DYN_ACCEL     ((UINT16)0xE06F)
#define ONE_AXIS_RF_ENABLE          ((UINT16)0xE072) 
#define ONE_AXIS_FLASH_PROTECT      ((UINT16)0xE075)
#define ONE_AXIS_MULT_SIGN_INT16    ((UINT16)0xE07B)
#define ONE_AXIS_VREG_CHECK         ((UINT16)0xE07E)
#define ONE_AXIS_PRECHARGE_VREG     ((UINT16)0xE081)
#define ONE_AXIS_RDE                ((UINT16)0xE084)
#define ONE_AXIS_ACCEL_CONT_START   ((UINT16)0xE087)
#define ONE_AXIS_ACCEL_CONT         ((UINT16)0xE08A)
#define ONE_AXIS_ACCEL_CONT_STOP    ((UINT16)0xE08D)

/* --- 1-axis UUMA indices */
#define ONE_AXIS_V_INDEX  ((UINT8)0u)
#define ONE_AXIS_T_INDEX  ((UINT8)1u)
#define ONE_AXIS_P_INDEX  ((UINT8)2u)
#define ONE_AXIS_Z_INDEX  ((UINT8)3u)
#define ONE_AXIS_X_INDEX  ((UINT8)4u)

/* When a fn is not available in a derivative */
#define NO_EQUIVALENT_FN            ((UINT16)0xFFFF)

/* Function Macros */

/* void TPMS_RESET(void) */
#define TPMS_RESET         gu16AddressToFn = u16fnDALLinkFmw(gu8Derivative, FN_RESET);\
                           ((void(*)(void))(gu16AddressToFn))

/* UINT8 TPMS_READ_VOLTAGE(UINT16 *u16UUMA) */
#define  TPMS_READ_VOLTAGE  ((UINT8(*)(UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_READ_VOLT)))
                            
/* UINT8 TPMS_COMP_VOLTAGE(UINT8 *u8CompVoltage, *UINT16 u16UUMA) */
#define  TPMS_COMP_VOLTAGE  ((UINT8(*)(UINT8*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_COMP_V)))
                            
/* UINT8 TPMS_READ_TEMPERATURE(UINT16 *u16UUMA) */
#define  TPMS_READ_TEMPERATURE  ((UINT8(*)(UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_READ_T)))

/* UINT8 TPMS_COMP_TEMPERATURE(UINT8 *u8Temp, UINT16 *u16UUMA) */
#define  TPMS_COMP_TEMPERATURE   ((UINT8(*)(UINT8*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_COMP_T)))

/* UINT8 TPMS_READ_PRESSURE(UINT16 *u16UUMA, UINT8 u8Avg) */
#define  TPMS_READ_PRESSURE    ((UINT8(*)(UINT16*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_READ_P)))

/* UINT8 TPMS_COMP_PRESSURE(UINT16 *u16CompPressure, UINT16 *u16UUMA) */
#define  TPMS_COMP_PRESSURE    ((UINT8(*)(UINT16*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_COMP_P)))    

/* UINT8 TPMS_READ_ACCEL_X(UINT16 *u16UUMA, UINT8 u8Avg, UINT8 u8FiltSelect, UINT8 u8DynamicOffset) */
#define  TPMS_READ_ACCEL_X  ((UINT8(*)(UINT16*, UINT8, UINT8, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_READ_X)))

/* UINT8 TPMS_READ_ACCEL_Z(UINT16 *u16UUMA, UINT8 u8Avg, UINT8 u8FiltSelect, UINT8 u8DynamicOffset) */
#define  TPMS_READ_ACCEL_Z ((UINT8(*)(UINT16*, UINT8, UINT8, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_READ_Z)))
                          
/* UINT8 TPMS_READ_ACCEL_XZ(UINT16 *u16UUMA, UINT8 u8Avg, UINT8 u8FiltSelect, UINT8 u8DynamicOffsetX, UINT8 u8DynamicOffsetZ) */
#define  TPMS_READ_ACCEL_XZ ((UINT8(*)(UINT16*, UINT8, UINT8, UINT8, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_READ_XZ)))

/* UINT8 TPMS_READ_DYNAMIC_ACCEL_X(UINT8 u8Filter, UINT8* u8Offset, UINT16* u16UUMA) */
#define  TPMS_READ_DYNAMIC_ACCEL_X ((UINT8(*)(UINT8, UINT8*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_DYN_X)))

/* UINT8 TPMS_READ_DYNAMIC_ACCEL_Z(UINT8 u8Filter, UINT8* u8Offset, UINT16* u16UUMA) */
#define  TPMS_READ_DYNAMIC_ACCEL_Z ((UINT8(*)(UINT8, UINT8*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_DYN_Z)))
                                   
/* UINT8 TPMS_READ_DYNAMIC_ACCEL_XZ(UINT8 u8Filter, UINT8* u8OffsetX, UINT8* u8OffsetZ, UINT16* u16UUMA) */
#define  TPMS_READ_DYNAMIC_ACCEL_XZ ((UINT8(*)(UINT8, UINT8*, UINT8*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_DYN_XZ)))
                                   
/* UINT8 TPMS_COMP_ACCEL_X(UINT16 *u16CompAccelX, UINT16* u16UUMA) */
#define  TPMS_COMP_ACCEL_X ((UINT8(*)(UINT16*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_COMP_X)))
                           
/* UINT8 TPMS_COMP_ACCEL_Z(UINT16 *u16CompAccelX, UINT16* u16UUMA) */
#define  TPMS_COMP_ACCEL_Z ((UINT8(*)(UINT16*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_COMP_Z)))
                           
/* UINT8 TPMS_COMP_ACCEL_XZ(UINT16 *u16CompAccelX, UINT16* u16UUMA) */
#define  TPMS_COMP_ACCEL_XZ ((UINT8(*)(UINT16*, UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_COMP_XZ)))
                                   
/* UINT8 TPMS_READ_V0(UINT16 *u16Result, UINT8 u8Avg) */
#define  TPMS_READ_V0         ((UINT8(*)(UINT16*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_READ_V0)))
                              
/* UINT8 TPMS_READ_V1(UINT16 *u16Result, UINT8 u8Avg) */
#define  TPMS_READ_V1         ((UINT8(*)(UINT16*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_READ_V1)))

/* UINT8 TPMS_LFOCAL(void) */
#define  TPMS_LFOCAL		      ((UINT8(*)(void))(u16fnDALLinkFmw(gu8Derivative, FN_LFOCAL)))
                              
/* UINT8 TPMS_MFOCAL(void) */
#define  TPMS_MFOCAL		      ((UINT8(*)(void))(u16fnDALLinkFmw(gu8Derivative, FN_MFOCAL)))
                              
/* UINT16 TPMS_WAVG(UINT8 u8Avg, UINT16 u16POld, UINT8 u8PNew) */
#define  TPMS_WAVG            ((UINT16(*)(UINT8, UINT16, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_WAVG)))

/* UINT8 TPMS_RF_ENABLE(UINT8 u8Switch) */
#define  TPMS_RF_ENABLE ((void(*)(UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_RF_ENABLE)))

/* void  TPMS_RF_RESET(void) */
#define  TPMS_RF_RESET        ((void(*)(void))(u16fnDALLinkFmw(gu8Derivative, FN_RF_RST)))
                              
/* void  TPMS_RF_READ_DATA(UINT8 u8Size, UINT8 *u8RAMBuffer, UINT8 u8RFMBuffer) */
#define  TPMS_RF_READ_DATA ((void(*)(UINT8, UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_RF_READ_DATA)))

/* void  TPMS_RF_READ_DATA_REVERSE(UINT8 u8Size, UINT8 *u8RAMBuffer, UINT8 u8RFMBuffer) */
#define  TPMS_RF_READ_DATA_REVERSE  ((void(*)(UINT8, UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_RF_READ_DATA_R)))

/* void  TPMS_RF_WRITE_DATA(UINT8 u8Size, UINT8 *u8RAMBuffer, UINT8 u8RFMBuffer) */
#define  TPMS_RF_WRITE_DATA  ((void(*)(UINT8, UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_RF_WRITE_DATA)))

/* void  TPMS_RF_WRITE_DATA_REVERSE(UINT8 u8Size, UINT8 *u8RAMBuffer, UINT8 u8RFMBuffer) */
#define  TPMS_RF_WRITE_DATA_REVERSE  ((void(*)(UINT8, UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_RF_WRITE_DATA_R)))

/* void  TPMS_RF_CONFIG_DATA(UINT16 *u16RFParam) */
#define  TPMS_RF_CONFIG_DATA   ((void(*)(UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_RF_CONFIG_DATA)))

/* void  TPMS_RF_SET_TX(UINT8 u8BufferSize) */
#define  TPMS_RF_SET_TX	       ((void(*)(UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_RF_SET_TX)))

/* void  TPMS_RF_DYNAMIC_POWER(UINT8 u8CompT, UINT8 u8CompV, UINT8* pu8PowerManagement) */
#define  TPMS_RF_DYNAMIC_POWER  ((void(*)(UINT8, UINT8, UINT8*))(u16fnDALLinkFmw(gu8Derivative, FN_RF_DYN_POWER)))

/* void  TPMS_MSG_INIT(void) */
#define  TPMS_MSG_INIT       ((void(*)(void))(u16fnDALLinkFmw(gu8Derivative, FN_MSG_INIT)))

/* UINT8 TPMS_MSG_WRITE(UINT8 u8SendByte) */
#define  TPMS_MSG_WRITE		   ((UINT8(*)(UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_MSG_READ)))
                           
/* UINT8 TPMS_MSG_READ(void) */
#define  TPMS_MSG_READ		    ((UINT8(*)(void))(u16fnDALLinkFmw(gu8Derivative, FN_MSG_WRITE)))

/* UINT8 TPMS_CHECKSUM_XOR(UINT8 *u8Buffer, UINT8 u8Size, UINT8 u8Checksum) */
#define  TPMS_CHECKSUM_XOR    ((UINT8(*)(UINT8*, UINT8, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_XOR)))

/* UINT16 TPMS_CRC16(UINT8 *u8Buffer, UINT16 u16MByteSize, UINT16 u16Remainder) */
#define  TPMS_CRC16				    ((UINT16(*)(UINT8*, UINT16,  UINT16))(u16fnDALLinkFmw(gu8Derivative, FN_CRC16)))

/* UINT16 TPMS_SQUARE_ROOT(UINT16 u16Process) */
#define  TPMS_SQUARE_ROOT	    ((UINT16(*)(UINT16))(u16fnDALLinkFmw(gu8Derivative, FN_SQRT)))

/* UINT8 TPMS_READ_ID(UINT8 *u8Code) */
#define  TPMS_READ_ID		      ((void(*)(UINT8*))(u16fnDALLinkFmw(gu8Derivative, FN_READ_ID)))

/* void  TPMS_LF_ENABLE(UINT8 u8Switch) */
#define  TPMS_LF_ENABLE	      ((void(*)(UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_LF_ENABLE)))

/* UINT8 TPMS_LF_READ_DATA(UINT8 *u8Buffer, UINT8 u8Count) */
#define  TPMS_LF_READ_DATA  ((UINT8(*)(UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_LF_READ_DATA)))

/* UINT8 TPMS_WIRE_AND_ADC_CHECK(UINT8 u8TestMask) */
#define  TPMS_WIRE_AND_ADC_CHECK  ((UINT8(*)(UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_WIRE_CHECK)))

/* void  TPMS_FLASH_WRITE(UINT16 u16Address, UINT8* u8Buffer, UINT8 u8Size) */
#define  TPMS_FLASH_WRITE   ((void(*)(UINT16, UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_FLASH_WRITE)))

/* UINT16 TPMS_FLASH_CHECK(void) */
#define  TPMS_FLASH_CHECK   ((void(*)(UINT16, UINT8*, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_FLASH_CHECK)))

/* UINT8 TPMS_FLASH_ERASE(UINT16 u16Address) */
#define  TPMS_FLASH_ERASE   ((UINT8(*)(UINT16))(u16fnDALLinkFmw(gu8Derivative, FN_FLASH_ERASE)))

/* UINT8 TPMS_FLASH_PROTECTION(UINT16 u16Key) */
#define  TPMS_FLASH_PROTECTION  ((UINT8(*)(UINT16))(u16fnDALLinkFmw(gu8Derivative, FN_FLASH_PROT)))
                               
/* void TPMS_MULT_SIGN_INT16(INT16 i16Mult1, INT16 i16Mult2, INT32* pi32Result) */
#define  TPMS_MULT_SIGN_INT16    ((void(*)(INT16, INT16, INT32*))(u16fnDALLinkFmw(gu8Derivative, FN_MULT16)))

/* void TPMS_VREG_CHECK(UINT8 u8WaitTime, UINT16 u16LimitDelta) */
#define TPMS_VREG_CHECK          ((void(*)(UINT8, UINT16))(u16fnDALLinkFmw(gu8Derivative, FN_VREG_CHECK)))

/* void TPMS_PRECHARGE_VREG(UINT8 u8WaitUnits, UINT8 u8PTAMask) */
#define  TPMS_PRECHARGE_VREG  ((void(*)(UINT8, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_VREG_PRECHARGE)))

/* UINT8 TPMS_RDE_ADJUST_PRESSURE(UINT16* pu16UUMA, T_RDE* ptRDEValues) */
#define TPMS_RDE_ADJUST_PRESSURE  ((UINT8(*)(UINT16*, T_RDE*))(u16fnDALLinkFmw(gu8Derivative, FN_RDE)))

/* UINT8 TPMS_READ_ACCEL_CONT_START(UINT8 u8Filter, UINT8 u8DynamicOffset, UINT8 u8SampleSpeed) */
#define TPMS_READ_ACCEL_CONT_START ((UINT8(*)(UINT8, UINT8, UINT8))(u16fnDALLinkFmw(gu8Derivative, FN_CONT_ACCEL_START)))

/* UINT8 TPMS_READ_ACCEL_CONT(UINT16* pu16Measurement) */
#define TPMS_READ_ACCEL_CONT  ((UINT8(*)(UINT16*))(u16fnDALLinkFmw(gu8Derivative, FN_CONT_ACCEL)))

/* UINT8 TPMS_READ_ACCEL_CONT_STOP(void) */
#define TPMS_READ_ACCEL_CONT_STOP ((UINT8(*)(void))(u16fnDALLinkFmw(gu8Derivative, FN_CONT_ACCEL_STOP)))

/* Redefine UUMA indices to access values in FLASH */
/*! Macro below disguises access to correct index within UUMA, independent of derivative */
#define UUMA_VOLT (cau8UUMAIndexPerDerivative[gu8Derivative + UUUMA_V])
/*! Macro below disguises access to correct index within UUMA, independent of derivative */
#define UUMA_TEMP (cau8UUMAIndexPerDerivative[gu8Derivative + UUUMA_T])
/*! Macro below disguises access to correct index within UUMA, independent of derivative */
#define UUMA_PRESSURE (cau8UUMAIndexPerDerivative[gu8Derivative + UUUMA_P])
/*! Macro below disguises access to correct index within UUMA, independent of derivative */
#define UUMA_X (cau8UUMAIndexPerDerivative[gu8Derivative + UUUMA_X])
/*! Macro below disguises access to correct index within UUMA, independent of derivative */
#define UUMA_Z (cau8UUMAIndexPerDerivative[gu8Derivative + UUUMA_Z])


#define SIZE_OF_UUMA_ARRAY ((UINT8)5u)
/* Enums */
enum DERIVATIVE_INDICES
{
  TWO_AXIS_DERIVATIVE_INDEX = 0, ONE_AXIS_DERIVATIVE_INDEX,
  INVALID_DERIVATIVE = 0xFF
};

/*! Used as a common index for all functions, regardless of the 
 *  derivative.
 */
enum UNIVERSAL_FN_INDEX
{
  FN_RESET = 0, FN_READ_VOLT, FN_COMP_V, FN_READ_T, 
  FN_COMP_T, FN_READ_P, FN_COMP_P, FN_READ_X, FN_DYN_X, 
  FN_COMP_X, FN_READ_Z, FN_DYN_Z, FN_COMP_Z, FN_READ_XZ,
  FN_DYN_XZ, FN_COMP_XZ, FN_READ_V0, FN_READ_V1, FN_LFOCAL,
  FN_MFOCAL, FN_RF_ENABLE, FN_RF_RST, FN_RF_READ_DATA, 
  FN_RF_READ_DATA_R, FN_RF_WRITE_DATA, FN_RF_WRITE_DATA_R,
  FN_RF_CONFIG_DATA, FN_RF_SET_TX, FN_RF_DYN_POWER, FN_MSG_INIT,
  FN_MSG_READ, FN_MSG_WRITE, FN_XOR, FN_CRC8, FN_CRC16, FN_SQRT,
  FN_READ_ID, FN_LF_ENABLE, FN_LF_READ_DATA, FN_WIRE_CHECK, 
  FN_FLASH_WRITE, FN_FLASH_CHECK, FN_FLASH_ERASE, FN_FLASH_PROT, FN_MULT16, 
  FN_WAVG, FN_RDE, FN_VREG_CHECK, FN_VREG_PRECHARGE, FN_CONT_ACCEL_START,
  FN_CONT_ACCEL, FN_CONT_ACCEL_STOP
};
/*! Universal UUMA index, independent of derivative */
enum UNIVERSAL_UUMA_INDEX
{
  UUUMA_V = 0, UUUMA_T = 2, UUUMA_P = 4, UUUMA_X = 6, UUUMA_Z = 8
};
/* TypeDefs */

/*
 **************************************************************
 * Declarations 
 **************************************************************/
#pragma DATA_SEG BATTERY_BACKED_RAM
extern UINT8 gu8Derivative;
extern UINT8 TPMS_INTERRUPT_FLAG;
#pragma DATA_SEG DEFAULT
extern const UINT8 cau8UUMAIndexPerDerivative[SIZE_OF_UUMA_ARRAY * 2u];
/*
 **************************************************************
 * Function Prototypes 
 **************************************************************/
/*
 *******************************************************************************
 *
 * Function:          u8fnDALDetectDerivative()
 *
 */
/*!
 * \brief    Initial function that needs to be called in order to determine
 *           derivative and store it into gu8Derivative.
 * \param    None.
 * \return   gu8Derivative - derivative as defined by DERIVATIVE_INDICES.
 *
 *****************************************************************************/
UINT8 u8fnDALDetectDerivative(void);
/*
 *******************************************************************************
 *
 * Function:          u16fnDALLinkFmw()
 *
 */
/*!
 * \brief    Callable once gu8Derivative has been set, this function determines
 *           the jump table address of a given function. Its return value 
 *           can then be used to call the function.
 * \param    u8DerivativeTableIndex - Derivative indicator as listed by
 *           DERIVATIVE_INDICES. Typically, gu8Derivative shall be used.
 * \param    u8NormalizedFnIndex - normalized function index, as defined by
 *           UNIVERSAL_FN_INDEX. 
 * \return   Firmware jump table address to be used for that particular
 *           function on the given derivative.
 *
 *****************************************************************************/
UINT16 u16fnDALLinkFmw(UINT8 u8DerivativeTableIndex, UINT8 u8NormalizedFnIndex);
#endif /* _FILENAME_H */