/**
  Copyright (c) 2012 - 2014 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Szk_LF_Data_Detect.h
  \brief    	Configures the device for Data detect and goes to sleep.
              When woken-up, PTA2 goes high until PTA0 has a fallen edge.
  \author   	Freescale Semiconductor
  \author         SSD Automotive     
  \author   	R11515
  \version    
  \date     	

  * History:
  
*/

#ifndef _SZK_LF_DATA_H
#define _SZK_LF_DATA_H

/*
 **************************************************************
 * Defines, Macros and Typedefs 
 **************************************************************/
/* Constant Macros */
#define DATAGRAM_SIZE ((UINT8)4u)

/* LF register masks et al. */

#define IDSEL_TYPE_NO_ID                  ((UINT8)0x0u)
#define IDSEL_TYPE_LFIDL                  ((UINT8)0x1u)
#define IDSEL_TYPE_16_BIT                 ((UINT8)0x2u)
#define IDSEL_TYPE_LFIDL_OR_LFIDH         ((UINT8)0x3u)

#define LFCTL3_T9_PATTERN                 ((UINT8)0x30u)
#define LFCTL3_CARRIER_DETECT_64_USEC     ((UINT8)0x00u)
#define LFCTL3_CARRIER_DETECT_128_USEC    ((UINT8)0x01u)
#define LFCTL3_CARRIER_DETECT_256_USEC    ((UINT8)0x02u)
#define LFCTL3_CARRIER_DETECT_512_USEC    ((UINT8)0x03u)
#define LFCTL3_CARRIER_DETECT_1024_USEC   ((UINT8)0x04u)
#define LFCTL3_DATA_DETECT_EQUALS_CARRIER ((UINT8)0x10u)

#define LFCTL4_SYNC_SET_TO_0_MSEC         ((UINT8)0u)
#define LFCTL4_SYNC_SET_TO_8_MSEC         ((UINT8)1u)
#define LFCTL4_SYNC_SET_TO_24_MSEC        ((UINT8)2u)
#define LFCTL4_SYNC_SET_TO_48_MSEC        ((UINT8)3u)

#define DEFAULT_CHK125_SETTING            ((UINT8)BIT0)

/* Function Macros */

/* Enums */

/* TypeDefs */

/*
 **************************************************************
 * Declarations 
 **************************************************************/
/* Extern */
#pragma DATA_SEG PARAM_SEC
extern UINT8 gau8DataBuffer[DATAGRAM_SIZE];
#pragma DATA_SEG DEFAULT
/* Globals */

/* Static Globals */

/*
 **************************************************************
 * Function Prototypes 
 **************************************************************/
void vfnClearReceivedBuffer(void);
void vfnDataDetect(void);
void vfnDataModeInit(void);
UINT8 u8fnDataValidData(void);
void vfnDataIsr(void);
#endif /* _FILENAME_H */
